/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfoImpl;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;

class MethodHandleInfo {
    public static final int REF_getField = 1;
    public static final int REF_getStatic = 2;
    public static final int REF_putField = 3;
    public static final int REF_putStatic = 4;
    public static final int REF_invokeVirtual = 5;
    public static final int REF_invokeStatic = 6;
    public static final int REF_invokeSpecial = 7;
    public static final int REF_newInvokeSpecial = 8;
    public static final int REF_invokeInterface = 9;
    private MethodHandleInfoImpl impl;

    public MethodHandleInfo(MethodHandle methodHandle) {
        Class definingClass = methodHandle.definingClass;
        boolean isValid = true;
        String packageName = MethodHandles.Lookup.getVMLangAccess().getPackageName(definingClass);
        if ("java.lang.invoke".equals(packageName) && !Modifier.isPublic(methodHandle.rawModifiers)) {
            isValid = false;
        }
        this.impl = methodHandle.getInfo();
        if (this.impl == null || !isValid) {
            throw new IllegalArgumentException("Invalid MethodHandle for introspection");
        }
    }

    public Class getDeclaringClass() {
        return this.impl.getDeclaringClass();
    }

    public String getName() {
        return this.impl.getName();
    }

    public MethodType getMethodType() {
        return this.impl.getMethodType();
    }

    public int getModifiers() {
        return this.impl.getModifiers();
    }

    public int getReferenceKind() {
        return this.impl.getReferenceKind();
    }

    public String toString() {
        return MethodHandleInfo.getReferenceKindString(this.getReferenceKind()) + " " + this.getDeclaringClass() + ":" + this.getMethodType();
    }

    public static String getReferenceKindString(int referenceKind) {
        switch (referenceKind) {
            case 1: {
                return "getfield";
            }
            case 2: {
                return "getstatic";
            }
            case 3: {
                return "putfield";
            }
            case 4: {
                return "putstatic";
            }
            case 5: {
                return "invokevirtual";
            }
            case 6: {
                return "invokestatic";
            }
            case 7: {
                return "invokespecial";
            }
            case 8: {
                return "newinvokespecial";
            }
            case 9: {
                return "invokeinterface";
            }
        }
        return "UNKNOWN_REFERENCE_KIND[" + referenceKind + "]";
    }
}

