/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VMLangAccess;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.IOUtils;
import sun.misc.Unsafe;

class SecurityFrameInjector {
    static Map<ClassLoader, WeakReference<Class<?>>> LoaderToSecurityFrameClassMap = Collections.synchronizedMap(new WeakHashMap());
    static byte[] securityFrameClassBytes = null;
    static SecurityFrameInjectorLoaderLock loaderLock = new SecurityFrameInjectorLoaderLock();
    private static final int CALLER_SENSITIVE_BIT = 0x100000;

    SecurityFrameInjector() {
    }

    static boolean virtualCallAllowed(MethodHandle handle, Class<?> sensitiveMethodDefiningClass) {
        if (handle.defc == sensitiveMethodDefiningClass) {
            return true;
        }
        int modifiers = handle.rawModifiers;
        if (Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers)) {
            return false;
        }
        return sensitiveMethodDefiningClass.isAssignableFrom(handle.defc) || handle.defc.isInterface();
    }

    static boolean requiresWrappingForSecurityStackWalks(MethodHandle handle, String methodName) {
        return SecurityFrameInjector.isCallerSensitive(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static byte[] initializeSecurityFrameClassBytes() {
        if (securityFrameClassBytes != null) return securityFrameClassBytes;
        Class<SecurityFrameInjector> clazz = SecurityFrameInjector.class;
        synchronized (SecurityFrameInjector.class) {
            if (securityFrameClassBytes != null) return securityFrameClassBytes;
            securityFrameClassBytes = AccessController.doPrivileged(new PrivilegedAction<byte[]>(){

                @Override
                public byte[] run() {
                    try {
                        InputStream is = MethodHandles.Lookup.class.getResourceAsStream("/java/lang/invoke/SecurityFrame.class");
                        return IOUtils.readFully((InputStream)is, (int)-1, (boolean)true);
                    }
                    catch (IOException e) {
                        throw new Error(Msg.getString("K056A"), e);
                    }
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return securityFrameClassBytes;
        }
    }

    static Class<?> probeLoaderToSecurityFrameMap(ClassLoader loader) {
        WeakReference<Class<?>> weakRef = LoaderToSecurityFrameClassMap.get(loader);
        if (weakRef != null) {
            return (Class)weakRef.get();
        }
        return null;
    }

    static MethodHandle wrapHandleWithInjectedSecurityFrame(MethodHandle handle, final Class<?> context) {
        SecurityFrameInjector.initializeSecurityFrameClassBytes();
        boolean isVarargs = MethodHandles.Lookup.isVarargs(handle.rawModifiers) || handle.isVarargsCollector();
        final MethodHandle tempFinalHandle = handle;
        MethodType originalType = handle.type;
        try {
            Object o = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                private Class<?> injectSecurityFrameIntoLoader(ClassLoader loader, ProtectionDomain pd) {
                    return Unsafe.getUnsafe().defineClass("java.lang.invoke.SecurityFrame", securityFrameClassBytes, 0, securityFrameClassBytes.length, loader, pd);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() {
                    VMLangAccess vma = MethodHandles.Lookup.getVMLangAccess();
                    ClassLoader rawLoader = vma.getClassloader(context);
                    Class<?> injectedSecurityFrameClass = SecurityFrameInjector.probeLoaderToSecurityFrameMap(rawLoader);
                    if (injectedSecurityFrameClass == null) {
                        SecurityFrameInjectorLoaderLock securityFrameInjectorLoaderLock = loaderLock;
                        synchronized (securityFrameInjectorLoaderLock) {
                            injectedSecurityFrameClass = SecurityFrameInjector.probeLoaderToSecurityFrameMap(rawLoader);
                            if (injectedSecurityFrameClass == null) {
                                injectedSecurityFrameClass = this.injectSecurityFrameIntoLoader(rawLoader, context.getProtectionDomain());
                                LoaderToSecurityFrameClassMap.put(rawLoader, new WeakReference(injectedSecurityFrameClass));
                            }
                        }
                    }
                    try {
                        Constructor<?> constructor = injectedSecurityFrameClass.getConstructor(MethodHandle.class);
                        constructor.setAccessible(true);
                        return constructor.newInstance(tempFinalHandle);
                    }
                    catch (ReflectiveOperationException | SecurityException e) {
                        throw new Error(e);
                    }
                }
            });
            handle = MethodHandles.Lookup.internalPrivilegedLookup.bind(o, "invoke", MethodType.methodType(Object.class, Object[].class));
            handle = handle.asType(originalType);
            if (isVarargs) {
                handle = handle.asVarargsCollector(originalType.lastParameterType());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new Error(e);
        }
        return handle;
    }

    static MethodHandle wrapHandleWithInjectedSecurityFrameIfRequired(MethodHandles.Lookup lookup, MethodHandle handle, String methodName) throws IllegalAccessException {
        if (SecurityFrameInjector.requiresWrappingForSecurityStackWalks(handle, methodName)) {
            if (lookup.isWeakenedLookup()) {
                throw new IllegalAccessException("caller-sensitive method cannot be looked up using a restricted lookup object");
            }
            handle = SecurityFrameInjector.wrapHandleWithInjectedSecurityFrame(handle, lookup.accessClass);
        }
        return handle;
    }

    static boolean isCallerSensitive(MethodHandle mh) {
        return 0x100000 == (mh.rawModifiers & 0x100000);
    }

    static class SecurityFrameInjectorLoaderLock {
        SecurityFrameInjectorLoaderLock() {
        }
    }
}

