/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkKey;
import java.lang.invoke.ThunkKeyWithObjectArray;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.ThunkTuple;
import java.lang.reflect.Array;

final class SpreadHandle
extends MethodHandle {
    private final MethodHandle next;
    private final Class arrayClass;
    private final int spreadCount;
    private static final ThunkTable _thunkTable = new ThunkTable();

    protected SpreadHandle(MethodHandle next, MethodType collectType, Class arrayClass, int spreadCount) {
        super(collectType, next.definingClass, null, 19, SpreadHandle.infoAffectingThunks(arrayClass, spreadCount));
        this.arrayClass = arrayClass;
        this.spreadCount = spreadCount;
        this.next = next;
    }

    SpreadHandle(SpreadHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.next = originalHandle.next;
        this.arrayClass = originalHandle.arrayClass;
        this.spreadCount = originalHandle.spreadCount;
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    private static Object[] infoAffectingThunks(Class arrayClass, int spreadCount) {
        Object[] result = new Object[]{arrayClass, spreadCount};
        return result;
    }

    @Override
    protected final ThunkTuple computeThunks(Object info) {
        return this.thunkTable().get(new ThunkKeyWithObjectArray(ThunkKey.computeThunkableType(this.type()), (Object[])info));
    }

    private static native int numArgsToPassThrough();

    private static native int numArgsToSpread();

    private static native Object[] arrayArg(int var0);

    private static void checkCast(Class c, Object q) {
        c.cast(q);
    }

    private static void checkArray(Object[] spreadArg, int spreadCount) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (spreadArg == null) {
            if (spreadCount != 0) {
                throw new IllegalArgumentException("cannot have null spread argument unless spreadCount is 0");
            }
        } else if (spreadCount != Array.getLength(spreadArg)) {
            throw new ArrayIndexOutOfBoundsException("expected '" + spreadCount + "' sized array; encountered '" + Array.getLength(spreadArg) + "' sized array");
        }
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int argPlaceholder) {
        if (ILGenMacros.isShareableThunk()) {
            this.undoCustomizationLogic(this.next);
        }
        if (!ILGenMacros.isCustomThunk()) {
            this.doCustomizationLogic();
        }
        SpreadHandle.checkCast(this.arrayClass, SpreadHandle.arrayArg(argPlaceholder));
        SpreadHandle.checkArray(SpreadHandle.arrayArg(argPlaceholder), this.spreadCount);
        return ILGenMacros.invokeExact_X(this.next, ILGenMacros.placeholder(ILGenMacros.firstN(SpreadHandle.numArgsToPassThrough(), argPlaceholder), ILGenMacros.arrayElements(SpreadHandle.arrayArg(argPlaceholder), 0, SpreadHandle.numArgsToSpread())));
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new SpreadHandle(this, newType);
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof SpreadHandle) {
            ((SpreadHandle)right).compareWithSpread(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithSpread(SpreadHandle left, Comparator c) {
        c.compareStructuralParameter(left.arrayClass, this.arrayClass);
        c.compareStructuralParameter(left.spreadCount, this.spreadCount);
        c.compareChildHandle(left.next, this.next);
    }
}

