/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.CollectHandle;
import java.lang.invoke.Comparator;
import java.lang.invoke.ILGenMacros;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfoImpl;
import java.lang.invoke.MethodType;
import java.lang.invoke.ThunkTable;
import java.lang.invoke.WrongMethodTypeException;

final class VarargsCollectorHandle
extends MethodHandle {
    final MethodHandle next;
    final Class<?> arrayType;
    private CollectHandle previousCollector = null;
    private static final ThunkTable _thunkTable = new ThunkTable();

    VarargsCollectorHandle(MethodHandle next, Class<?> arrayType) {
        super(VarargsCollectorHandle.varargsCollectorType(next.type, arrayType), next.definingClass, null, 17, next.rawModifiers & 0xFFFFFF7F, null);
        this.next = next;
        if (arrayType == null) {
            throw new IllegalArgumentException();
        }
        this.arrayType = arrayType;
        this.defc = next.defc;
    }

    VarargsCollectorHandle(VarargsCollectorHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.next = originalHandle.next;
        this.arrayType = originalHandle.arrayType;
    }

    static MethodType varargsCollectorType(MethodType nextType, Class<?> arrayType) {
        return nextType.changeParameterType(nextType.parameterCount() - 1, arrayType);
    }

    @Override
    public Object invokeWithArguments(Object ... args) throws Throwable, WrongMethodTypeException, ClassCastException {
        if (args.length < 253) {
            MethodHandle mh = MethodHandle.IWAContainer.getMH(args.length);
            return mh.invokeExact(this, args);
        }
        MethodHandle mh = this.asType(MethodType.genericMethodType(args.length));
        mh = mh.asSpreader(Object[].class, args.length);
        return mh.invokeExact(args);
    }

    @Override
    public MethodHandle asType(MethodType newType) throws ClassCastException {
        int newTypeParameterCount;
        if (this.type == newType) {
            return this;
        }
        int parameterCount = this.type.parameterCount();
        if (parameterCount == (newTypeParameterCount = newType.parameterCount()) && this.type.lastParameterType().isAssignableFrom(newType.lastParameterType())) {
            return this.next.asType(newType);
        }
        int collectCount = newTypeParameterCount - parameterCount + 1;
        if (collectCount < 0) {
            throw new WrongMethodTypeException();
        }
        CollectHandle collector = this.previousCollector;
        if (collector == null || collector.collectArraySize != collectCount) {
            this.previousCollector = collector = (CollectHandle)this.next.asCollector(this.arrayType, collectCount);
        }
        return collector.asType(newType);
    }

    @Override
    public MethodHandle asVarargsCollector(Class<?> arrayParameter) throws IllegalArgumentException {
        if (this.arrayType == arrayParameter) {
            return this;
        }
        if (!this.arrayType.isAssignableFrom(arrayParameter)) {
            throw new IllegalArgumentException("Cannot assign '" + arrayParameter + "' to methodtype '" + this.type + "'");
        }
        return this.next.asVarargsCollector(arrayParameter);
    }

    @Override
    public MethodHandle asFixedArity() {
        MethodHandle fixedArity = this.next;
        while (fixedArity.isVarargsCollector()) {
            fixedArity = ((VarargsCollectorHandle)fixedArity).next;
        }
        return fixedArity.asType(this.type());
    }

    @Override
    protected final ThunkTable thunkTable() {
        return _thunkTable;
    }

    @MethodHandle.FrameIteratorSkip
    private final int invokeExact_thunkArchetype_X(int argPlaceholder) throws Throwable {
        return ILGenMacros.invokeExact_X(this.next, argPlaceholder);
    }

    @Override
    MethodHandleInfoImpl getInfo() {
        return this.next.getInfo();
    }

    @Override
    MethodHandle cloneWithNewType(MethodType newType) {
        return new VarargsCollectorHandle(this, newType);
    }

    @Override
    final void compareWith(MethodHandle right, Comparator c) {
        if (right instanceof VarargsCollectorHandle) {
            ((VarargsCollectorHandle)right).compareWithVarargsCollector(this, c);
        } else {
            c.fail();
        }
    }

    final void compareWithVarargsCollector(VarargsCollectorHandle left, Comparator c) {
        c.compareStructuralParameter(left.arrayType, this.arrayType);
        c.compareChildHandle(left.next, this.next);
    }
}

