/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.cm;

import com.ibm.net.rdma.jverbs.DeviceConstants;

public class ConnectionParameter {
    protected int responderResources;
    protected int initiatorDepth;
    protected int retryCount;
    protected byte[] privateData;
    protected byte privateDataLength = 0;
    protected byte flowControl;
    protected int rnrRetryCount;
    protected byte srq;
    protected int qpNum;

    public ConnectionParameter() {
        this.initiatorDepth = DeviceConstants.IBV_MAX_INITIATOR_DEPTH;
        this.responderResources = DeviceConstants.IBV_MAX_RESPONDER_RESOURCES;
        this.flowControl = 1;
        this.retryCount = 7;
        this.rnrRetryCount = 7;
        this.srq = 0;
        this.qpNum = 0;
    }

    public ConnectionParameter(int n, int n2, int n3, int n4) {
        this.setInitiatorDepth(n2);
        this.setResponderResources(n);
        this.flowControl = 1;
        this.setRetryCount(n3);
        this.setRnrRetryCount(n4);
        this.srq = 0;
        this.qpNum = 0;
    }

    public int getResponderResources() {
        return this.responderResources;
    }

    public void setResponderResources(int n) {
        this.responderResources = n < 1 || n > DeviceConstants.IBV_MAX_RESPONDER_RESOURCES ? DeviceConstants.IBV_MAX_RESPONDER_RESOURCES : n;
    }

    public int getInitiatorDepth() {
        return this.initiatorDepth;
    }

    public void setInitiatorDepth(int n) {
        this.initiatorDepth = n < 0 || n > DeviceConstants.IBV_MAX_INITIATOR_DEPTH ? DeviceConstants.IBV_MAX_INITIATOR_DEPTH : n;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int n) {
        this.retryCount = n < 0 || n > 7 ? 7 : n;
    }

    public int getRnrRetryCount() {
        return this.rnrRetryCount;
    }

    public void setRnrRetryCount(int n) {
        if (n < 0 || n > 7) {
            this.retryCount = 7;
        } else {
            this.rnrRetryCount = n;
        }
    }
}

