/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.common;

import com.ibm.net.rdma.jverbs.common.MemoryBufferPool;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;

public class MemoryBuffer {
    private MemoryBufferPool.MemType type;
    private long address;
    private ByteBuffer buffer;
    private MemoryBufferPool memoryBufferPool;
    private byte[] bufarray;

    public MemoryBuffer(MemoryBufferPool.MemType memType, ByteBuffer byteBuffer, long l, MemoryBufferPool memoryBufferPool) {
        this.type = memType;
        this.buffer = byteBuffer;
        this.address = l;
        this.memoryBufferPool = memoryBufferPool;
        if (byteBuffer.hasArray()) {
            this.bufarray = byteBuffer.array();
        }
    }

    public final long getAddress() {
        return this.address;
    }

    public final int getSize() {
        return this.buffer.capacity();
    }

    public final boolean isDirect() {
        return this.buffer.isDirect();
    }

    public final int getPosition() {
        return this.buffer.position();
    }

    public final void clear() {
        this.buffer.clear();
    }

    public final int getRemaining() {
        return this.buffer.remaining();
    }

    public final int getLimit() {
        return this.buffer.limit();
    }

    public final int getInt() {
        return this.buffer.getInt();
    }

    public final long getLong() {
        return this.buffer.getLong();
    }

    public final long getLong(int n) {
        return this.buffer.getLong(n);
    }

    public final short getShort() {
        return this.buffer.getShort();
    }

    public final byte get() {
        return this.buffer.get();
    }

    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final byte[] getBufarray() {
        return this.bufarray;
    }

    public MemoryBufferPool.MemType getType() {
        return this.type;
    }

    public void cache() {
        if (this.memoryBufferPool != null) {
            this.memoryBufferPool.cache(this);
        }
    }

    public void free() {
        ((DirectBuffer)((Object)this.buffer)).cleaner().clean();
    }
}

