/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.endpoints;

import com.ibm.net.rdma.jverbs.endpoints.RdmaActiveEndpoint;
import com.ibm.net.rdma.jverbs.endpoints.RdmaCQConsumer;
import com.ibm.net.rdma.jverbs.endpoints.RdmaCQEventProcessor;
import com.ibm.net.rdma.jverbs.endpoints.RdmaCQProvider;
import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpoint;
import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpointFactory;
import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpointGroup;
import com.ibm.net.rdma.jverbs.verbs.QueuePair;
import com.ibm.net.rdma.jverbs.verbs.VerbsContext;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

public class RdmaActiveEndpointGroup<C extends RdmaActiveEndpoint>
extends RdmaEndpointGroup<C> {
    private ConcurrentHashMap<Integer, RdmaCQEventProcessor> cqMap;
    private int timeout;

    public RdmaActiveEndpointGroup(RdmaEndpointFactory<C> rdmaEndpointFactory, int n) throws IOException {
        super(rdmaEndpointFactory, n);
        this.timeout = n;
        if (n < 2000) {
            this.timeout = 2000;
        }
        this.cqMap = new ConcurrentHashMap();
    }

    public RdmaActiveEndpointGroup(RdmaEndpointFactory<C> rdmaEndpointFactory) throws IOException {
        this(rdmaEndpointFactory, 2000);
    }

    @Override
    protected RdmaCQProvider createCompletionQueueProcessor(C c) throws IllegalArgumentException, IOException {
        if (c == null) {
            throw new IllegalArgumentException("Endpoint should not be null");
        }
        VerbsContext verbsContext = ((RdmaEndpoint)c).getConnectionId().getVerbsContext();
        if (verbsContext != null) {
            RdmaCQEventProcessor rdmaCQEventProcessor = null;
            int n = verbsContext.getFD();
            if (!this.cqMap.containsKey(n)) {
                rdmaCQEventProcessor = new RdmaCQEventProcessor(verbsContext, this.timeout);
                this.cqMap.put(verbsContext.getFD(), rdmaCQEventProcessor);
                rdmaCQEventProcessor.start();
            }
            rdmaCQEventProcessor = this.cqMap.get(verbsContext.getFD());
            return rdmaCQEventProcessor;
        }
        throw new IOException("Setting up Completion Queue processor, no context found");
    }

    @Override
    protected QueuePair createQueuePair(C c) throws IllegalArgumentException, IOException {
        if (c == null) {
            throw new IllegalArgumentException("Endpoint should not be null");
        }
        QueuePair queuePair = super.createQueuePair(c);
        RdmaCQEventProcessor rdmaCQEventProcessor = (RdmaCQEventProcessor)((RdmaEndpoint)c).getCQProcessor();
        rdmaCQEventProcessor.registerQueuePair(queuePair.getQueuePairNum(), (RdmaCQConsumer)c);
        return queuePair;
    }

    void close(RdmaActiveEndpoint rdmaActiveEndpoint) throws IOException {
        VerbsContext verbsContext = rdmaActiveEndpoint.getConnectionId().getVerbsContext();
        RdmaCQEventProcessor rdmaCQEventProcessor = this.cqMap.get(verbsContext.getFD());
        rdmaCQEventProcessor.unregister(rdmaActiveEndpoint);
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        for (RdmaCQEventProcessor rdmaCQEventProcessor : this.cqMap.values()) {
            rdmaCQEventProcessor.close();
        }
    }
}

