/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.endpoints;

import com.ibm.net.rdma.jverbs.endpoints.RdmaCQConsumer;
import com.ibm.net.rdma.jverbs.endpoints.RdmaCQProvider;
import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpoint;
import com.ibm.net.rdma.jverbs.verbs.PollCQMethod;
import com.ibm.net.rdma.jverbs.verbs.RequestNotifyCQMethod;
import com.ibm.net.rdma.jverbs.verbs.VerbsContext;
import com.ibm.net.rdma.jverbs.verbs.WorkCompletion;
import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.ConcurrentHashMap;

class RdmaCQEventProcessor
extends RdmaCQProvider
implements Runnable {
    private static int MAX_WCE = 200;
    private WorkCompletion[] wcList = new WorkCompletion[MAX_WCE];
    private RequestNotifyCQMethod reqNotifyCQMethod;
    private PollCQMethod pollCQMethod;
    private boolean blocking;
    private boolean running;
    private Thread thread;
    private int timeout;
    private ConcurrentHashMap<Integer, RdmaCQConsumer> qpMap;

    public RdmaCQEventProcessor(VerbsContext verbsContext, int n) throws IllegalArgumentException, IOException {
        super(verbsContext);
        for (int i = 0; i < this.wcList.length; ++i) {
            this.wcList[i] = new WorkCompletion();
        }
        this.reqNotifyCQMethod = this.cq.requestNotifyCQ(false);
        this.pollCQMethod = this.cq.pollCQ(this.wcList, this.wcList.length);
        this.timeout = n;
        this.blocking = true;
        if (this.blocking) {
            this.reqNotifyCQMethod.execute();
        }
        this.running = false;
        this.thread = new Thread(this);
        this.qpMap = new ConcurrentHashMap();
    }

    protected synchronized void registerQueuePair(Integer n, RdmaCQConsumer rdmaCQConsumer) throws IOException {
        this.qpMap.put(n, rdmaCQConsumer);
    }

    protected synchronized void unregister(RdmaEndpoint rdmaEndpoint) throws IOException {
        if (this.qpMap.containsKey(rdmaEndpoint.getQueuePair().getQueuePairNum())) {
            this.qpMap.remove(rdmaEndpoint.getQueuePair().getQueuePairNum());
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.running) {
            return;
        }
        try {
            this.running = false;
            this.thread.join();
            super.close();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Completion Queue Processor close failed");
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                if (this.blocking) {
                    if (this.compChannel.getCQEvent(this.timeout)) {
                        this.compChannel.ackCQEvents(this.cq, 1);
                    }
                    this.reqNotifyCQMethod.execute();
                }
                int n = ((PollCQMethod)this.pollCQMethod.execute()).getPolls();
                while (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        this.dispatchCQEvent(this.wcList[i]);
                    }
                    n = ((PollCQMethod)this.pollCQMethod.execute()).getPolls();
                }
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                if (this.running) continue;
                break;
            }
            catch (AsynchronousCloseException asynchronousCloseException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void dispatchCQEvent(WorkCompletion workCompletion) throws IOException {
        Integer n = workCompletion.getQueuePairNum();
        RdmaCQConsumer rdmaCQConsumer = this.qpMap.get(n);
        if (rdmaCQConsumer != null) {
            rdmaCQConsumer.dispatchCQEvent(workCompletion);
        }
    }

    protected synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.thread.start();
    }
}

