/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.endpoints;

import com.ibm.net.rdma.jverbs.cm.ConnectionEvent;
import com.ibm.net.rdma.jverbs.cm.ConnectionId;
import com.ibm.net.rdma.jverbs.cm.EventChannel;
import com.ibm.net.rdma.jverbs.cm.PortSpace;
import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpoint;
import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpointGroup;
import java.io.IOException;

class RdmaConnectionEventProcessor
implements Runnable {
    private EventChannel cmChannel = EventChannel.createEventChannel();
    private RdmaEndpointGroup<? extends RdmaEndpoint> rdmaEndPointGroup;
    private int timeout;
    private Thread thread;
    private boolean running;

    RdmaConnectionEventProcessor(RdmaEndpointGroup<? extends RdmaEndpoint> rdmaEndpointGroup, int n) throws IOException {
        this.rdmaEndPointGroup = rdmaEndpointGroup;
        this.timeout = n;
        this.thread = new Thread(this);
        this.running = false;
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.thread.start();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                ConnectionEvent connectionEvent = this.cmChannel.getConnectionEvent(this.timeout);
                if (connectionEvent == null) continue;
                this.cmChannel.ackConnectionEvent(connectionEvent);
                this.rdmaEndPointGroup.dispatchConnectionEvent(connectionEvent);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public synchronized void close() throws IOException {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.thread.join();
            this.cmChannel.destroyEventChannel();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Connection Event Processor close failed");
        }
    }

    ConnectionId createConnectionId(PortSpace portSpace) throws IllegalArgumentException, IOException {
        ConnectionId connectionId = ConnectionId.create(this.cmChannel, PortSpace.RDMA_PS_TCP);
        return connectionId;
    }
}

