/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.endpoints;

import com.ibm.net.rdma.jverbs.cm.ConnectionEvent;
import com.ibm.net.rdma.jverbs.cm.ConnectionId;
import com.ibm.net.rdma.jverbs.cm.PortSpace;
import com.ibm.net.rdma.jverbs.endpoints.RdmaCQProvider;
import com.ibm.net.rdma.jverbs.endpoints.RdmaConnectionEventProcessor;
import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpoint;
import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpointFactory;
import com.ibm.net.rdma.jverbs.endpoints.RdmaEndpointProvider;
import com.ibm.net.rdma.jverbs.endpoints.RdmaServerEndpoint;
import com.ibm.net.rdma.jverbs.verbs.CompletionQueue;
import com.ibm.net.rdma.jverbs.verbs.ProtectionDomain;
import com.ibm.net.rdma.jverbs.verbs.QueuePair;
import com.ibm.net.rdma.jverbs.verbs.QueuePairInitAttribute;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;

public class RdmaEndpointGroup<C extends RdmaEndpoint> {
    protected static int MAX_SGE = 10;
    protected static int MAX_WR = 400;
    private static int idCounter = 0;
    protected RdmaEndpointProvider endpointProvider;
    protected RdmaConnectionEventProcessor cmProcessor;
    protected ConcurrentHashMap<ConnectionId, RdmaServerEndpoint<C>> serverEndpointMap;
    protected ConcurrentHashMap<ConnectionId, C> clientEndpointMap;
    protected boolean closed;
    protected RdmaEndpointFactory<C> factory;

    public RdmaEndpointGroup(RdmaEndpointFactory<C> rdmaEndpointFactory, int n) throws IOException {
        if (n < 2000) {
            n = 2000;
        }
        this.endpointProvider = RdmaEndpointProvider.getEndpointProvider();
        this.serverEndpointMap = new ConcurrentHashMap();
        this.clientEndpointMap = new ConcurrentHashMap();
        this.cmProcessor = new RdmaConnectionEventProcessor(this, n);
        this.closed = false;
        this.factory = rdmaEndpointFactory;
        this.cmProcessor.start();
    }

    public RdmaEndpointGroup(RdmaEndpointFactory<C> rdmaEndpointFactory) throws IOException {
        this(rdmaEndpointFactory, 2000);
    }

    public synchronized RdmaServerEndpoint<C> createServerEndpoint() throws IOException {
        ConnectionId connectionId = this.cmProcessor.createConnectionId(PortSpace.RDMA_PS_TCP);
        RdmaServerEndpoint rdmaServerEndpoint = new RdmaServerEndpoint(this, connectionId);
        this.serverEndpointMap.put(connectionId, rdmaServerEndpoint);
        return rdmaServerEndpoint;
    }

    public synchronized C createEndpoint() throws IOException {
        ConnectionId connectionId = this.cmProcessor.createConnectionId(PortSpace.RDMA_PS_TCP);
        C c = this.createEndpoint(connectionId);
        ((RdmaEndpoint)c).setServerSide(false);
        return c;
    }

    protected synchronized C createEndpoint(ConnectionId connectionId) throws IllegalArgumentException, IOException {
        C c = this.factory.createEndpoint(connectionId);
        this.clientEndpointMap.put(connectionId, c);
        ((RdmaEndpoint)c).setServerSide(true);
        return c;
    }

    protected ProtectionDomain createProtectionDomain(C c) throws IllegalArgumentException, IOException {
        return this.endpointProvider.createProtectionDomain((RdmaEndpoint)c);
    }

    protected synchronized RdmaCQProvider createCompletionQueueProcessor(C c) throws IllegalArgumentException, IOException {
        return new RdmaCQProvider(((RdmaEndpoint)c).getConnectionId().getVerbsContext());
    }

    protected synchronized QueuePair createQueuePair(C c) throws IllegalArgumentException, IOException {
        RdmaCQProvider rdmaCQProvider = ((RdmaEndpoint)c).getCQProcessor();
        CompletionQueue completionQueue = rdmaCQProvider.getCQ();
        QueuePairInitAttribute queuePairInitAttribute = new QueuePairInitAttribute();
        queuePairInitAttribute.getCap().setMaxReceiveSge(MAX_SGE);
        queuePairInitAttribute.getCap().setMaxReceiveWorkRequest(MAX_WR);
        queuePairInitAttribute.getCap().setMaxSendSge(MAX_SGE);
        queuePairInitAttribute.getCap().setMaxSendWorkRequest(MAX_WR);
        queuePairInitAttribute.setQueuePairType(QueuePair.Type.IBV_QPT_RC);
        queuePairInitAttribute.setReceiveCompletionQueue(completionQueue);
        queuePairInitAttribute.setSendCompletionQueue(completionQueue);
        QueuePair queuePair = ((RdmaEndpoint)c).getConnectionId().createQueuePair(((RdmaEndpoint)c).getProtectionDomain(), queuePairInitAttribute);
        return queuePair;
    }

    protected void allocateResources(C c) throws IOException {
        ((RdmaEndpoint)c).allocateResources();
    }

    protected final void dispatchConnectionEvent(ConnectionEvent connectionEvent) throws IOException {
        ConnectionId connectionId = connectionEvent.getListenId();
        ConnectionId connectionId2 = connectionEvent.getConnectionId();
        ConnectionEvent.EventType eventType = connectionEvent.getEventType();
        switch (eventType) {
            case RDMA_CM_EVENT_CONNECT_REQUEST: {
                if (connectionId == null || !this.serverEndpointMap.containsKey(connectionId)) break;
                this.serverEndpointMap.get(connectionId).dispatchConnectionEvent(connectionEvent);
                break;
            }
            case RDMA_CM_EVENT_ESTABLISHED: 
            case RDMA_CM_EVENT_ADDR_RESOLVED: 
            case RDMA_CM_EVENT_ROUTE_RESOLVED: {
                if (connectionId2 == null || !this.clientEndpointMap.containsKey(connectionId2)) break;
                ((RdmaEndpoint)this.clientEndpointMap.get(connectionId2)).dispatchConnectionEvent(connectionEvent);
                break;
            }
            default: {
                if (connectionId2 != null && this.clientEndpointMap.containsKey(connectionId2)) {
                    ((RdmaEndpoint)this.clientEndpointMap.get(connectionId2)).dispatchConnectionEvent(connectionEvent);
                }
                if (connectionId == null || !this.serverEndpointMap.containsKey(connectionId)) break;
                this.serverEndpointMap.get(connectionId).dispatchConnectionEvent(connectionEvent);
            }
        }
    }

    ProtectionDomain createProtectionDomainRaw(RdmaEndpoint rdmaEndpoint) throws IOException {
        return this.createProtectionDomain((RdmaEndpoint)this.clientEndpointMap.get(rdmaEndpoint.getConnectionId()));
    }

    RdmaCQProvider createCompletionQueueProcessorRaw(RdmaEndpoint rdmaEndpoint) throws IOException {
        return this.createCompletionQueueProcessor((RdmaEndpoint)this.clientEndpointMap.get(rdmaEndpoint.getConnectionId()));
    }

    QueuePair createQueuePairRaw(RdmaEndpoint rdmaEndpoint) throws IOException {
        return this.createQueuePair((RdmaEndpoint)this.clientEndpointMap.get(rdmaEndpoint.getConnectionId()));
    }

    void allocateResourcesRaw(RdmaEndpoint rdmaEndpoint) throws IOException {
        this.allocateResources((RdmaEndpoint)this.clientEndpointMap.get(rdmaEndpoint.getConnectionId()));
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        for (RdmaEndpoint object : this.clientEndpointMap.values()) {
            object.close();
        }
        for (RdmaServerEndpoint rdmaServerEndpoint : this.serverEndpointMap.values()) {
            rdmaServerEndpoint.close();
        }
        this.cmProcessor.close();
    }

    synchronized void unregisterEndpoint(RdmaEndpoint rdmaEndpoint) throws IOException {
        if (this.clientEndpointMap.containsKey(rdmaEndpoint.getConnectionId())) {
            this.clientEndpointMap.remove(rdmaEndpoint.getConnectionId());
        }
    }

    synchronized void unregisterServerEndpoint(RdmaServerEndpoint<C> rdmaServerEndpoint) throws IOException {
        if (this.serverEndpointMap.containsKey(rdmaServerEndpoint.getConnectionId())) {
            this.serverEndpointMap.remove(rdmaServerEndpoint.getConnectionId());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected synchronized int getNextId() {
        int n = idCounter++;
        return n;
    }
}

