/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.net.rdma.jverbs.verbs;

import com.ibm.net.rdma.jverbs.NativeSizeConstants;
import com.ibm.net.rdma.jverbs.common.MemoryBuffer;
import com.ibm.net.rdma.jverbs.common.MemoryBufferPool;
import com.ibm.net.rdma.jverbs.verbs.CompletionQueue;
import com.ibm.net.rdma.jverbs.verbs.NativeRdmaJVerbs;
import com.ibm.net.rdma.jverbs.verbs.PollCQMethod;
import com.ibm.net.rdma.jverbs.verbs.WorkCompletion;
import java.nio.ByteBuffer;

class NativePollCQMethod
extends PollCQMethod {
    private NativeRdmaJVerbs verbsImpl;
    private MemoryBufferPool memAlloc;
    private int cqHandle = -1;
    private WorkCompletion[] wcList;
    private int ne;
    private MemoryBuffer cmd;
    private int csize;
    private int result = 0;
    private boolean valid = false;
    private boolean success = false;

    public NativePollCQMethod(NativeRdmaJVerbs nativeRdmaJVerbs, MemoryBufferPool memoryBufferPool, CompletionQueue completionQueue, WorkCompletion[] workCompletionArray, int n) {
        this.verbsImpl = nativeRdmaJVerbs;
        this.memAlloc = memoryBufferPool;
        this.cqHandle = completionQueue.getHandle();
        this.wcList = workCompletionArray;
        this.ne = n > workCompletionArray.length ? workCompletionArray.length : n;
        this.csize = workCompletionArray.length * NativeSizeConstants.IBV_WC_SIZE;
        this.cmd = memoryBufferPool.allocate(this.csize, MemoryBufferPool.MemType.DIRECT);
        this.valid = true;
    }

    private void update(WorkCompletion workCompletion, ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        workCompletion.setWorkRequestId(byteBuffer.getLong());
        workCompletion.setStatus(WorkCompletion.Status.values()[byteBuffer.getInt()]);
        workCompletion.setOpcode(WorkCompletion.Opcode.getEnumFromValue(byteBuffer.getInt()));
        if (workCompletion.getStatus() == WorkCompletion.Status.IBV_WC_SUCCESS) {
            workCompletion.setVendorError(byteBuffer.getInt());
            workCompletion.setByteLength(byteBuffer.getInt());
            workCompletion.setImmediateData(byteBuffer.getInt());
            workCompletion.setQueuePairNum(byteBuffer.getInt());
            workCompletion.setSrcQueuePair(byteBuffer.getInt());
            workCompletion.setWorkCompletionFlags(byteBuffer.getInt());
            workCompletion.setPkeyIndex(byteBuffer.getShort());
            workCompletion.setSlid(byteBuffer.getShort());
            workCompletion.setServiceLevel(byteBuffer.get());
            workCompletion.setDestinationLidPathbits(byteBuffer.get());
        }
        int n2 = n + NativeSizeConstants.IBV_WC_SIZE;
        byteBuffer.position(n2);
    }

    @Override
    public PollCQMethod execute() {
        this.success = false;
        if (!this.valid) {
            return this;
        }
        this.result = this.verbsImpl.pollCq0(this.cqHandle, this.ne, this.cmd.getAddress());
        if (this.result >= 0) {
            this.success = true;
        }
        this.cmd.clear();
        for (int i = 0; i < this.result; ++i) {
            this.update(this.wcList[i], this.cmd.getBuffer());
        }
        return this;
    }

    @Override
    public int getPolls() {
        return this.result;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public PollCQMethod free() {
        if (this.cmd != null) {
            this.cmd.free();
            this.cmd = null;
        }
        this.valid = false;
        return this;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }
}

