/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.heapdump;

import com.ibm.jvm.j9.dump.command.CommandDetails;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpAbstractCommand;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpBaseCmds;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpConsole;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpStats;
import com.ibm.jvm.j9.dump.command.heapdump.HeapDumpUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.Observable;
import java.util.zip.GZIPOutputStream;

public class HeapDumpNetCommand
extends HeapDumpAbstractCommand {
    public static final String PORT_PROPERTY = "HD_PORT";
    public static final String HOST_PROPERTY = "HD_HOST";
    public static final int DEFAULT_PORT = 21179;
    public static final String DEFAULT_HOST = "localhost";
    private static final String DESC = "Writes a portable heapdump file to a host/port";
    public static final String NOUN = "N";

    public HeapDumpNetCommand(HeapDumpBaseCmds cp, Observable o) {
        super(NOUN, cp, o, DESC);
        HeapDumpConsole.setProperty(PORT_PROPERTY, "21179");
        HeapDumpConsole.setProperty(HOST_PROPERTY, DEFAULT_HOST);
    }

    public boolean checkUserInput(CommandDetails cd) {
        return cd.getNoun().equals(NOUN);
    }

    public String getHost() {
        return HeapDumpConsole.getProperty(HOST_PROPERTY);
    }

    public int getPort() {
        int result = 0;
        try {
            result = Integer.parseInt(HeapDumpConsole.getProperty(PORT_PROPERTY));
        }
        catch (NumberFormatException nfe) {
            System.err.println("Network port is not set correctly");
        }
        return result;
    }

    public String action(CommandDetails cd, Observable ob) {
        HeapDumpStats stats;
        ob.notifyObservers("Now dumping heapdump to host:" + this.getHost() + " port:" + this.getPort());
        ob.notifyObservers("\n");
        try {
            if (HeapDumpUtil.isPortableDump()) {
                ob.notifyObservers("Writing HeapDump in Portable Format");
                stats = HeapDumpUtil.doPortableHeapDump(this.getNetworkOutputStream(this.getHost(), this.getPort()));
            } else {
                ob.notifyObservers("Writing HeapDump in Classic Format");
                stats = HeapDumpUtil.doClassicHeapDump(this.getNetworkPrintWriter(this.getHost(), this.getPort()));
            }
        }
        catch (Exception e) {
            ob.notifyObservers("Error writing heap dump: ");
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            ob.notifyObservers(sw.toString());
            return "Heapdump failed";
        }
        if (stats.errorsOccurred()) {
            return "Number of Object processed = " + stats.getNumberOfObjects() + ", Number of Errors: " + stats.getNumberOfErrors() + "\n Heapdump Complete with Errors";
        }
        return "Number of Object processed = " + stats.getNumberOfObjects() + "\n Heapdump Successful";
    }

    private OutputStream getNetworkOutputStream(String host, int port) throws IOException {
        return new Socket(host, port).getOutputStream();
    }

    private PrintWriter getNetworkPrintWriter(String host, int port) throws IOException {
        OutputStream out = this.getNetworkOutputStream(host, port);
        PrintWriter first = new PrintWriter(out);
        first.println("// FORMAT=.txt.gz");
        first.flush();
        PrintWriter sec = new PrintWriter(new BufferedOutputStream(new GZIPOutputStream(out)));
        return sec;
    }
}

