/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConsoleUtils {
    public static Vector breakUpInput(String input, String tokens) {
        Vector<String> v = new Vector<String>();
        StringTokenizer st = new StringTokenizer(input, tokens);
        String parm1 = null;
        if (st.countTokens() != 0) {
            parm1 = st.nextToken();
        }
        if (null != parm1) {
            v.add(parm1);
            while (st.hasMoreTokens()) {
                v.add(st.nextToken());
            }
        }
        return v;
    }

    public static boolean verifyAsHex(String input) {
        boolean bRet = true;
        try {
            long l = DumpUtils.parseLongHex(input);
        }
        catch (NumberFormatException nfe) {
            bRet = false;
        }
        return bRet;
    }

    public static boolean verifyAsPositiveNumber(String input) {
        boolean bRet = true;
        try {
            long l = Long.parseLong(input);
            if (l < 0L) {
                bRet = false;
            }
        }
        catch (NumberFormatException nfe) {
            bRet = false;
        }
        return bRet;
    }

    public static int hexValue(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }

    public static long hexToLong(String hex) throws NumberFormatException {
        int j;
        long ret = 0L;
        if (hex.startsWith("0x")) {
            hex = hex.substring(2, hex.length());
        }
        if ((j = hex.length()) <= 16) {
            for (int i = 0; i < j; ++i) {
                int digit = ConsoleUtils.hexValue(hex.charAt(i));
                if (digit == -1) {
                    throw new NumberFormatException("Bad hex input");
                }
                ret = 16L * ret + (long)digit;
            }
        } else {
            throw new NumberFormatException("Too many hex digits");
        }
        return ret;
    }
}

