/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import java.io.IOException;
import java.util.Vector;

public class DumpUtils {
    public static final int ADDRESSES_EQUAL = 0;
    public static final int ADDRESS_GT = 1;
    public static final int ADDRESS_LT = -1;
    private static int ptrSize = 0;
    private static final String s16Zeros = "0000000000000000";
    private static final String s16blanks = "                ";
    private static final String s32blanks = "                                ";
    private static final int SEARCH_BUFFER_SIZE = 262144;
    public static String byteToHex = "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7C8C9CACBCCCDCECFD0D1D2D3D4D5D6D7D8D9DADBDCDDDEDFE0E1E2E3E4E5E6E7E8E9EAEBECEDEEEFF0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF";
    public static String byteToAscii = "................................ !\"#$%&'()*+'-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~.................................................................................................................................";
    public static String byteToEbcdic = "..........................................................................\u00a3.<(+|&.........!$*);\u00ac-/.........,%_>?..........:#@'=\".abcdefghi.......jklmnopqr........stuvwxyz...............`.......ABCDEFGHI.......JKLMNOPQR........STUVWXYZ......0123456789......";

    public static Vector formatMemory(byte[] memory, long startAddress, int bytesPerLine, boolean ascii) {
        String temp;
        long seenAddress = startAddress;
        if (0 == ptrSize) {
            DumpUtils.initPtrSize();
        }
        String asciiString = "| ";
        Vector<String> theLines = new Vector<String>();
        if (DumpConsole.getTheDump().getSystemType() == 3) {
            Dump theDump = DumpConsole.getTheDump();
            int whichRange = theDump.findWhichMemoryRange(startAddress);
            if (whichRange == -1) {
                theLines.add("\n  Asid: ???");
            } else {
                MemoryRange[] mr = theDump.getMemoryRanges();
                theLines.add("\n  Asid: 0x" + Integer.toHexString(mr[whichRange].getAsid()));
            }
        }
        if ((temp = Long.toHexString(seenAddress)).length() < ptrSize) {
            temp = s16Zeros.substring(0, ptrSize - temp.length()) + temp;
        }
        StringBuffer singleLine = new StringBuffer("\n" + temp + ": ");
        boolean bUnfinishedLine = false;
        int ival = 0;
        int numlines = 0;
        int i = 0;
        int j = 1;
        while (i < memory.length) {
            bUnfinishedLine = true;
            ival = memory[i];
            if (ival < 0) {
                ival += 256;
            }
            singleLine.append(byteToHex.substring(2 * ival, 2 * ival + 2));
            asciiString = ascii ? asciiString + byteToAscii.substring(ival, ival + 1) : asciiString + byteToEbcdic.substring(ival, ival + 1);
            if (0 == j % 4) {
                singleLine.append(" ");
            }
            if (bytesPerLine == j) {
                bUnfinishedLine = false;
                singleLine.append(asciiString);
                asciiString = "| ";
                j = 0;
                theLines.add(singleLine.toString() + " |");
                ++numlines;
                temp = Long.toHexString(seenAddress += (long)bytesPerLine);
                if (temp.length() < ptrSize) {
                    temp = s16Zeros.substring(0, ptrSize - temp.length()) + temp;
                }
                singleLine.setLength(0);
                singleLine.append(temp + ": ");
            }
            ++i;
            ++j;
        }
        if (bUnfinishedLine) {
            singleLine.append(s32blanks.substring((asciiString.length() - 2) * 2 - 1) + asciiString);
            theLines.add(singleLine.toString());
        }
        return theLines;
    }

    public static final short convertEndian(short in) {
        int in1 = in & 0xFFFF;
        int high = in1 << 8;
        int low = in1 >>> 8;
        short ret = (short)(high + low);
        return ret;
    }

    public static final int convertEndian(int in) {
        return in >>> 24 | in << 24 | in << 8 & 0xFF0000 | in >> 8 & 0xFF00;
    }

    public static final long convertEndian(long in) {
        long highL = in & 0xFFFFFFFF00000000L;
        long lowL = in & 0xFFFFFFFFL;
        int highI = (int)(highL >>> 32);
        int lowI = (int)lowL;
        lowL = DumpUtils.convertEndian(highI);
        highL = (long)DumpUtils.convertEndian(lowI) << 32;
        return (highL &= 0xFFFFFFFF00000000L) + (lowL &= 0xFFFFFFFFL);
    }

    public static final long parseLongHex(String s) throws NumberFormatException {
        long retLong = 0L;
        if (null == s) {
            return 0L;
        }
        s = DumpUtils.stripOff0x(s);
        try {
            retLong = Long.parseLong(s, 16);
        }
        catch (NumberFormatException nfe) {
            if (s.length() < 16) {
                throw nfe;
            }
            if (s.length() > 16) {
                throw nfe;
            }
            String temp = s.substring(0, 1);
            String temp1 = null;
            int i = Integer.parseInt(temp, 16);
            if (i > 7) {
                temp1 = Integer.toString(i - 8, 16);
                temp = temp1 + s.substring(1);
                retLong = Long.parseLong(temp, 16);
                retLong |= Long.MIN_VALUE;
            }
            throw nfe;
        }
        return retLong;
    }

    public static Vector findInMemory(Dump theDump, byte[] whatFor, long startPoint, long endPoint, int boundary, int stopAt, boolean caseSensitive) {
        long bytesRead = 0L;
        Vector<Long> vResult = new Vector<Long>();
        long start = DumpUtils.alignUp(startPoint, boundary);
        int whatForLength = whatFor.length;
        if (caseSensitive) {
            throw new Error("caseSensitive parameter not supported");
        }
        if (DumpUtils.addressCompare(start, endPoint) != -1) {
            return vResult;
        }
        MemoryRange[] mr = theDump.getMemoryRanges();
        for (int i = 0; i < mr.length && vResult.size() < stopAt; ++i) {
            MemoryRange currentRange = mr[i];
            long rangeStart = DumpUtils.alignUp(currentRange.getVaddr(), boundary);
            long rangeEnd = rangeStart + currentRange.getSize();
            if (DumpUtils.addressCompare(start, rangeEnd) != -1 || DumpUtils.addressCompare(rangeStart, endPoint) != -1 || currentRange.getSize() == 0L) continue;
            long ongoing = rangeStart;
            if (DumpUtils.addressCompare(ongoing, start) == -1) {
                ongoing = start;
            }
            boolean memRangeExhausted = false;
            while (!memRangeExhausted) {
                long whereWeAre = ongoing;
                int searchSize = (int)DumpUtils.alignUp(262144L, boundary);
                assert (ongoing % (long)boundary == 0L);
                if (ongoing % (long)boundary != 0L) {
                    System.out.println("alignment wrong on read");
                }
                byte[] memoryBuffer = theDump.getMemoryBytes(ongoing, 262144);
                int mbLen = 0;
                if (null != memoryBuffer) {
                    mbLen = memoryBuffer.length;
                    bytesRead += (long)mbLen;
                    if (searchSize == mbLen) {
                        if (DumpUtils.addressCompare(rangeEnd, ongoing += (long)searchSize) == -1 || DumpUtils.addressCompare(endPoint, ongoing) == -1) {
                            memRangeExhausted = true;
                        }
                    } else {
                        memRangeExhausted = true;
                        searchSize = mbLen;
                    }
                } else {
                    memRangeExhausted = true;
                    continue;
                }
                boolean isFound = false;
                if (mbLen <= 0 || mbLen < whatForLength) continue;
                for (int j = 0; j < searchSize; j += boundary) {
                    int foundlen = 0;
                    for (int k = 0; k < whatForLength && k + j < mbLen; ++k) {
                        if (whatFor[k] != memoryBuffer[k + j]) {
                            isFound = false;
                            foundlen = 0;
                            break;
                        }
                        ++foundlen;
                    }
                    if (foundlen > 0 && foundlen != whatForLength) {
                        ongoing = whereWeAre + (long)j;
                    }
                    if (foundlen != whatForLength) continue;
                    long wwaAddress = whereWeAre + (long)j;
                    int compareVal = DumpUtils.addressCompare(wwaAddress, endPoint);
                    if (compareVal != 1) {
                        vResult.add(new Long(wwaAddress));
                        if (stopAt != vResult.size()) continue;
                        return vResult;
                    }
                    memRangeExhausted = true;
                }
            }
        }
        return vResult;
    }

    public static int addressCompare(long lhs, long rhs) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs >= 0L && rhs >= 0L || lhs < 0L && rhs < 0L) {
            return lhs < rhs ? -1 : 1;
        }
        return lhs < rhs ? 1 : -1;
    }

    public static String chainViaPtr(String address, boolean bLittleEndian) {
        String retString = null;
        String workString = address.substring(1);
        long workAddr = DumpUtils.parseLongHex(workString = DumpUtils.stripOff0x(workString));
        if (0L != workAddr) {
            Dump theDump = DumpConsole.getTheDump();
            long addr = 0L;
            try {
                addr = theDump.readPtr(workAddr);
                retString = Long.toHexString(addr);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return retString;
    }

    public static String stripOff0x(String input) {
        String retString = input.toUpperCase();
        if (retString.startsWith("0X")) {
            retString = retString.substring(2);
        }
        return retString;
    }

    public static String padToPtrSize(String input) {
        String retString = input;
        if (0 == ptrSize) {
            DumpUtils.initPtrSize();
        }
        if (input.length() < ptrSize) {
            retString = s16Zeros.substring(0, ptrSize - input.length()) + input;
        }
        return retString;
    }

    public static String padToSize(String input, int len) {
        String retString = input;
        if (input.length() < len) {
            retString = s16Zeros.substring(0, len - input.length()) + input;
        }
        return retString;
    }

    public static String padWithSpaces(String input, int size) {
        int len;
        String retString = input;
        if (size > 16) {
            size = 16;
        }
        if ((len = input.length()) < size) {
            retString = s16blanks.substring(0, size - len) + input;
        }
        return retString;
    }

    private static void initPtrSize() {
        Dump theDump = DumpConsole.getTheDump();
        ptrSize = theDump.is32bit() ? 8 : 16;
    }

    private static long alignUp(long value, int alignment) {
        if (0L != value % (long)alignment) {
            return value + ((long)alignment - value % (long)alignment);
        }
        return value;
    }

    private static long alignDown(long value, int alignment) {
        if (0L != value % (long)alignment) {
            return value - value % (long)alignment;
        }
        return value;
    }

    public static String changeFileSeperator(String fileName, char newFs) {
        String retString = fileName;
        retString = newFs == '/' ? fileName.replace('\\', newFs) : fileName.replace('/', newFs);
        return retString;
    }
}

