/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.commandconsole;

import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.saxhandler.GenericSaxHandler;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9AddressSpace;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9ClassLoader;
import com.ibm.jvm.j9.dump.systemdump.J9ClassLoaderLibrary;
import com.ibm.jvm.j9.dump.systemdump.J9ConstantPool;
import com.ibm.jvm.j9.dump.systemdump.J9Heap;
import com.ibm.jvm.j9.dump.systemdump.J9Jvm;
import com.ibm.jvm.j9.dump.systemdump.J9Method;
import com.ibm.jvm.j9.dump.systemdump.J9Monitor;
import com.ibm.jvm.j9.dump.systemdump.J9Process;
import com.ibm.jvm.j9.dump.systemdump.J9Static;
import com.ibm.jvm.j9.dump.systemdump.J9Thread;
import org.xml.sax.Attributes;

public class J9XMLHandler {
    private static J9Thread j9t;
    private static J9Class j9c;
    private static J9Method j9m;
    private static J9ClassLoader j9cl;
    private static boolean inTraceElement;
    private static J9Jvm currentJvm;
    private static boolean bWithinConstantpool;
    private static boolean bWithinClassLoader;
    private static J9ConstantPool j9cp;

    public void vmthreadEl(Attributes attributes, Boolean start) {
        if (Boolean.TRUE.equals(start)) {
            String id = null;
            String obj = null;
            String state = null;
            String monitor = null;
            String nativeID = null;
            int index = attributes.getIndex("id");
            if (-1 != index) {
                id = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("obj"))) {
                obj = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("state"))) {
                state = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("monitor"))) {
                monitor = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("native"))) {
                nativeID = attributes.getValue(index);
            }
            j9t = new J9Thread(id, obj, state, monitor, nativeID);
        } else {
            J9Thread storeThisThread = new J9Thread(j9t);
            currentJvm.addThread(storeThisThread);
        }
    }

    public void stackEl(Attributes attributes, Boolean start) {
    }

    public void frameEl(Attributes attributes, Boolean start) {
        if (Boolean.TRUE.equals(start)) {
            String method = null;
            String pc = null;
            String arguments = null;
            int index = attributes.getIndex("method");
            if (-1 != index) {
                method = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("pc"))) {
                pc = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("arguments"))) {
                arguments = attributes.getValue(index);
            }
            j9t.addFrame(method, pc, arguments);
        }
    }

    public void fieldEl(Attributes attributes, Boolean start) {
        if (Boolean.TRUE.equals(start)) {
            String classId = null;
            String name = null;
            String sig = null;
            String offset = null;
            String modifiers = null;
            int index = attributes.getIndex("class");
            if (-1 != index) {
                classId = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("name"))) {
                name = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("sig"))) {
                sig = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("offset"))) {
                offset = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("modifiers"))) {
                modifiers = attributes.getValue(index);
            }
            j9c.addField(classId, name, sig, offset, modifiers);
        }
    }

    public void classEl(Attributes attributes, Boolean start) {
        String id = null;
        String aSuper = null;
        String name = null;
        String instanceSize = null;
        String loader = null;
        String modifiers = null;
        if (!bWithinConstantpool && !bWithinClassLoader) {
            if (Boolean.TRUE.equals(start)) {
                int index = attributes.getIndex("id");
                if (-1 != index) {
                    id = attributes.getValue(index);
                }
                if (-1 != (index = attributes.getIndex("super"))) {
                    aSuper = attributes.getValue(index);
                }
                if (-1 != (index = attributes.getIndex("name"))) {
                    name = attributes.getValue(index);
                }
                if (-1 != (index = attributes.getIndex("instanceSize"))) {
                    instanceSize = attributes.getValue(index);
                }
                if (-1 != (index = attributes.getIndex("loader"))) {
                    loader = attributes.getValue(index);
                }
                if (-1 != (index = attributes.getIndex("modifiers"))) {
                    modifiers = attributes.getValue(index);
                }
                j9c = new J9Class(name, id, aSuper, instanceSize, loader, modifiers);
            } else {
                J9JVMConsole.addClass(j9c);
            }
        } else if (Boolean.TRUE.equals(start)) {
            if (bWithinConstantpool) {
                String address = null;
                int index = attributes.getIndex("id");
                if (-1 != index) {
                    id = attributes.getValue(index);
                }
                if (-1 != (index = attributes.getIndex("address"))) {
                    address = attributes.getValue(index);
                }
                j9cp.addClassEntry(id, address);
            } else {
                int index = attributes.getIndex("id");
                if (-1 != index) {
                    id = attributes.getValue(index);
                }
                j9cl.addLoadedClass(id);
            }
        }
    }

    public void j9dumpEl(Attributes attributes, Boolean start) {
        String stamp = null;
        String version = null;
        String shortVersion = null;
        String uuid = null;
        String format = null;
        String arch = null;
        String osName = null;
        String osVersion = null;
        String cpus = null;
        String size = null;
        String memory = null;
        String environ = null;
        String endian = null;
        if (Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("stamp");
            if (-1 != index) {
                stamp = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("version"))) {
                version = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("environ"))) {
                environ = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("uuid"))) {
                uuid = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("format"))) {
                format = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("arch"))) {
                arch = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("osname"))) {
                osName = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("osversion"))) {
                osVersion = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("cpus"))) {
                cpus = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("size"))) {
                size = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("memory"))) {
                memory = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("endian"))) {
                endian = attributes.getValue(index);
            }
            shortVersion = version;
            version = version + " ";
            if (null != osName) {
                version = version + osName;
                version = version + " ";
            }
            Dump theDump = DumpConsole.getTheDump();
            theDump.setStamp(stamp);
            theDump.setVersion(version);
            theDump.setUuid(uuid);
            theDump.setArch(arch);
            theDump.setProcessorType(arch);
            theDump.setShortVersion(shortVersion);
            theDump.setMemory(memory);
            theDump.setEnviron(environ);
            theDump.setSize(size);
            theDump.setEndian(endian);
            try {
                theDump.setProcessorCount(Integer.parseInt(cpus));
            }
            catch (NumberFormatException nfe) {
                theDump.setProcessorCount(0);
            }
        }
    }

    public void javavmEl(Attributes attributes, Boolean start) {
        if (Boolean.TRUE.equals(start)) {
            String id = null;
            int index = attributes.getIndex("id");
            if (-1 != index) {
                id = attributes.getValue(index);
            }
            Dump theDump = DumpConsole.getTheDump();
            int i = theDump.getCurrentAS();
            J9AddressSpace as = theDump.getAddressSpace(i);
            J9Process proc = as.getProcess(as.getCurrentProcess());
            currentJvm = new J9Jvm(id, proc);
            theDump.setCurrentJvm(currentJvm);
            proc.setJvm(currentJvm, 0);
        } else {
            J9Heap.sortHeaps();
            J9Class.reworkArrayClassReworkList();
            J9ClassLoader.recordLoadedClasses();
        }
    }

    public void arrayclassEl(Attributes attributes, Boolean start) {
        if (Boolean.TRUE.equals(start)) {
            String id = null;
            String leaf = null;
            String arity = null;
            String firstElementOffset = null;
            String sizeOffset = null;
            String sizeBytes = null;
            String sizeInElements = null;
            String modifiers = null;
            boolean bSizedAsElements = false;
            int index = attributes.getIndex("id");
            if (-1 != index) {
                id = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("leaf"))) {
                leaf = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("arity"))) {
                arity = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("firstElementOffset"))) {
                firstElementOffset = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("sizeOffset"))) {
                sizeOffset = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("sizeBytes"))) {
                sizeBytes = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("sizeInElements")) && (sizeInElements = attributes.getValue(index)).equals("true")) {
                bSizedAsElements = true;
            }
            if (-1 != (index = attributes.getIndex("modifiers"))) {
                modifiers = attributes.getValue(index);
            }
            int iArity = Integer.parseInt(arity);
            String name = leaf;
            for (int i = 0; i < iArity; ++i) {
                name = "[" + name;
            }
            j9c = new J9Class(name, id, leaf, arity, firstElementOffset, sizeOffset, sizeBytes, bSizedAsElements, modifiers);
        } else {
            J9JVMConsole.addClass(j9c);
        }
    }

    public void errorEl(Attributes attributes, Boolean start) {
        if (Boolean.TRUE.equals(start)) {
            GenericSaxHandler.setBInErrorElement(true);
        } else {
            String error = GenericSaxHandler.getErrorString();
            if (error != null) {
                J9JVMConsole.addError(" XML Error element found (passed in by jextract): " + error);
            }
            GenericSaxHandler.setBInErrorElement(false);
        }
    }

    public void objectEl(Attributes attributes, Boolean start) {
        if (bWithinConstantpool && Boolean.TRUE.equals(start)) {
            String address = null;
            String id = null;
            int index = attributes.getIndex("id");
            if (-1 != index) {
                id = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("address"))) {
                address = attributes.getValue(index);
            }
            j9cp.addObjectEntry(id, address);
        }
    }

    public void objectsEl(Attributes attributes, Boolean start) {
        String startAddress = null;
        String endAddress = null;
        int count = 0;
        if (Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("start");
            if (-1 != index) {
                startAddress = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("end"))) {
                endAddress = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("count"))) {
                count = Integer.parseInt(attributes.getValue(index));
            }
            J9Heap j9h = new J9Heap(startAddress, endAddress, count);
        }
    }

    public void methodEl(Attributes attributes, Boolean start) {
        String id = null;
        String sig = null;
        String name = null;
        String modifiers = null;
        if (Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("id");
            if (-1 != index) {
                id = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("name"))) {
                name = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("sig"))) {
                sig = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("modifiers"))) {
                modifiers = attributes.getValue(index);
            }
            j9m = new J9Method(j9c, id, name, sig, modifiers);
        }
    }

    public void bytecodeEl(Attributes attributes, Boolean start) {
        String bcStart = null;
        String bcEnd = null;
        if (Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("start");
            if (-1 != index) {
                bcStart = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("end"))) {
                bcEnd = attributes.getValue(index);
            }
            j9m.addBytecode(bcStart, bcEnd);
        }
    }

    public void jitEl(Attributes attributes, Boolean start) {
        String jitStart = null;
        String jitEnd = null;
        String jitId = null;
        String jitVersion = null;
        boolean obsolete = false;
        if (Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("version");
            if (-1 != index) {
                jitVersion = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("start"))) {
                jitStart = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("end"))) {
                jitEnd = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("id"))) {
                jitId = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("obsolete"))) {
                obsolete = true;
            }
            if (null == jitVersion) {
                if (!obsolete) {
                    j9m.addJitcode(jitStart, jitEnd, jitId);
                }
            } else {
                J9JVMConsole.setJitVersion(jitVersion);
                Dump theDump = J9JVMConsole.getTheDump();
                String version = theDump.getVersion();
                theDump.setVersion(version + " (jit " + jitVersion + ")");
            }
        }
    }

    public void interfaceEl(Attributes attributes, Boolean start) {
        String name = null;
        if (Boolean.TRUE.equals(start) && (name = attributes.getValue("name")) != null) {
            j9c.addInterface(name);
        }
    }

    public void constantpoolEl(Attributes attributes, Boolean start) {
        if (Boolean.TRUE.equals(start)) {
            bWithinConstantpool = true;
            j9cp = new J9ConstantPool();
            j9c.addConstantPool(j9cp);
        } else {
            bWithinConstantpool = false;
        }
    }

    public void staticEl(Attributes attributes, Boolean start) {
        String value = null;
        String sig = null;
        String name = null;
        String modifiers = null;
        if (Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("value");
            if (-1 != index) {
                value = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("name"))) {
                name = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("sig"))) {
                sig = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("modifiers"))) {
                modifiers = attributes.getValue(index);
            }
            J9Static j9s = new J9Static(j9c, name, sig, modifiers, value);
        }
    }

    public void classloaderEl(Attributes attributes, Boolean start) {
        String id = null;
        String obj = null;
        if (Boolean.TRUE.equals(start)) {
            bWithinClassLoader = true;
            int index = attributes.getIndex("id");
            if (-1 != index) {
                id = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("obj"))) {
                obj = attributes.getValue(index);
            }
            j9cl = new J9ClassLoader(id, obj);
            currentJvm.addClasLoader(j9cl);
        } else {
            bWithinClassLoader = false;
        }
    }

    public void libraryEl(Attributes attributes, Boolean start) {
        String handle = null;
        String name = null;
        if (Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("handle");
            if (-1 != index) {
                handle = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("name"))) {
                name = attributes.getValue(index);
            }
            j9cl.addLibrary(new J9ClassLoaderLibrary(handle, name));
        }
    }

    public void monitorEl(Attributes attributes, Boolean start) {
        String id = null;
        String owner = null;
        String name = null;
        String object = null;
        if (Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("id");
            if (-1 != index) {
                id = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("name"))) {
                name = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("owner"))) {
                owner = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("object"))) {
                object = attributes.getValue(index);
            }
            J9Monitor j9m = new J9Monitor(id, name, owner, object);
            currentJvm.addMonitor(j9m);
        }
    }

    public void traceEl(Attributes attributes, Boolean start) {
        inTraceElement = Boolean.TRUE.equals(start);
    }

    public void buffersEl(Attributes attributes, Boolean start) {
        String buffAddress = null;
        String buffSize = null;
        String buffLinkOffset = null;
        String buffDataOffset = null;
        String buffTerminator = null;
        if (inTraceElement && Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("address");
            if (-1 != index) {
                buffAddress = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("size"))) {
                buffSize = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("link"))) {
                buffLinkOffset = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("offset"))) {
                buffDataOffset = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("terminator"))) {
                buffTerminator = attributes.getValue(index);
            }
            J9JVMConsole.addTraceBuffer(buffAddress, buffSize, buffLinkOffset, buffDataOffset, buffTerminator);
        }
    }

    public void headerEl(Attributes attributes, Boolean start) {
        String hdrAddress = null;
        String hdrSize = null;
        if (inTraceElement && Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("address");
            if (-1 != index) {
                hdrAddress = attributes.getValue(index);
                J9JVMConsole.setTraceFileHeaderAddress(DumpUtils.parseLongHex(hdrAddress));
            }
            if (-1 != (index = attributes.getIndex("size"))) {
                hdrSize = attributes.getValue(index);
                J9JVMConsole.setTraceFileHeaderLength(Integer.parseInt(hdrSize));
            }
        }
    }

    public void gpfEl(Attributes attributes, Boolean start) {
        if (Boolean.TRUE.equals(start)) {
            GenericSaxHandler.setBInGpfElement(true);
            String failingThread = attributes.getValue("failingThread");
            String nativeFailingThread = attributes.getValue("nativeFailingThread");
            J9JVMConsole.setFailingThread(failingThread.toUpperCase(), nativeFailingThread.toUpperCase());
        } else {
            GenericSaxHandler.setBInGpfElement(false);
        }
    }

    public void heapEl(Attributes attributes, Boolean start) {
        String name = null;
        String objectAlignment = null;
        String minimumObjectSize = null;
        if (inTraceElement && Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("name");
            if (-1 != index) {
                name = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("objectAlignment"))) {
                objectAlignment = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("minimumObjectSize"))) {
                minimumObjectSize = attributes.getValue(index);
            }
        }
        if (name != null) {
            J9Heap.setName(name);
        }
        if (objectAlignment != null) {
            J9Heap.setObjectAlignment(objectAlignment);
        }
        if (minimumObjectSize != null) {
            J9Heap.setObjectAlignment(minimumObjectSize);
        }
    }

    public void javavminitargsEl(Attributes attributes, Boolean start) {
        String version = null;
        String noptions = null;
        String ignoreunrecognized = null;
        if (Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("version");
            if (-1 != index) {
                version = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("noptions"))) {
                noptions = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("ignoreunrecognized"))) {
                ignoreunrecognized = attributes.getValue(index);
            }
        }
    }

    public void javavmoptionEl(Attributes attributes, Boolean start) {
        if (Boolean.TRUE.equals(start)) {
            String option = null;
            int index = attributes.getIndex("optionstring");
            if (-1 != index) {
                option = attributes.getValue(index);
                Dump theDump = DumpConsole.getTheDump();
                J9Jvm jvm = theDump.getCurrentJvm();
                jvm.addOption(option);
            }
        }
    }

    public void systemPropertiesEl(Attributes attributes, Boolean start) {
    }

    public void propertyEl(Attributes attributes, Boolean start) {
        String key = null;
        String value = null;
        if (Boolean.TRUE.equals(start)) {
            int index = attributes.getIndex("key");
            if (-1 != index) {
                key = attributes.getValue(index);
            }
            if (-1 != (index = attributes.getIndex("value"))) {
                value = attributes.getValue(index);
            }
            currentJvm.addProperty(key, value);
            if (key.equals("java.fullversion")) {
                Dump theDump = DumpConsole.getTheDump();
                theDump.setFullVersion(value);
            }
        }
    }

    static {
        inTraceElement = false;
        bWithinConstantpool = false;
        bWithinClassLoader = false;
    }
}

