/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.util.Vector;

public class J9Heap {
    private long start;
    private long end;
    private HeapAllocBits hab;
    private static Dump theDump;
    private static boolean is32bit;
    private int inCount;
    private static byte[] objectAddressBuffer;
    private int count;
    private long size;
    private static J9Heap[] theHeaps;
    private static String name;
    private static int objectAlignment;
    private static int minimumObjectSize;

    public J9Heap(String startA, String endA, int countIn) {
        String s = DumpUtils.stripOff0x(startA);
        String e = DumpUtils.stripOff0x(endA);
        this.start = DumpUtils.parseLongHex(s);
        this.end = DumpUtils.parseLongHex(e);
        this.size = this.end - this.start;
        this.inCount = countIn;
        if (null == theDump) {
            theDump = DumpConsole.getTheDump();
        }
        is32bit = theDump.is32bit();
        J9JVMConsole.addHeap(this);
    }

    public void recordObjectPosition(long objectAaddress) {
        if (null == this.hab) {
            this.hab = new HeapAllocBits(this.size);
        }
        this.hab.recordObjectPosition(objectAaddress);
    }

    public long getEnd() {
        return this.end;
    }

    public long getStart() {
        return this.start;
    }

    public static J9Object checkForObjectBeforeAddress(long address) {
        J9Object retObject = null;
        int heapIndex = J9Heap.whatHeap(address);
        if (-1 != heapIndex) {
            retObject = true == theHeaps[heapIndex].checkAllocBit(address) ? new J9Object(address, heapIndex) : theHeaps[heapIndex].findPreviousObject(address, heapIndex);
        }
        return retObject;
    }

    public static J9Object checkForObject(long address) {
        J9Object retObject = null;
        int heapIndex = J9Heap.whatHeap(address);
        if (-1 != heapIndex) {
            if (theHeaps[heapIndex].checkAllocBit(address)) {
                retObject = new J9Object(address, heapIndex);
            }
        } else if (J9JVMConsole.getClass(address) != null) {
            retObject = new J9Object(address, -1);
        } else {
            try {
                retObject = new J9Object(address, -1);
                System.out.println("Non-live object found:");
            }
            catch (NullPointerException ex) {
                retObject = null;
            }
        }
        return retObject;
    }

    private J9Object findPreviousObject(long address, int heapId) {
        J9Object retObject = null;
        long foundAddr = this.hab.findAllocBitPreceding(address);
        if (foundAddr != 0L) {
            retObject = new J9Object(foundAddr, heapId);
        }
        return retObject;
    }

    public static int whatHeap(long address) {
        Vector heaps;
        int numHeaps;
        int retInt = -1;
        if (null == theHeaps && (numHeaps = (heaps = J9JVMConsole.getKnownHeaps()).size()) != 0) {
            theHeaps = new J9Heap[numHeaps];
            for (int i = 0; i < numHeaps; ++i) {
                J9Heap heap = (J9Heap)heaps.get(i);
                if (i > 0) {
                    if (heap.start > J9Heap.theHeaps[i - 1].start) {
                        J9Heap.theHeaps[i] = heap;
                        continue;
                    }
                    int pos = 0;
                    J9Heap temp = null;
                    for (int j = i - 1; j >= 0; --j) {
                        if (J9Heap.theHeaps[j].start >= heap.start) continue;
                        pos = j + 1;
                        j = -1;
                    }
                    temp = theHeaps[pos];
                    J9Heap.theHeaps[pos] = heap;
                    J9Heap temp1 = null;
                    for (int j = pos + 1; j == i; ++j) {
                        temp1 = theHeaps[j];
                        J9Heap.theHeaps[j] = temp;
                        temp = temp1;
                    }
                    continue;
                }
                J9Heap.theHeaps[i] = heap;
            }
        }
        if (theHeaps != null) {
            for (int i = 0; i < theHeaps.length; ++i) {
                if (address < theHeaps[i].getStart() || address > theHeaps[i].getEnd()) continue;
                return i;
            }
        }
        return retInt;
    }

    private boolean checkAllocBit(long address) {
        if (null == this.hab) {
            return false;
        }
        return this.hab.checkAllocBit(address);
    }

    public static J9Heap[] getTheHeaps() {
        return theHeaps;
    }

    public static J9Heap getAHeap(int i) {
        return theHeaps[i];
    }

    public int getCount() {
        return this.count;
    }

    public int getInCount() {
        return this.inCount;
    }

    public static void sortHeaps() {
        J9Heap.whatHeap(-1L);
    }

    public long getSize() {
        return this.size;
    }

    public static String getName() {
        return name;
    }

    public static void setName(String name) {
        J9Heap.name = name;
    }

    public static int getObjectAlignment() {
        return objectAlignment;
    }

    public static void setObjectAlignment(String objectAlignmentString) {
        try {
            objectAlignment = Integer.parseInt(objectAlignmentString);
        }
        catch (NumberFormatException nfe) {
            objectAlignment = 8;
        }
    }

    public static int getMinimumObjectSize() {
        return minimumObjectSize;
    }

    public static void setMinimumObjectSize(String minimumObjectSizeString) {
        try {
            minimumObjectSize = Integer.parseInt(minimumObjectSizeString);
        }
        catch (NumberFormatException nfe) {
            minimumObjectSize = 16;
        }
    }

    static {
        name = "J9Heap";
        objectAlignment = 8;
        minimumObjectSize = 16;
    }

    class HeapAllocBits {
        private int[] bitArray;
        private final int[] bitFlip = new int[]{Integer.MIN_VALUE, 0x40000000, 0x20000000, 0x10000000, 0x8000000, 0x4000000, 0x2000000, 0x1000000, 0x800000, 0x400000, 0x200000, 0x100000, 524288, 262144, 131072, 65536, 32768, 16384, 8192, 4096, 2048, 1024, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};
        private int divider = 256;

        HeapAllocBits(long size) {
            if (is32bit) {
                this.divider = 128;
            }
            int sizeRqd = (int)size / this.divider;
            if (size % (long)this.divider != 0L) {
                ++sizeRqd;
            }
            this.bitArray = new int[sizeRqd];
        }

        void recordObjectPosition(long addr) {
            long diff = addr - J9Heap.this.start;
            int intPos = (int)(diff / (long)this.divider);
            int div32 = this.divider / 32;
            int bitpos = (int)(diff % (long)this.divider) / div32;
            this.bitArray[intPos] = this.bitArray[intPos] | this.bitFlip[bitpos];
        }

        boolean checkAllocBit(long address) {
            int div32;
            int bitpos;
            boolean bRet = false;
            long diff = address - J9Heap.this.start;
            int intPos = (int)(diff / (long)this.divider);
            if (0 != (this.bitArray[intPos] & this.bitFlip[bitpos = (int)(diff % (long)this.divider) / (div32 = this.divider / 32)])) {
                bRet = true;
            }
            return bRet;
        }

        long findAllocBitPreceding(long address) {
            long retAddr = 0L;
            int div32 = this.divider / 32;
            if (0L != address % (long)div32) {
                address = (long)div32 * (address / (long)div32) + (long)div32;
            }
            long diff = address - J9Heap.this.start;
            int intPos = (int)(diff / (long)this.divider);
            int bitpos = (int)(diff % (long)this.divider) / div32;
            boolean bDone = false;
            while (!bDone) {
                if (0 == this.bitArray[intPos]) {
                    bitpos = 32;
                    if (--intPos >= 0) continue;
                    bDone = true;
                    continue;
                }
                if (0 != (this.bitArray[intPos] & this.bitFlip[bitpos])) {
                    retAddr = J9Heap.this.start + (long)((intPos * 32 + bitpos) * div32);
                    bDone = true;
                    continue;
                }
                if (--bitpos >= 0) continue;
                bitpos = 32;
                if (--intPos >= 0) continue;
                bDone = true;
            }
            return retAddr;
        }
    }
}

