/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.command.CommandPlugin;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.ConsoleMsg;
import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9Class;
import com.ibm.jvm.j9.dump.systemdump.J9Heap;
import com.ibm.jvm.j9.dump.systemdump.J9Object;
import java.util.Iterator;

public class J9ObjectIterator
implements Iterator {
    private static boolean CREATEOAFILE = false;
    private J9Heap[] theHeaps;
    private int currentHeap;
    private int numHeaps;
    private long currentInstance;
    private long prevInstance;
    private long currentHeapEnd;
    private Dump theDump;
    private int currentHeapCount;
    private int recorderedHeapCount;
    private CommandPlugin callingPlugin;
    private int ptrSize;
    private int classCount;
    private int alignment;
    private Iterator classesIterator = null;

    protected J9ObjectIterator() {
    }

    private J9ObjectIterator(CommandPlugin cp) {
        this.callingPlugin = cp;
        if (!CREATEOAFILE) {
            this.theDump = DumpConsole.getTheDump();
            this.theHeaps = J9Heap.getTheHeaps();
            this.numHeaps = this.theHeaps.length;
            this.currentHeap = 0;
            this.currentInstance = this.theHeaps[0].getStart();
            this.currentHeapEnd = this.theHeaps[0].getEnd();
            this.currentHeapCount = this.theHeaps[0].getInCount();
        }
        this.alignment = J9Heap.getObjectAlignment();
    }

    public static J9ObjectIterator getObjectIterator(CommandPlugin cp) {
        J9ObjectIterator iter = new J9ObjectIterator(cp);
        return iter;
    }

    public Object next() {
        if (0 == this.ptrSize) {
            this.ptrSize = true == DumpConsole.getTheDump().is32bit() ? 4 : 8;
        }
        if (null == this.classesIterator) {
            this.classesIterator = J9JVMConsole.getKnownClassesByName().keySet().iterator();
        }
        J9Object j9o = null;
        if (this.classesIterator.hasNext()) {
            if (this.classCount == 0 && this.callingPlugin != null && Console.getVerboseMode()) {
                this.callingPlugin.notifyObservers("\tRecording class instances ....");
            }
            ++this.classCount;
            String className = (String)this.classesIterator.next();
            J9Class c = J9JVMConsole.getClass(className);
            long address = c.getClassAddress();
            j9o = new J9Object(address, -1);
        } else {
            ConsoleMsg msg;
            if (this.classCount != -1) {
                if (this.callingPlugin != null && Console.getVerboseMode()) {
                    this.callingPlugin.notifyObservers("\t  ... " + this.classCount + " class instances recorded");
                    this.callingPlugin.notifyObservers("\tStarting scan of heap segment " + this.currentHeap + "  start=0x" + Long.toHexString(this.currentInstance) + "   end=0x" + Long.toHexString(this.currentHeapEnd) + "   object count= " + this.currentHeapCount);
                }
                this.classCount = -1;
            }
            long address = this.currentInstance;
            j9o = new J9Object(address, this.currentHeap);
            this.prevInstance = this.currentInstance;
            this.currentInstance += (long)j9o.getInstanceSize();
            if (this.prevInstance == this.currentInstance) {
                msg = new ConsoleMsg("\t !!!WARNING: Object of unknown size encountered at 0x" + Long.toHexString(this.currentInstance) + ", skipping to next heap segment", true);
                this.callingPlugin.notifyObservers(msg);
            } else if (this.theDump.getIntVersion() == 22) {
                if (0L != this.currentInstance % (long)this.ptrSize) {
                    this.currentInstance = this.currentInstance + (long)this.ptrSize - this.currentInstance % (long)this.ptrSize;
                }
            } else if (0L != this.currentInstance % (long)this.alignment) {
                this.currentInstance = this.currentInstance + (long)this.alignment - this.currentInstance % (long)this.alignment;
            }
            ++this.recorderedHeapCount;
            if (this.currentInstance >= this.currentHeapEnd || this.prevInstance == this.currentInstance) {
                ++this.currentHeap;
                if (this.recorderedHeapCount != this.currentHeapCount) {
                    msg = new ConsoleMsg("\t !!!WARNING: Discrepency in object count, xml says" + this.currentHeapCount + " scan found " + this.recorderedHeapCount, true);
                    this.callingPlugin.notifyObservers(msg);
                }
                this.recorderedHeapCount = 0;
                if (this.currentHeap < this.theHeaps.length) {
                    this.currentInstance = this.theHeaps[this.currentHeap].getStart();
                    this.currentHeapEnd = this.theHeaps[this.currentHeap].getEnd();
                    this.currentHeapCount = this.theHeaps[this.currentHeap].getInCount();
                    if (null != this.callingPlugin && Console.getVerboseMode()) {
                        this.callingPlugin.notifyObservers("\tStarting scan of heap segment " + this.currentHeap + "  start=0x" + Long.toHexString(this.currentInstance) + "   end=0x" + Long.toHexString(this.currentHeapEnd) + "   object count= " + this.currentHeapCount);
                    }
                }
            }
        }
        return j9o;
    }

    public void remove() {
    }

    public boolean hasNext() {
        return this.currentHeap < this.numHeaps;
    }
}

