/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.systemdump.Elfdump;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import java.io.IOException;

class ProgramHeaderElement {
    public static final int PT_NULL = 0;
    public static final int PT_LOAD = 1;
    public static final int PT_DYNAMIC = 2;
    public static final int PT_INTERP = 3;
    public static final int PT_NOTE = 4;
    public static final int PT_SHLIB = 5;
    public static final int PT_PHDR = 6;
    public static final int PT_TLS = 7;
    long type;
    long flags;
    long offset;
    long virtaddr;
    long physaddr;
    long filesize;
    long memsize;
    long align;
    MemoryRange range;

    public String toString() {
        String retString = "\ttype:" + this.type + "\toffset:0x" + Long.toHexString(this.offset) + "\tVirtAddr:0x" + Long.toHexString(this.virtaddr) + "\tPhyAddr:0x" + Long.toHexString(this.physaddr) + "\tfilesize:0x" + Long.toHexString(this.filesize) + "\tmemsize:0x" + Long.toHexString(this.memsize) + "\tflags:" + this.flags + "\tAlign:" + this.align;
        return retString;
    }

    protected ProgramHeaderElement() {
    }

    public ProgramHeaderElement(long type, long flags, long offset, long virtaddr, long physaddr, long filesize, long memsize, long align) {
        this.type = type;
        this.flags = flags;
        this.offset = offset;
        this.virtaddr = virtaddr;
        this.physaddr = physaddr;
        this.filesize = filesize;
        this.memsize = memsize;
        this.align = align;
        this.range = new MemoryRange(virtaddr, offset, memsize);
    }

    public static ProgramHeaderElement readProgramHeaderElement(Elfdump file, boolean is32bit) throws IOException {
        ProgramHeaderElement result = new ProgramHeaderElement();
        if (is32bit) {
            result.type = file.readUnsignInt();
            result.offset = file.readUnsignInt();
            result.virtaddr = file.readUnsignInt();
            result.physaddr = file.readUnsignInt();
            result.filesize = file.readUnsignInt();
            result.memsize = file.readUnsignInt();
            result.flags = file.readUnsignInt();
            result.align = file.readUnsignInt();
        } else {
            result.type = file.readUnsignInt();
            result.flags = file.readUnsignInt();
            result.offset = file.readUnsignLong();
            result.virtaddr = file.readUnsignLong();
            result.physaddr = file.readUnsignLong();
            result.filesize = file.readUnsignLong();
            result.memsize = file.readUnsignLong();
            result.align = file.readUnsignLong();
        }
        return result;
    }

    public MemoryRange getRange() {
        if (null == this.range) {
            this.range = new MemoryRange(this.virtaddr, this.offset, this.memsize);
        }
        return this.range;
    }
}

