/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.helpers;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.runtime.ManagedRuntime;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String byteToAscii = "................................ !\"#$%&'()*+'-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~.................................................................................................................................";
    public static final String byteToEbcdic = ".................................................................................................................................abcdefghi.......jklmnopqr........stuvwxyz.......................ABCDEFGHI.......JKLMNOPQR........STUVWXYZ......0123456789......";
    public static final String CURRENT_MEM_ADDRESS = "currentMemPtrAddress";
    public static final String CURRENT_NUM_BYTES_TO_PRINT = "currentNumBytes";
    public static final String RootCommand_OBJECT = "RootCommandObject";
    public static final String FIND_ATTRIBUTES = "FindAttributes";
    private static final int CLASS_MODIFIERS_MASK = 3103;
    private static final int INTERFACE_MODIFIERS_MASK = 3599;
    private static final int CONSTRUCTOR_MODIFIERS_MASK = 7;
    private static final int METHOD_MODIFIERS_MASK = 3391;
    private static final int FIELD_MODIFIERS_MASK = 223;
    public static final String SORT_BY_SIZE_FLAG = "-sort:size";
    public static final String SORT_BY_NAME_FLAG = "-sort:name";
    public static final String SORT_BY_ADDRESS_FLAG = "-sort:address";
    public static final String SORT_BY_COUNT_FLAG = "-sort:count";
    public static final String REVERSE_SORT_FLAG = "-sort:reverse";
    public static final String VERBOSE_FLAG = "-verbose";

    public static Iterator getRuntimes(Image loadedImage) {
        Vector<ManagedRuntime> runtimes = new Vector<ManagedRuntime>();
        Iterator itAddressSpace = loadedImage.getAddressSpaces();
        while (itAddressSpace.hasNext()) {
            ImageAddressSpace ias = (ImageAddressSpace)itAddressSpace.next();
            Iterator itProcess = ias.getProcesses();
            while (itProcess.hasNext()) {
                ImageProcess ip = (ImageProcess)itProcess.next();
                Iterator itRuntime = ip.getRuntimes();
                while (itRuntime.hasNext()) {
                    ManagedRuntime mr;
                    Object next = itRuntime.next();
                    if (next instanceof CorruptData || runtimes.contains(mr = (ManagedRuntime)next)) continue;
                    runtimes.add(mr);
                }
            }
        }
        return runtimes.iterator();
    }

    public static String toHex(ImagePointer p) {
        return Utils.toHex(p.getAddress());
    }

    public static String toHex(long l) {
        return "0x" + Long.toHexString(l);
    }

    public static String toHex(int i) {
        return "0x" + Integer.toHexString(i);
    }

    public static String toHex(short s) {
        return "0x" + Integer.toHexString(s & 0xFFFF);
    }

    public static String toHex(byte b) {
        return "0x" + Integer.toHexString(b & 0xFF);
    }

    public static String toFixedWidthHex(long l) {
        return Utils.padWithZeroes(Long.toHexString(l), 16);
    }

    public static String toFixedWidthHex(int i) {
        return Utils.padWithZeroes(Integer.toHexString(i), 8);
    }

    public static String toFixedWidthHex(short s) {
        return Utils.padWithZeroes(Integer.toHexString(s & 0xFFFF), 4);
    }

    public static String toFixedWidthHex(byte b) {
        return Utils.padWithZeroes(Integer.toHexString(b & 0xFF), 2);
    }

    public static Stack<String> constructStackFromString(String args) {
        String[] argsArray = args.split("\\s+");
        return Utils.constructStackFromStringArray(argsArray);
    }

    public static Stack<String> constructStackFromStringArray(String[] argsArray) {
        Stack<String> s = new Stack<String>();
        for (int i = argsArray.length - 1; i >= 0; --i) {
            s.push(argsArray[i]);
        }
        return s;
    }

    public static String concatArgsFromStack(Stack<String> args) {
        String s = "";
        while (!args.empty()) {
            s = s.concat(args.pop());
        }
        return s;
    }

    public static ImageAddressSpace _extractAddressSpace(Image loadedImage) {
        ImageAddressSpace space = null;
        Iterator spaces = loadedImage.getAddressSpaces();
        Object obj = null;
        while (spaces.hasNext()) {
            obj = spaces.next();
            if (!(obj instanceof ImageAddressSpace)) continue;
            space = obj;
            Iterator procs = space.getProcesses();
            while (procs.hasNext()) {
                obj = procs.next();
                if (!(obj instanceof ImageProcess)) continue;
                return space;
            }
        }
        return null;
    }

    public static Long longFromString(String value) {
        Long translated = null;
        if (null != value) {
            if (value.startsWith("0x")) {
                value = value.substring(2);
            }
            try {
                translated = new Long(Long.parseLong(value, 16));
            }
            catch (NumberFormatException e) {
                try {
                    BigInteger big = new BigInteger(value, 16);
                    translated = big.longValue();
                }
                catch (NumberFormatException e2) {
                    translated = null;
                }
            }
        }
        return translated;
    }

    public static Long longFromStringWithPrefix(String value) {
        Long translated = null;
        if (value.startsWith("0x")) {
            translated = Utils.longFromString(value);
        }
        return translated;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSignatureName(String signature) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        String retval = null;
        table.put("Z", "boolean");
        table.put("B", "byte");
        table.put("C", "char");
        table.put("S", "short");
        table.put("I", "int");
        table.put("J", "long");
        table.put("F", "float");
        table.put("D", "double");
        table.put("V", "void");
        if (signature.startsWith("L")) {
            StringTokenizer st = new StringTokenizer(signature.substring(1), ";");
            if (!st.hasMoreTokens()) return null;
            String className = st.nextToken();
            if (!className.startsWith("java/lang/")) return className.replaceAll("/", ".");
            className = className.substring(10);
            return className.replaceAll("/", ".");
        }
        if (!signature.startsWith("[")) return (String)table.get(signature.substring(0, 1));
        String currSig = new String(signature);
        String arraySuffix = "";
        while (currSig.startsWith("[")) {
            arraySuffix = arraySuffix + "[]";
            currSig = currSig.substring(1);
        }
        return Utils.getSignatureName(currSig) + arraySuffix;
    }

    public static String getMethodSignatureName(String signature) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        String retval = "";
        table.put("Z", "boolean");
        table.put("B", "byte");
        table.put("C", "char");
        table.put("S", "short");
        table.put("I", "int");
        table.put("J", "long");
        table.put("F", "float");
        table.put("D", "double");
        if (signature.startsWith("(")) {
            StringTokenizer st = new StringTokenizer(signature.substring(1), ")");
            if (st.hasMoreTokens()) {
                String parameters = st.nextToken();
                retval = st.hasMoreTokens() ? "(" + Utils.getMethodSignatureName(parameters) + ")" : "()";
            } else {
                retval = null;
            }
        } else if (signature.startsWith("L")) {
            StringTokenizer st = new StringTokenizer(signature.substring(1), ";");
            if (st.hasMoreTokens()) {
                String className = st.nextToken();
                if (className.startsWith("java/lang/")) {
                    className = className.substring(10);
                }
                retval = className.replaceAll("/", ".");
                if (st.hasMoreTokens()) {
                    retval = retval + ", " + Utils.getMethodSignatureName(signature.substring(signature.indexOf(59) + 1));
                }
            } else {
                retval = null;
            }
        } else if (signature.startsWith("[")) {
            String currSig = new String(signature);
            String arraySuffix = "";
            while (currSig.startsWith("[")) {
                arraySuffix = arraySuffix + "[]";
                currSig = currSig.substring(1);
            }
            if (currSig.startsWith("L")) {
                if (currSig.indexOf(59) + 1 == currSig.length()) {
                    retval = Utils.getSignatureName(currSig) + arraySuffix;
                } else {
                    retval = Utils.getMethodSignatureName(currSig.substring(0, currSig.indexOf(59) + 1));
                    retval = retval + arraySuffix + ", ";
                    retval = retval + Utils.getMethodSignatureName(currSig.substring(currSig.indexOf(59) + 1));
                }
            } else if (1 == currSig.length()) {
                retval = (String)table.get(currSig) + arraySuffix;
            } else {
                retval = (String)table.get(currSig.substring(0, 1)) + arraySuffix;
                retval = retval + ", ";
                retval = retval + Utils.getMethodSignatureName(currSig.substring(1));
            }
        } else {
            retval = (String)table.get(signature.substring(0, 1));
            if (signature.length() > 1) {
                retval = retval + ", " + Utils.getMethodSignatureName(signature.substring(1));
            }
        }
        return retval;
    }

    public static String getReturnValueName(String signature) {
        if (signature.startsWith("(")) {
            StringTokenizer st = new StringTokenizer(signature, ")");
            if (st.hasMoreTokens()) {
                st.nextToken();
                if (st.hasMoreTokens()) {
                    String retval = st.nextToken();
                    if (st.hasMoreTokens()) {
                        return null;
                    }
                    return Utils.getSignatureName(retval);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static String toString(String s) {
        if (null == s) {
            return "null";
        }
        return s;
    }

    public static File absPath(Properties properties, String path) {
        File oldPwd = (File)properties.get("pwd");
        File newPwd = new File(path);
        if (!newPwd.isAbsolute()) {
            newPwd = new File(oldPwd, path);
        }
        try {
            newPwd = newPwd.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        return newPwd;
    }

    public static String getVal(Object o) {
        return Utils.getVal(o, null, null);
    }

    public static String getVal(JavaObject jo, JavaField jf) {
        String s;
        Object o;
        if (null == jf) {
            o = jo;
            s = null;
        } else {
            try {
                o = jf.get(jo);
            }
            catch (CorruptDataException e) {
                return "<corrupt data>";
            }
            catch (MemoryAccessException d) {
                return "<invalid memory address>";
            }
            catch (NumberFormatException nfe) {
                return "<invalid number>";
            }
            try {
                s = jf.getString(jo);
            }
            catch (CorruptDataException e) {
                s = null;
            }
            catch (MemoryAccessException e) {
                s = null;
            }
            catch (IllegalArgumentException e) {
                s = null;
            }
        }
        return Utils.getVal(o, s, jf);
    }

    public static String getVal(Object o, String str, JavaField jf) {
        String val = "";
        Long value = null;
        boolean object = false;
        if (null == o) {
            val = val + "null";
        } else {
            if (o instanceof Boolean) {
                val = val + ((Boolean)o).toString();
            } else if (o instanceof Byte) {
                byte b = (Byte)o;
                val = val + String.valueOf(b);
                value = new Long(new Byte(b).longValue());
            } else if (o instanceof Character) {
                char c = ((Character)o).charValue();
                val = val + Utils.getPrintableWithQuotes(c);
                value = new Long(new Integer(c).longValue());
            } else if (o instanceof Double) {
                double d = (Double)o;
                val = val + String.valueOf(d);
                value = new Long(Double.doubleToRawLongBits(d));
            } else if (o instanceof Float) {
                float f = ((Float)o).floatValue();
                val = val + String.valueOf(f);
                value = new Long(Float.floatToRawIntBits(f));
            } else if (o instanceof Integer) {
                int i = (Integer)o;
                val = val + String.valueOf(i);
                value = new Long(new Integer(i).longValue());
            } else if (o instanceof Long) {
                long l = (Long)o;
                val = val + String.valueOf(l);
                value = new Long(l);
            } else if (o instanceof Short) {
                short s = (Short)o;
                val = val + String.valueOf(s);
                value = new Long(new Short(s).longValue());
            } else if (o instanceof String) {
                val = val + (String)o;
            } else if (o instanceof JavaObject) {
                if (Utils.isNull((JavaObject)o)) {
                    val = val + "null";
                } else {
                    object = true;
                }
            }
            if (object) {
                String jcName;
                JavaClass jcField;
                JavaObject joField = (JavaObject)o;
                try {
                    jcField = joField.getJavaClass();
                }
                catch (CorruptDataException e) {
                    jcField = null;
                }
                try {
                    jcName = null != jcField ? jcField.getName() : null;
                }
                catch (CorruptDataException e) {
                    jcName = null;
                }
                boolean nestedPackedField = false;
                try {
                    nestedPackedField = joField.isNestedPacked();
                }
                catch (CorruptDataException e1) {
                    jcName = null;
                }
                catch (DataUnavailable e1) {
                    jcName = null;
                }
                catch (UnsupportedOperationException e1) {
                    jcName = null;
                }
                if (null != jcName && jcName.equals("java/lang/String")) {
                    val = null == str ? val + Utils.getStringVal(joField) : val + "\"" + Utils.getPrintable(str) + "\"";
                    val = val + " @ ";
                    val = val + Utils.toHex(joField.getID().getAddress());
                } else if (nestedPackedField) {
                    val = val + "<nested packed object> ";
                    try {
                        if (jcField.isPacked() && jcName.endsWith("$Array")) {
                            jcName = jcName + "[" + jf.getPackedLengthAnnotationValue() + "]";
                        }
                    }
                    catch (CorruptDataException e) {
                        jcName = jcName + "[]";
                    }
                    catch (MemoryAccessException e) {
                        jcName = jcName + "[]";
                    }
                    catch (DataUnavailable e) {
                        jcName = jcName + "[]";
                    }
                    val = val + jcName + " packed @ " + Utils.toHex(joField.getID().getAddress());
                } else {
                    val = val + "<object> @ " + Utils.toHex(joField.getID().getAddress());
                }
            }
        }
        if (null != value) {
            val = val + " (";
            val = val + Utils.toHex(value);
            val = val + ")";
        }
        return val;
    }

    private static String getStringVal(JavaObject jo) {
        int arraySize;
        JavaClass jc;
        try {
            jc = jo.getJavaClass();
        }
        catch (CorruptDataException e) {
            return "<cannot get String class from String object (" + Exceptions.getCorruptDataExceptionString() + ")>";
        }
        Iterator itJavaField = jc.getDeclaredFields();
        JavaField jf = null;
        while (itJavaField.hasNext()) {
            jf = (JavaField)itJavaField.next();
            try {
                if (!jf.getSignature().equals("[C") || Modifier.isStatic(jf.getModifiers())) continue;
                break;
            }
            catch (CorruptDataException e) {
            }
        }
        if (jf == null) {
            return "<cannot get char array out of String>";
        }
        JavaObject charArray = null;
        try {
            charArray = (JavaObject)jf.get(jo);
        }
        catch (CorruptDataException e) {
            return "<cannot get char array out of String (" + Exceptions.getCorruptDataExceptionString() + ")>";
        }
        catch (MemoryAccessException e) {
            return "<cannot get char array out of String (" + Exceptions.getMemoryAccessExceptionString() + ")>";
        }
        try {
            arraySize = charArray.getArraySize();
        }
        catch (CorruptDataException e) {
            return "<cannot determine the size of the array (" + Exceptions.getCorruptDataExceptionString() + ")>";
        }
        char[] dst = new char[arraySize];
        try {
            charArray.arraycopy(0, (Object)dst, 0, arraySize);
        }
        catch (CorruptDataException e) {
            return "<cannot copy data from the array (" + Exceptions.getCorruptDataExceptionString() + ")>";
        }
        catch (MemoryAccessException e) {
            return "<cannot copy data from the array (" + Exceptions.getMemoryAccessExceptionString() + ")>";
        }
        return "\"" + Utils.getPrintable(new String(dst)) + "\"";
    }

    public static String getPrintable(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\\\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        char i = c;
        if (i <= '\u00ff') {
            if (i >= ' ' && i <= '~') {
                return String.valueOf(c);
            }
            return "\\" + Utils.padWithZeroes(Integer.toOctalString(i), 3);
        }
        return "\\u" + Utils.padWithZeroes(Integer.toHexString(i), 4);
    }

    public static String getPrintableWithQuotes(char c) {
        return "'" + Utils.getPrintable(c) + "'";
    }

    public static String getPrintable(String s) {
        String retval = "";
        for (int i = 0; i < s.length(); ++i) {
            retval = retval + Utils.getPrintable(s.charAt(i));
        }
        return retval;
    }

    public static String padWithZeroes(String unpadded, int desiredLength) {
        String output = new String(unpadded);
        for (int i = unpadded.length(); i < desiredLength; ++i) {
            output = "0" + output;
        }
        return output;
    }

    public static Iterator getAddressSapceSectionInfo(Image loadedImage) {
        Iterator itAddressSpace = loadedImage.getAddressSpaces();
        Vector vSections = new Vector();
        while (itAddressSpace.hasNext()) {
            ImageAddressSpace imageAddressSpace = (ImageAddressSpace)itAddressSpace.next();
            Iterator iSections = imageAddressSpace.getImageSections();
            while (iSections.hasNext()) {
                vSections.add(iSections.next());
            }
        }
        return vSections.iterator();
    }

    public static String getFieldModifierString(JavaField jf) throws CorruptDataException {
        int modifiers = jf.getModifiers();
        int typeMask = 223;
        return Utils.getModifierString(modifiers, typeMask);
    }

    public static String getMethodModifierString(JavaMethod jm) throws CorruptDataException {
        int modifiers = jm.getModifiers();
        int typeMask = "<init>".equals(jm.getName()) ? 7 : 3391;
        return Utils.getModifierString(modifiers, typeMask);
    }

    public static String getClassModifierString(JavaClass jc) throws CorruptDataException {
        int modifiers = jc.getModifiers();
        int typeMask = Modifier.isInterface(modifiers) ? 3599 : 3103;
        return Utils.getModifierString(modifiers, typeMask);
    }

    private static String getModifierString(int modifiers, int typeMask) {
        if (modifiers == -16777216) {
            return "No modifiers available";
        }
        String retval = "";
        if (Modifier.isPublic(modifiers &= typeMask)) {
            retval = retval + "public ";
        }
        if (Modifier.isPrivate(modifiers)) {
            retval = retval + "private ";
        }
        if (Modifier.isProtected(modifiers)) {
            retval = retval + "protected ";
        }
        if (Modifier.isStatic(modifiers)) {
            retval = retval + "static ";
        }
        if (Modifier.isAbstract(modifiers)) {
            retval = retval + "abstract ";
        }
        if (Modifier.isFinal(modifiers)) {
            retval = retval + "final ";
        }
        if (Modifier.isSynchronized(modifiers)) {
            retval = retval + "synchronized ";
        }
        if (Modifier.isVolatile(modifiers)) {
            retval = retval + "volatile ";
        }
        if (Modifier.isTransient(modifiers)) {
            retval = retval + "transient ";
        }
        if (Modifier.isNative(modifiers)) {
            retval = retval + "native ";
        }
        if (Modifier.isInterface(modifiers)) {
            retval = retval + "interface ";
        }
        if (Modifier.isStrict(modifiers)) {
            retval = retval + "strict ";
        }
        return retval;
    }

    public static boolean isNull(JavaObject jo) {
        return jo.getID().getAddress() == 0L;
    }

    public static String padWithSpaces(String unpadded, int desiredLength) {
        String output = new String(unpadded);
        for (int i = unpadded.length(); i < desiredLength; ++i) {
            output = output + " ";
        }
        return output;
    }

    public static String prePadWithSpaces(String unpadded, int desiredLength) {
        String output = "";
        for (int i = unpadded.length(); i < desiredLength; ++i) {
            output = output + " ";
        }
        output = output + unpadded;
        return output;
    }

    public static JavaClass[] getClassGivenName(String className, JavaRuntime jr, PrintStream out) {
        Iterator itJavaClassLoader = jr.getJavaClassLoaders();
        ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
        while (itJavaClassLoader.hasNext()) {
            Object nextCl = itJavaClassLoader.next();
            if (!(nextCl instanceof JavaClassLoader)) continue;
            JavaClassLoader jcl = (JavaClassLoader)nextCl;
            Iterator itJavaClass = jcl.getDefinedClasses();
            while (itJavaClass.hasNext()) {
                String currClassName;
                Object next = itJavaClass.next();
                if (!(next instanceof JavaClass)) continue;
                JavaClass jc = (JavaClass)next;
                try {
                    currClassName = jc.getName();
                    if (!currClassName.equals(className)) continue;
                    classes.add(jc);
                }
                catch (CorruptDataException e) {
                    out.print("\t  <error getting class name while traversing classes: ");
                    out.print(Exceptions.getCorruptDataExceptionString());
                    out.print(">\n");
                    currClassName = null;
                }
            }
        }
        if (classes.size() > 0) {
            return classes.toArray(new JavaClass[0]);
        }
        return null;
    }

    public static JavaClass getClassGivenAddress(long address, JavaRuntime jr) {
        Iterator itJavaClassLoader = jr.getJavaClassLoaders();
        while (itJavaClassLoader.hasNext()) {
            Object nextCl = itJavaClassLoader.next();
            if (!(nextCl instanceof JavaClassLoader)) continue;
            JavaClassLoader jcl = (JavaClassLoader)nextCl;
            Iterator itJavaClass = jcl.getDefinedClasses();
            while (itJavaClass.hasNext()) {
                JavaClass jc;
                long currClassAddress;
                Object next = itJavaClass.next();
                if (!(next instanceof JavaClass) || !(next instanceof JavaClass) || (currClassAddress = (jc = (JavaClass)next).getID().getAddress()) != address) continue;
                return jc;
            }
        }
        return null;
    }

    public static JavaThread getParkBlockerOwner(JavaObject blocker, JavaRuntime r) throws CorruptDataException, MemoryAccessException {
        JavaObject ownerObj = Utils.getParkBlockerOwnerObject(blocker, r);
        if (ownerObj == null) {
            return null;
        }
        Iterator threads = r.getThreads();
        while (threads.hasNext()) {
            JavaThread thread;
            Object lObj = threads.next();
            if (!(lObj instanceof JavaThread) || !ownerObj.equals((thread = (JavaThread)lObj).getObject())) continue;
            return thread;
        }
        return null;
    }

    public static JavaObject getParkBlockerOwnerObject(JavaObject blocker, JavaRuntime r) throws CorruptDataException, MemoryAccessException {
        JavaClass blockingClass;
        if (blocker == null) {
            return null;
        }
        for (blockingClass = blocker.getJavaClass(); blockingClass != null && !"java/util/concurrent/locks/AbstractOwnableSynchronizer".equals(blockingClass.getName()); blockingClass = blockingClass.getSuperclass()) {
        }
        if (blockingClass != null) {
            Iterator fields = blockingClass.getDeclaredFields();
            while (fields.hasNext()) {
                JavaField field;
                Object f = fields.next();
                if (!(f instanceof JavaField) || !"exclusiveOwnerThread".equals((field = (JavaField)f).getName())) continue;
                JavaObject ownerObj = (JavaObject)field.get(blocker);
                return ownerObj;
            }
        }
        return null;
    }

    public static String getThreadNameFromObject(JavaObject lockOwnerObj, JavaRuntime rt, PrintStream out) throws CorruptDataException, MemoryAccessException {
        if (lockOwnerObj == null) {
            return null;
        }
        JavaClass[] threadClasses = Utils.getClassGivenName("java/lang/Thread", rt, out);
        if (threadClasses.length == 1) {
            Iterator fields = threadClasses[0].getDeclaredFields();
            while (fields.hasNext()) {
                JavaField f;
                Object o = fields.next();
                if (!(o instanceof JavaField) || !"name".equalsIgnoreCase((f = (JavaField)o).getName())) continue;
                return f.getString(lockOwnerObj);
            }
        }
        return null;
    }
}

