/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.heapdump.portable;

import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpRecord;
import java.io.DataOutput;
import java.io.IOException;

public class PrimitiveArrayRecord
extends PortableHeapDumpRecord {
    private final int _type;
    private final int _numberOfElements;
    private final int _hashCode;
    private final boolean _is64Bit;
    private final long _instanceSize;
    private final boolean _is32BitHash;

    public PrimitiveArrayRecord(long address, long previousAddress, int type, int numberOfElements, int hashCode, boolean is64Bit, long instanceSize, boolean is32BitHash) {
        super(address, previousAddress, null);
        this._type = type;
        this._numberOfElements = numberOfElements;
        this._hashCode = hashCode;
        this._is64Bit = is64Bit;
        this._instanceSize = instanceSize;
        this._is32BitHash = is32BitHash;
        if (type < 0 || type > 7) {
            throw new IllegalArgumentException("Unrecognised type code: " + type);
        }
    }

    protected void writeHeapDump(DataOutput out) throws IOException {
        int tagAndFlag = 32;
        tagAndFlag = (byte)(tagAndFlag | this._type << 2);
        byte arrayLengthSize = PortableHeapDumpRecord.sizeofReference(this._numberOfElements);
        byte fieldSize = arrayLengthSize > this._gapSize ? arrayLengthSize : this._gapSize;
        tagAndFlag = (byte)(tagAndFlag | fieldSize);
        out.writeByte(tagAndFlag);
        this.writeReference(out, fieldSize, this._gapPreceding);
        this.writeReference(out, fieldSize, arrayLengthSize);
        if (!this._is32BitHash) {
            out.writeShort(this._hashCode);
        }
        out.writeInt((int)(this._instanceSize / 4L));
    }
}

