/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.CMSKeyStoreSpi;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;

public final class CMSProvider
extends Provider {
    private static final long serialVersionUID = 3978993149995988272L;

    public CMSProvider() {
        super("IBMCMSProvider", CMSProvider.getBuildNumber(), "Java 2 Implementation of CMS Key Databases");
        this.commonPart(null);
    }

    public CMSProvider(String args) {
        super("IBMCMSProvider", CMSProvider.getBuildNumber(), "Java 2 Implementation of CMS Key Databases");
        this.commonPart(args);
    }

    private void commonPart(final String args) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (args != null) {
                    String[] argsa = args.split("\\s+");
                    for (int i = 0; i < argsa.length; ++i) {
                        String a = argsa[i];
                        if (a.equalsIgnoreCase("v3")) {
                            CMSKeyStoreSpi.version = 3;
                            continue;
                        }
                        if (a.equalsIgnoreCase("-trace")) {
                            CMSKeyStoreSpi.tracing = true;
                            if (i + 1 < argsa.length) {
                                CMSKeyStoreSpi.traceFileName = argsa[++i];
                            }
                            CMSKeyStoreSpi.trace("CMSProvider start trace");
                            CMSKeyStoreSpi.trace("-----------------------");
                            continue;
                        }
                        if (!a.equalsIgnoreCase("-nopopulate")) continue;
                        CMSKeyStoreSpi.populate = false;
                    }
                }
                CMSProvider.this.put("KeyStore.IBMCMSKS", "com.ibm.security.cmskeystore.CMSKeyStoreSpi");
                CMSProvider.this.put("Alg.Alias.KeyStore.CMSKS", "IBMCMSKS");
                CMSProvider.this.put("Alg.Alias.KeyStore.CMS", "IBMCMSKS");
                CMSProvider.this.put("MessageDigest.MD5", "com.ibm.security.cmskeystore.WrappedMD5");
                CMSProvider.this.put("MessageDigest.SHA1", "com.ibm.security.cmskeystore.WrappedSHA1");
                Provider jceProvider = Security.getProvider("IBMJCE");
                if (jceProvider != null) {
                    jceProvider.put("Cipher.PBEWithSHAAnd3KeyTripleDESDeprecated", "com.ibm.security.cmskeystore.PBEWithSHAAnd3KeyTripleDESDeprecatedCipher");
                    jceProvider.put("Alg.Alias.Cipher.1.2.840.113549.1.12.5.1.3", "PBEWithSHAAnd3KeyTripleDESDeprecated");
                    jceProvider.put("SecretKeyFactory.PBEWithSHAAnd3KeyTripleDESDeprecated", "com.ibm.security.cmskeystore.NonPrintableAsciiPBEKeyFactory");
                    jceProvider.put("SecretKeyFactory.1.2.840.113549.1.12.5.1.3", "com.ibm.security.cmskeystore.NonPrintableAsciiPBEKeyFactory");
                }
                return null;
            }
        });
    }

    private static double getBuildNumber() {
        String injectedBuildNumber = "000054";
        Double buildNumber = 0.0;
        try {
            buildNumber = Double.parseDouble(injectedBuildNumber);
        }
        catch (Exception e) {
            buildNumber = 0.0;
        }
        return buildNumber;
    }
}

