/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.FileHeaderHashGenerator;
import com.ibm.security.cmskeystore.NonPrintableAsciiPBEKey;
import com.ibm.security.cmskeystore.VersionNumber;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.PBEKeySpec;

final class FileHeaderHashGeneratorFactory {
    private FileHeaderHashGeneratorFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static FileHeaderHashGenerator newFileHeaderHashGenerator(FileHeader header) {
        if (header.getMajorVersionNumber().equals(VersionNumber.THREE)) {
            return new FileHeaderHashGeneratorV3Impl();
        }
        return new FileHeaderHashGeneratorV4Impl();
    }

    private static final class FileHeaderHashGeneratorV3Impl
    implements FileHeaderHashGenerator {
        private FileHeaderHashGeneratorV3Impl() {
        }

        public ByteSequence generateHash(FileHeader header, String password) throws NullPointerException, NoSuchAlgorithmException, UnsupportedEncodingException {
            if (header == null || password == null) {
                throw new NullPointerException();
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            ByteSequenceIterator i = header.getMagicNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMajorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMinorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordExpirationTime().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileType().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFixedRecordLength().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getRecordsAllocated().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileLabel().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            ByteSequence pwd = ByteSequenceFactory.newByteSequence(password.getBytes("UTF-8"));
            i = pwd.getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            byte[] digest = md.digest();
            return ByteSequenceFactory.newByteSequence(digest);
        }
    }

    private static final class FileHeaderHashGeneratorV4Impl
    implements FileHeaderHashGenerator {
        private FileHeaderHashGeneratorV4Impl() {
        }

        public ByteSequence generateHash(FileHeader header, String password) throws NullPointerException, NoSuchAlgorithmException {
            if (header == null || password == null) {
                throw new NullPointerException();
            }
            Mac md = Mac.getInstance("HmacSHA1");
            try {
                md.init(new NonPrintableAsciiPBEKey(new PBEKeySpec(password.toCharArray())));
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
            ByteSequenceIterator i = header.getMagicNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMajorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMinorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordExpirationTime().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileType().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFixedRecordLength().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getRecordsAllocated().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileLabel().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            byte[] digest = md.doFinal();
            return ByteSequenceFactory.newByteSequence(digest);
        }
    }
}

