/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.PKCS12GenDeprecatedKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PBEWithSHAAnd3KeyTripleDESDeprecatedCipher
extends CipherSpi {
    private Cipher wrappedCipher;
    private static final int DEFAULT_ITERATION_COUNT = 10;
    private static final int DEFAULT_SALT_LENGTH = 20;

    public PBEWithSHAAnd3KeyTripleDESDeprecatedCipher() {
        try {
            this.wrappedCipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate cipher ", e);
        }
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.wrappedCipher.doFinal(input, inputOffset, inputLen);
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.wrappedCipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    protected int engineGetBlockSize() {
        return this.wrappedCipher.getBlockSize();
    }

    protected byte[] engineGetIV() {
        return this.wrappedCipher.getIV();
    }

    protected int engineGetOutputSize(int inputLen) {
        return this.wrappedCipher.getOutputSize(inputLen);
    }

    protected AlgorithmParameters engineGetParameters() {
        return this.wrappedCipher.getParameters();
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("AlgorithmParameter not accepted", e);
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int iterationCount;
        byte[] salt;
        if (params == null) {
            if (opmode == 2) {
                throw new InvalidAlgorithmParameterException("params is null");
            }
            salt = new byte[20];
            random.nextBytes(salt);
            iterationCount = 10;
        } else if (params instanceof PBEParameterSpec) {
            PBEParameterSpec pbeSpec = (PBEParameterSpec)params;
            salt = pbeSpec.getSalt();
            iterationCount = pbeSpec.getIterationCount();
        } else {
            throw new InvalidAlgorithmParameterException("incorrect parameter type " + params.getClass());
        }
        if (key == null || !key.getAlgorithm().equals("PBE")) {
            throw new InvalidKeyException("key is null or incorrect type");
        }
        byte[] password = key.getEncoded();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            byte[] iv = PKCS12GenDeprecatedKey.pfxComputeKeyIVBuffer(password, salt, iterationCount, 8, digest);
            byte[] keyData = PKCS12GenDeprecatedKey.pfxComputeKeyMaterialBuffer(password, salt, iterationCount, 24, digest);
            DESedeKeySpec desEdeSpec = new DESedeKeySpec(keyData);
            SecretKeyFactory desEdeFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey desEdeKey = desEdeFactory.generateSecret(desEdeSpec);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            this.wrappedCipher.init(opmode, (Key)desEdeKey, ivSpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required algorithm not available ", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Invalid key spec " + e);
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            if (params == null) {
                this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
            } else {
                this.engineInit(opmode, key, params.getParameterSpec(PBEParameterSpec.class), random);
            }
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidAlgorithmParameterException(e);
        }
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new UnsupportedOperationException("Cannot set mode of this Cipher");
    }

    protected void engineSetPadding(String arg0) throws NoSuchPaddingException {
        throw new UnsupportedOperationException("Cannot set padding of this Cipher");
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.wrappedCipher.update(input, inputOffset, inputLen);
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.wrappedCipher.update(input, inputOffset, inputLen, output, outputOffset);
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey) {
            SecretKey secretKey = (SecretKey)key;
            return secretKey.getEncoded().length * 8;
        }
        return super.engineGetKeySize(key);
    }
}

