/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.KeyStore;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public final class StashedPasswordProtection
implements KeyStore.ProtectionParameter,
Destroyable {
    private File stashFile = null;
    private char[] password = null;
    static final int PASS_MAX_LEN = 129;

    public StashedPasswordProtection(File stashFile) {
        if (stashFile == null) {
            throw new NullPointerException("The provided Stash file object is invalid.");
        }
        if (!stashFile.canRead()) {
            throw new RuntimeException("Cannot read from the provided stash file.");
        }
        this.stashFile = stashFile;
    }

    private StashedPasswordProtection() {
        throw new UnsupportedOperationException();
    }

    private static void wipeArray(char[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = '\u0000';
        }
    }

    private static void wipeArray(byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0;
        }
    }

    public char[] getPassword() throws IOException {
        if (this.password == null && this.stashFile != null) {
            ByteBuffer bytebuf;
            Charset utf8Set;
            CharBuffer charbuf;
            FileInputStream in = new FileInputStream(this.stashFile);
            byte[] buffer = new byte[129];
            if (((InputStream)in).read(buffer) != 129) {
                throw new IOException("Invalid stash file format.");
            }
            ((InputStream)in).close();
            int endOfPwdIndex = 0;
            for (int i = 0; i < 129; ++i) {
                buffer[i] = (byte)(buffer[i] ^ 0xF5);
                if (buffer[i] != 0 || endOfPwdIndex != 0) continue;
                endOfPwdIndex = i;
                break;
            }
            if (!(charbuf = (utf8Set = Charset.forName("UTF-8")).decode(bytebuf = ByteBuffer.wrap(buffer, 0, endOfPwdIndex))).hasArray()) {
                throw new RuntimeException("Can't decode the password from the stash file.");
            }
            this.password = new char[endOfPwdIndex];
            System.arraycopy(charbuf.array(), 0, this.password, 0, endOfPwdIndex);
            StashedPasswordProtection.wipeArray(buffer);
            StashedPasswordProtection.wipeArray(charbuf.array());
        }
        return this.password;
    }

    public synchronized void destroy() throws DestroyFailedException {
        if (this.password != null && this.password.length > 0) {
            StashedPasswordProtection.wipeArray(this.password);
            this.password = null;
        }
        if (this.stashFile != null) {
            this.stashFile = null;
        }
    }

    public boolean isDestroyed() {
        return this.password == null && this.stashFile == null;
    }
}

