/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.sasl.gsskerb;

import com.ibm.security.sasl.gsskerb.GssKrb5Base;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;

final class GssKrb5Client
extends GssKrb5Base
implements SaslClient {
    private static final String MY_CLASS_NAME = GssKrb5Client.class.getName();
    private boolean finalHandshake = false;
    private boolean mutual = false;
    private byte[] authzID;

    GssKrb5Client(String authzID, String protocol, String serverName, Map props, CallbackHandler cbh) throws SaslException {
        super(props, MY_CLASS_NAME);
        String service = protocol + "@" + serverName;
        logger.log(Level.FINE, "KRB5CLNT01:Requesting service name: {0}", service);
        try {
            Object prop;
            GSSManager mgr = GSSManager.getInstance();
            GSSName acceptorName = mgr.createName(service, GSSName.NT_HOSTBASED_SERVICE, KRB5_OID);
            GSSCredential credentials = null;
            if (props != null && (prop = props.get("javax.security.sasl.credentials")) != null && prop instanceof GSSCredential) {
                credentials = (GSSCredential)prop;
                logger.log(Level.FINE, "KRB5CLNT01:Using the credentials supplied in javax.security.sasl.credentials");
            }
            this.secCtx = mgr.createContext(acceptorName, KRB5_OID, credentials, Integer.MAX_VALUE);
            if (props != null && (prop = (String)props.get("javax.security.sasl.server.authentication")) != null) {
                this.mutual = "true".equalsIgnoreCase((String)prop);
            }
            this.secCtx.requestMutualAuth(this.mutual);
            this.secCtx.requestConf(true);
            this.secCtx.requestInteg(true);
        }
        catch (GSSException e) {
            throw new SaslException("Failure to initialize security context", e);
        }
        if (authzID != null && authzID.length() > 0) {
            try {
                this.authzID = authzID.getBytes("UTF8");
            }
            catch (IOException e) {
                throw new SaslException("Cannot encode authorization ID", e);
            }
        }
    }

    public boolean hasInitialResponse() {
        return true;
    }

    public byte[] evaluateChallenge(byte[] challengeData) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("GSSAPI authentication already complete");
        }
        if (this.finalHandshake) {
            return this.doFinalHandshake(challengeData);
        }
        try {
            byte[] gssOutToken = this.secCtx.initSecContext(challengeData, 0, challengeData.length);
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Client.traceOutput(MY_CLASS_NAME, "evaluteChallenge", "KRB5CLNT02:Challenge: [raw]", challengeData);
                GssKrb5Client.traceOutput(MY_CLASS_NAME, "evaluateChallenge", "KRB5CLNT03:Response: [after initSecCtx]", gssOutToken);
            }
            if (this.secCtx.isEstablished()) {
                this.finalHandshake = true;
                if (gssOutToken == null) {
                    return EMPTY;
                }
            }
            return gssOutToken;
        }
        catch (GSSException e) {
            throw new SaslException("GSS initiate failed", e);
        }
    }

    private byte[] doFinalHandshake(byte[] challengeData) throws SaslException {
        try {
            byte selectedQop;
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Client.traceOutput(MY_CLASS_NAME, "doFinalHandshake", "KRB5CLNT04:Challenge [raw]:", challengeData);
            }
            if (challengeData.length == 0) {
                return EMPTY;
            }
            byte[] gssOutToken = this.secCtx.unwrap(challengeData, 0, challengeData.length, new MessageProp(0, false));
            if (logger.isLoggable(Level.FINE)) {
                if (logger.isLoggable(Level.FINER)) {
                    GssKrb5Client.traceOutput(MY_CLASS_NAME, "doFinalHandshake", "KRB5CLNT05:Challenge [unwrapped]:", gssOutToken);
                }
                logger.log(Level.FINE, "KRB5CLNT06:Server protections: {0}", new Byte(gssOutToken[0]));
            }
            if ((selectedQop = GssKrb5Client.findPreferredMask(gssOutToken[0], this.qop)) == 0) {
                throw new SaslException("No common protection layer between client and server");
            }
            if ((selectedQop & 4) != 0) {
                this.privacy = true;
                this.integrity = true;
            } else if ((selectedQop & 2) != 0) {
                this.integrity = true;
            }
            int srvMaxBufSize = GssKrb5Client.networkByteOrderToInt(gssOutToken, 1, 3);
            this.sendMaxBufSize = this.sendMaxBufSize == 0 ? srvMaxBufSize : Math.min(this.sendMaxBufSize, srvMaxBufSize);
            this.rawSendSize = this.secCtx.getWrapSizeLimit(0, this.privacy, this.sendMaxBufSize);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "KRB5CLNT07:Client max recv size: {0}; server max recv size: {1}; rawSendSize: {2}", new Object[]{new Integer(this.recvMaxBufSize), new Integer(srvMaxBufSize), new Integer(this.rawSendSize)});
            }
            int len = 4;
            if (this.authzID != null) {
                len += this.authzID.length;
            }
            byte[] gssInToken = new byte[len];
            gssInToken[0] = selectedQop;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "KRB5CLNT08:Selected protection: {0}; privacy: {1}; integrity: {2}", new Object[]{new Byte(selectedQop), this.privacy, this.integrity});
            }
            GssKrb5Client.intToNetworkByteOrder(this.recvMaxBufSize, gssInToken, 1, 3);
            if (this.authzID != null) {
                System.arraycopy(this.authzID, 0, gssInToken, 4, this.authzID.length);
                logger.log(Level.FINE, "KRB5CLNT09:Authzid: {0}", (Object)this.authzID);
            }
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Client.traceOutput(MY_CLASS_NAME, "doFinalHandshake", "KRB5CLNT10:Response [raw]", gssInToken);
            }
            gssOutToken = this.secCtx.wrap(gssInToken, 0, gssInToken.length, new MessageProp(0, false));
            if (logger.isLoggable(Level.FINER)) {
                GssKrb5Client.traceOutput(MY_CLASS_NAME, "doFinalHandshake", "KRB5CLNT11:Response [after wrap]", gssOutToken);
            }
            this.completed = true;
            this.msgProp = new MessageProp(0, this.privacy);
            return gssOutToken;
        }
        catch (GSSException e) {
            throw new SaslException("Final handshake failed", e);
        }
    }
}

