/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.AlgorithmChecker;
import com.ibm.security.cert.CertPathSystemProperties;
import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.cert.CertificateFactoryImpl;
import com.ibm.security.cert.CompositeCRL;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.CRLDistributionPointsExtension;
import com.ibm.security.x509.CRLReasonCodeExtension;
import com.ibm.security.x509.DistributionPoint;
import com.ibm.security.x509.DistributionPointName;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.IssuingDistributionPointExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.RDN;
import com.ibm.security.x509.ReasonFlags;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLEntryImpl;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXReason;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.security.auth.x500.X500Principal;

public class CRSChecker {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    static final String[] myExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.CRLDistributionPoints").toString()};
    static final String[] deltaCRLAttrIDArray = new String[]{"deltaRevocationList"};
    static final String[] baseCRLAttrIDArray = new String[]{"certificateRevocationList"};
    static final String[] baseARLAttrIDArray = new String[]{"authorityRevocationList"};
    static final String[] allCRLAttrIDArray = new String[]{"authorityRevocationList", "authorityRevocationList;binary", "certificateRevocationList", "certificateRevocationList;binary", "deltaRevocationList", "deltaRevocationList;binary"};
    private CertPath certPath;
    private Collection certStores;
    private boolean trustCertPathForCRLs;
    private boolean useDeltas;
    private Set trustBaseSet;
    private Date validationDate;
    private int numberOfCertsInCertPath;
    private String sigProvider;
    private Collection ibmCollectionCertStores = null;
    private int currentCertIndex;
    private Vector willBeTrustedCollection;
    private Hashtable CRLCache = new Hashtable();
    private boolean[] userReasons = new boolean[]{false, true, true, true, true, true, true};
    private TrustAnchor trustAnchor;
    private static final int CHECK_INTERVAL = 600000;
    private static final boolean[] ALL_REASONS = new boolean[]{true, true, true, true, true, true, true, true, true};
    private boolean certificateHoldEncounteredForThisCert;
    private boolean certificateRemoveEncounteredForThisCert;

    public CRSChecker(CertPath certPath, Collection certStores, boolean trustCertPathForCRLs, boolean useDeltas, Set trustBaseSet, Date validationDate, boolean useFreshestData, String sigProvider) throws CertPathValidatorException {
        this.certPath = certPath;
        this.certStores = certStores;
        this.trustCertPathForCRLs = trustCertPathForCRLs;
        this.useDeltas = useDeltas;
        this.trustBaseSet = trustBaseSet;
        this.validationDate = validationDate;
        this.sigProvider = sigProvider;
        List<? extends Certificate> certPathCerts = certPath.getCertificates();
        this.numberOfCertsInCertPath = certPathCerts.size();
        this.currentCertIndex = this.numberOfCertsInCertPath - 1;
        this.willBeTrustedCollection = new Vector();
        this.ibmCollectionCertStores = this.getIBMCollectionCertStores(certStores);
        this.CRLCache = this.setCRLCache(certStores);
        X509Certificate rootCert = null;
        if (this.checkDELTACRLEnabled()) {
            this.useDeltas = true;
            useDeltas = true;
        }
        if (debug != null) {
            System.out.println("\nCERTPATH:  CRSChecker.java:  CRSChecker():  METHOD ENTRY");
            if (this.useDeltas) {
                System.out.println("useDeltas is set to 'true'");
            } else {
                System.out.println("useDeltas is set to 'false'");
            }
            if (this.checkCRLDPEnabled()) {
                System.out.println("checkCRLDPEnabled is set to 'true'");
                System.out.println("  This means that the method 'processDistributionPoints()' will be called.");
            } else {
                System.out.println("checkCRLDPEnabled is set to 'false'");
                System.out.println("  This means that the method 'processDistributionPoints()' will NOT be called.");
            }
        }
        if (this.numberOfCertsInCertPath > 0) {
            rootCert = (X509Certificate)certPathCerts.get(this.numberOfCertsInCertPath - 1);
        }
        if (rootCert != null) {
            this.trustAnchor = null;
            try {
                this.trustAnchor = CertPathUtil.findIssuer(rootCert, trustBaseSet, sigProvider);
            }
            catch (CertPathValidatorException e) {
                throw new CertPathValidatorException("The certificate issued by " + rootCert.getIssuerX500Principal().toString() + " is not trusted", (Throwable)e, certPath, this.numberOfCertsInCertPath - 1);
            }
        }
        if (debug != null) {
            System.out.println("CERTPATH:  CRSChecker.java:  CRSChecker():  METHOD EXIT\n");
        }
    }

    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("The direction of forward is not supported");
        }
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public void check(Certificate certificate, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        X509Certificate currentCert;
        block64: {
            Object cpvException = null;
            boolean[] reasonsMask = new boolean[]{false, false, false, false, false, false, false, false, false};
            if (debug != null) {
                System.out.println("\n");
                System.out.println("\nCERTPATH:  CRSChecker.java:  check():  METHOD ENTRY");
                System.out.println("\nCERTPATH:  CRSChecker.java:  check():  Check the revocation status of");
                System.out.println("                                       the input certificate.");
            }
            if ((currentCert = (X509Certificate)certificate).getIssuerX500Principal().equals(currentCert.getSubjectX500Principal())) {
                try {
                    this.trustAnchor = new TrustAnchor(currentCert, null);
                }
                catch (IllegalArgumentException e) {
                    throw new CertPathValidatorException("Fail to instantiate trust anchor for certificate revocation status processing", e, this.certPath, this.currentCertIndex, PKIXReason.NO_TRUST_ANCHOR);
                }
                --this.currentCertIndex;
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  check():  METHOD EXIT\n");
                    System.out.println("\n");
                }
                return;
            }
            boolean caCertificate = true;
            Object[] bcResult = CertPathUtil.getBasicConstraints(currentCert);
            caCertificate = (Boolean)bcResult[1];
            int certificateRevocationStatus = 2001;
            if (debug != null) {
                System.out.println("\nCERTPATH:  CRSChecker.java:  check():  Calling checkCRLCache() to learn whether the certificate's");
                System.out.println("                                       revocation status can be learned from the CRL's within the CRLCache.");
                System.out.println("                                       Below is the reasonsMask before any processing.                     ");
                this.printReasonsMask(reasonsMask);
            }
            certificateRevocationStatus = this.checkCRLCache(currentCert, this.trustAnchor, caCertificate, reasonsMask);
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning from checkCRLCache()");
                System.out.println("                                       certificateRevocationStatus = " + certificateRevocationStatus + "\n");
                System.out.println("CERTPATH:  CRSChecker.java:  check():  Upon return the reasonsMask is:");
                this.printReasonsMask(reasonsMask);
            }
            if (certificateRevocationStatus == 2001) {
                if (this.checkCRLDPEnabled()) {
                    DistributionPoint[] distributionPoints;
                    if (debug != null) {
                        System.out.println("\nCERTPATH:  CRSChecker.java:  check():  checkCRLCache() processing has been completed.     ");
                        System.out.println("                                       The cert's revocation status is still UNDETERMINED.  ");
                        System.out.println("                                       Now call processDistributionPoints() to process ");
                        System.out.println("                                       the distribution points within the certificate (if any). ");
                    }
                    if ((distributionPoints = CertPathUtil.getCRLDistributionPoints(currentCert)) != null) {
                        block63: {
                            try {
                                if (debug != null) {
                                    System.out.println("\nCERTPATH:  CRSChecker.java:  check():  Before calling processDistributionPoints() convert any         ");
                                    System.out.println("                                       distributionPoints that have RDN's for names into GeneralNames.  ");
                                    System.out.println("                                       processDistributionPoints() isn't expecting any RDN's.           ");
                                }
                                X500Principal x500PrincipalCertIssuer = currentCert.getIssuerX500Principal();
                                X500Name x500NameCertIssuer = new X500Name(x500PrincipalCertIssuer.getName());
                                if (debug != null) {
                                    System.out.println("\nCERTPATH:  CRSChecker.java:  check():  The X500Principal CertIssuer name is:  " + x500PrincipalCertIssuer.toString());
                                    System.out.println("CERTPATH:  CRSChecker.java:  check():  The X500Name      CertIssuer name is:  " + x500NameCertIssuer.toString() + "\n");
                                }
                                for (int jj = 0; jj < distributionPoints.length; ++jj) {
                                    DistributionPointName dpName = distributionPoints[jj].getName();
                                    ReasonFlags dpReasonFlags = distributionPoints[jj].getReasons();
                                    GeneralNames dpCRLIssuer = distributionPoints[jj].getIssuer();
                                    if (dpName == null) continue;
                                    if (debug != null) {
                                        System.out.println("CERTPATH:  CRSChecker.java:  check():  A DP name is present within this distributionPoint.  It is:");
                                        System.out.println(dpName.toString());
                                    }
                                    if (!(dpName instanceof GeneralNames)) {
                                        if (debug != null) {
                                            System.out.println("CERTPATH:  CRSChecker.java:  check():  This DP name is an RDN. ");
                                            System.out.println("                                       Convert it into a GeneralNames object using the RDN and the cert's issuer name/DN.\n");
                                        }
                                        RDN relativeDN = (RDN)dpName;
                                        GeneralNames newGeneralNames = this.getFullNames(x500NameCertIssuer, relativeDN);
                                        if (debug != null) {
                                            System.out.println("CERTPATH:  CRSChecker.java:  check():  The new GeneralNames object is:");
                                            System.out.println(newGeneralNames.toString());
                                        }
                                        distributionPoints[jj] = new DistributionPoint((DistributionPointName)newGeneralNames, dpReasonFlags, dpCRLIssuer);
                                        continue;
                                    }
                                    if (debug == null) continue;
                                    System.out.println("CERTPATH:  CRSChecker.java:  check():  This DP name is a GeneralNames. ");
                                    System.out.println("                                       It requires no conversion. ");
                                }
                            }
                            catch (Exception e) {
                                if (debug == null) break block63;
                                System.out.println("CERTPATH:  CRSChecker.java:  check():  The following exception was thrown while  ");
                                System.out.println("                                       trying to convert a distributionPoint name");
                                System.out.println("                                       from an RDN into a GeneralNames.          ");
                                e.printStackTrace();
                            }
                        }
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  check():  Calling processDistributionPoints()");
                            this.printReasonsMask(reasonsMask);
                        }
                        certificateRevocationStatus = this.processDistributionPoints(distributionPoints, currentCert, this.willBeTrustedCollection, this.certStores, this.useDeltas, this.trustBaseSet, caCertificate, this.validationDate, this.userReasons, this.sigProvider, reasonsMask);
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning from processDistributionPoints()");
                            System.out.println("                                       certificateRevocationStatus = " + certificateRevocationStatus + "\n");
                            this.printReasonsMask(reasonsMask);
                        }
                    } else {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  check():  There are no distribution points in this certificate to be processed.\n");
                        }
                        if (this.checkNULLCRLDPEnabled()) {
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  check():  -Dcom.ibm.security.enableNULLCRLDP=true");
                                System.out.println("                                       Reporting an \"UNREVOKED\" status for this certificate.");
                            }
                            certificateRevocationStatus = 2000;
                        }
                    }
                } else if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  check():  Skipping the call to processDistributionPoints() for the certificate being processed");
                    System.out.println("                                       because CRL distribution point extension processing is disabled. \n");
                }
            }
            String subject = currentCert.getSubjectX500Principal().toString();
            String expString = null;
            Enum reason = CertPathValidatorException.BasicReason.UNSPECIFIED;
            switch (certificateRevocationStatus) {
                case 1000: {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning REVOCATION_STATUS_UNSPECIFIED");
                    }
                    expString = "The certificate with subject (" + subject + ") has been revoked for an unspecified reason.";
                    break;
                }
                case 1001: {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning REVOCATION_STATUS_KEY_COMPROMISE");
                    }
                    expString = "The certificate with subject (" + subject + ") has been revoked because the key has been compromised.";
                    reason = PKIXReason.INVALID_KEY_USAGE;
                    break;
                }
                case 1002: {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning REVOCATION_STATUS_CA_COMPROMISE");
                    }
                    expString = "The certificate with subject (" + subject + ") has been revoked because the CA key has been compromised.";
                    reason = PKIXReason.INVALID_KEY_USAGE;
                    break;
                }
                case 1003: {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning REVOCATION_STATUS_AFFILIATION_CHANGED");
                    }
                    expString = "The certificate with subject (" + subject + ") has been revoked because the owner's affiliation has changed.";
                    break;
                }
                case 1004: {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning REVOCATION_STATUS_SUPERSEDED");
                    }
                    expString = "The certificate with subject (" + subject + ") has been revoked because it is superseded.";
                    break;
                }
                case 1005: {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning REVOCATION_STATUS_CESSATION_OF_OPERATION");
                    }
                    expString = "The certificate with subject (" + subject + ") has been revoked because of cessation of operation.";
                    break;
                }
                case 1006: {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning REVOCATION_STATUS_CERTIFICATE_HOLD");
                    }
                    expString = "The certificate with subject (" + subject + ") has been put on hold.";
                    break;
                }
                case 1009: {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning REVOCATION_STATUS_PRIVILEGE_WITHDRAWN");
                    }
                    expString = "The certificate with subject (" + subject + ") has been revoked because privilege withdrawn.";
                    break;
                }
                case 1010: {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning REVOCATION_STATUS_AA_COMPROMISE");
                    }
                    expString = "The certificate with subject (" + subject + ") has been revoked because of AA compromise.";
                    break;
                }
                case 2000: {
                    if (debug == null) break;
                    System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning REVOCATION_STATUS_UNREVOKED");
                    break;
                }
                case 2001: {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning REVOCATION_STATUS_UNDETERMINED");
                    }
                    expString = "The revocation status of the certificate with subject (" + subject + ") could not be determined.";
                    reason = CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS;
                    break;
                }
                case 2002: {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  check():  Returning REVOCATION_STATUS_REVOKED_NOREASONS");
                    }
                    expString = "The certificate with subject (" + subject + ") has been revoked, revocation reason unknown.";
                    reason = CertPathValidatorException.BasicReason.REVOKED;
                    break;
                }
                default: {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  check():  An internal error occurred while processing the certificate.");
                    }
                    expString = "An internal error has occurred in processing the certificate:" + certificateRevocationStatus;
                }
            }
            try {
                this.trustAnchor = new TrustAnchor(currentCert, null);
                if (expString == null) break block64;
                if (!CertPathSystemProperties.getOnlyEECert()) {
                    if (debug != null) {
                        System.out.println("CERTPATH: CRSChecker.java:  check():  Throwing revocation exception for the cert below.");
                        System.out.println("                                      System property onlyCheckEECerts==false.");
                        System.out.println(currentCert.toString());
                    }
                    throw new CertPathValidatorException(expString, null, this.certPath, this.currentCertIndex, (CertPathValidatorException.Reason)((Object)reason));
                }
                Object[] basicConstraintsResult = CertPathUtil.getBasicConstraints(currentCert);
                boolean isCACertificate = (Boolean)basicConstraintsResult[1];
                if (isCACertificate) {
                    if (debug != null) {
                        System.out.println("CERTPATH: CRSChecker.java:  check():  Not throwing revocation exception for the CA cert below.");
                        System.out.println("                                      System property onlyCheckEECerts==true.");
                        System.out.println(currentCert.toString());
                    }
                    break block64;
                }
                if (debug != null) {
                    System.out.println("CERTPATH: CRSChecker.java:  check():  Throwing revocation exception for the non-CA cert below.");
                    System.out.println("                                      System property onlyCheckEECerts==true.");
                    System.out.println(currentCert.toString());
                }
                throw new CertPathValidatorException(expString, null, this.certPath, this.currentCertIndex, (CertPathValidatorException.Reason)((Object)reason));
            }
            catch (IllegalArgumentException e) {
                throw new CertPathValidatorException("Fail to instantiate trust anchor for certificate revocation status processing", e, this.certPath, this.currentCertIndex, PKIXReason.NO_TRUST_ANCHOR);
            }
        }
        --this.currentCertIndex;
        if (this.trustCertPathForCRLs) {
            this.willBeTrustedCollection.add(currentCert);
        }
        if (debug != null) {
            System.out.println("\nCERTPATH:  CRSChecker.java:  check():  METHOD EXIT\n");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int checkCRLCache(X509Certificate cert, TrustAnchor anchor, boolean caCertificate, boolean[] reasonsMask) throws CertPathValidatorException {
        int result;
        block88: {
            ArrayList list;
            BigInteger serialNum;
            PublicKey key;
            X500Principal issuer;
            block87: {
                issuer = null;
                key = null;
                X509Certificate trustedCert = null;
                if (debug != null) {
                    System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  METHOD ENTRY");
                    System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  The input cert is:                     ");
                    System.out.println(cert.toString());
                    System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  The input TrustAnchor cert (signer of the input cert) is: ");
                    System.out.println(anchor.getTrustedCert().toString());
                }
                this.certificateHoldEncounteredForThisCert = false;
                this.certificateRemoveEncounteredForThisCert = false;
                boolean[] keyUsage = CertPathUtil.getKeyUsage(cert);
                if (this.currentCertIndex != 0 && caCertificate && keyUsage != null && !keyUsage[6]) {
                    if (debug == null) return 2001;
                    System.out.println("CERTPATH: This certificate is not for CRL signing, serial number=" + cert.getSerialNumber());
                    return 2001;
                }
                trustedCert = anchor.getTrustedCert();
                if (trustedCert != null) {
                    if (!(trustedCert instanceof X509CertImpl)) {
                        try {
                            trustedCert = new X509CertImpl(trustedCert.getEncoded());
                        }
                        catch (CertificateException ex) {
                            throw new CertPathValidatorException(ex.getMessage());
                        }
                    }
                    issuer = trustedCert.getSubjectX500Principal();
                    key = trustedCert.getPublicKey();
                } else {
                    issuer = anchor.getCA();
                    key = anchor.getCAPublicKey();
                }
                serialNum = cert.getSerialNumber();
                list = null;
                result = 2001;
                list = this.getCRLCache(issuer);
                if (list != null) break block87;
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  NO CRL's found that were issued by the TrustAnchor.  Issuer name = " + issuer);
                    System.out.println("                                               Returning a revocation status = 'UNDETERMINED'");
                }
                break block88;
            }
            ArrayList tempDeltaCRLArrayList = new ArrayList(10);
            ArrayList tempCompleteCRLArrayList = new ArrayList(10);
            if (debug != null) {
                System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  Sort the list of CRL's found for this issuer.");
                System.out.println("                                               There are " + list.size() + "CRL's in this list.");
            }
            for (X509CRL tempCRL : list) {
                if (CompositeCRL.isDeltaCRL(tempCRL)) {
                    if (!this.useDeltas) continue;
                    this.addCRLToSortedList(tempDeltaCRLArrayList, tempCRL);
                    continue;
                }
                this.addCRLToSortedList(tempCompleteCRLArrayList, tempCRL);
            }
            list.clear();
            list.addAll(tempDeltaCRLArrayList);
            list.addAll(tempCompleteCRLArrayList);
            if (debug != null) {
                System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  SIZE OF THE SORTED CRL LIST = " + list.size());
                System.out.println("                                               All deltaCRL's will precede all completeCRL's.");
            }
            if (debug != null) {
                System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  Begin examining all of the CRL's issued by this Issuer.");
                System.out.println("                                               Issuer name = " + issuer);
            }
            for (X509CRL crl : list) {
                X509CRLEntryImpl completeCRLEntry;
                X509CRLEntryImpl deltaCRLEntry;
                block91: {
                    block90: {
                        X509CRL completeCRLCandidate;
                        boolean verifyResult;
                        block89: {
                            Iterator iter;
                            boolean matchingCompleteCRLFound;
                            block86: {
                                if (debug != null) {
                                    System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  Get the next CRL to be checked from CRLCache for this issuer. ");
                                    System.out.println("                                               Issuer name = " + issuer + "\n");
                                }
                                verifyResult = false;
                                completeCRLCandidate = null;
                                if (CompositeCRL.isDeltaCRL(crl)) {
                                    if (this.useDeltas) {
                                        if (debug != null) {
                                            System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache(): The crl to be verified is a delta CRL.");
                                            System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  Try to find a candidate completeCRL that matches this deltaCRL.");
                                            System.out.println("                                               If one is found invoke verifyCRL().\n");
                                        }
                                        matchingCompleteCRLFound = false;
                                        iter = tempCompleteCRLArrayList.iterator();
                                        break block86;
                                    } else {
                                        if (debug == null) continue;
                                        System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  This deltaCRL is being skipped.");
                                        System.out.println("                                               useDeltas is set to 'false'.   ");
                                        continue;
                                    }
                                }
                                if (debug != null) {
                                    System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The crl to be verified is a completeCRL.");
                                    System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  Calling verifyCRL1() to verify this completeCRL.");
                                }
                                if (verifyResult = this.verifyCRL(cert, crl, null, key, reasonsMask)) {
                                    if (debug != null) {
                                        System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The lone completeCRL was SUCCESSFULLY VERIFIED.  verifyCRL() returned 'true'.");
                                    }
                                    break block89;
                                } else if (debug != null) {
                                    System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The lone completeCRL was NOT SUCCESSFULLY VERIFIED.  verifyCRL() returned 'false'.");
                                }
                                break block89;
                            }
                            while (iter.hasNext()) {
                                verifyResult = false;
                                completeCRLCandidate = (X509CRL)iter.next();
                                if (CompositeCRL.isDeltaCRL(completeCRLCandidate)) continue;
                                if (debug != null) {
                                    System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache(): Found a completeCRL candidate for the deltaCRL to be verified.");
                                    System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache(): Calling verifyCRL1() to verify the deltaCRL/completeCRL pair.");
                                }
                                if (verifyResult = this.verifyCRL(cert, completeCRLCandidate, crl, key, reasonsMask)) {
                                    if (debug != null) {
                                        System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The deltaCRL/completeCRL pair was SUCCESSFULLY VERIFIED.  verifyCRL returned 'true'.");
                                    }
                                    matchingCompleteCRLFound = true;
                                    break;
                                }
                                if (debug == null) continue;
                                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The deltaCRL/completeCRL pair was NOT SUCCESSFULLY VERIFIED.  verifyCRL returned 'false'.");
                                System.out.println("                                               Try to find another candidate completeCRL.");
                            }
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  End of search for matching complete CRL.");
                                if (matchingCompleteCRLFound) {
                                    System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  A matching completeCRL was found.\n");
                                } else {
                                    System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  A matching completeCRL was NOT found.\n");
                                }
                            }
                        }
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The CRL verification process is complete.");
                        }
                        if (verifyResult) {
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  verifyCRL() returned 'true'.");
                                System.out.println("                                               Either a lone completeCRL or a");
                                System.out.println("                                               completeCRL/deltaCRL pair was successfully verified.");
                            }
                        } else {
                            if (debug == null) continue;
                            System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  verifyCRL() returned 'false'.");
                            System.out.println("                                               Skip this CRL and go to the next.");
                            System.out.println("                                               (If the CRL being processed from the list was a deltaCRL, then  ");
                            System.out.println("                                               this failure might mean that no matching completeCRL could be found.\n");
                            continue;
                        }
                        if (debug != null) {
                            System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  Determine whether this 'verified completeCRL OR ");
                            System.out.println("                                               'completeCRL/deltaCRL pair' revokes the certificate.");
                        }
                        deltaCRLEntry = null;
                        completeCRLEntry = null;
                        if (!CompositeCRL.isDeltaCRL(crl)) break block90;
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The CRL that was verified was a deltaCRL/completeCRL pair.");
                        }
                        if ((deltaCRLEntry = (X509CRLEntryImpl)crl.getRevokedCertificate(serialNum)) == null) {
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  No entry found for this cert in the deltaCRL.");
                            }
                        } else if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The deltaCRL contains an entry for this cert.");
                        }
                        if ((completeCRLEntry = (X509CRLEntryImpl)completeCRLCandidate.getRevokedCertificate(serialNum)) == null) {
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  No entry found for this cert in the completeCRL.");
                            }
                            break block91;
                        } else if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The completeCRL contains an entry for this cert.");
                        }
                        break block91;
                    }
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The CRL that was verified was a completeCRL.");
                        System.out.println("                                               Not a deltaCRL/completeCRL pair.            ");
                    }
                    if ((completeCRLEntry = (X509CRLEntryImpl)crl.getRevokedCertificate(serialNum)) == null) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  No entry found for this cert in the completeCRL.");
                        }
                    } else if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The completeCRL contains an entry for this cert.");
                    }
                }
                int completeCRLResult = 0;
                if (completeCRLEntry != null) {
                    byte[] value1;
                    if (debug != null) {
                        System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  The completeCRL entry is:");
                        System.out.println(completeCRLEntry.toString());
                    }
                    if ((value1 = completeCRLEntry.getExtensionValue("2.5.29.21")) != null) {
                        try {
                            DerValue derValue1 = new DerValue(value1);
                            value1 = derValue1.getOctetString();
                            CRLReasonCodeExtension ext1 = new CRLReasonCodeExtension(Boolean.FALSE, (Object)value1);
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The CRLReasonCodeExtension is:");
                                System.out.println(ext1.toString());
                                System.out.println();
                            }
                            int reason1 = (Integer)ext1.get("reason");
                            completeCRLResult = 1000 + reason1;
                        }
                        catch (IOException e) {
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  An Exception was thrown while trying to obtain the CRLReasonCodeExtension from the completeCRL entry.");
                                System.out.println("                                               Setting the completeCRLResult = CERTIFICATE_REVOCATION_STATUS_REVOKED_NOREASONS");
                                e.printStackTrace();
                            }
                            completeCRLResult = 2002;
                        }
                    } else {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The completeCRL Entry's 'Reason Code extension' is null.");
                            System.out.println("                                               Setting the completeCRLResult = CERTIFICATE_REVOCATION_STATUS_REVOKED_NOREASONS");
                        }
                        completeCRLResult = 2002;
                    }
                }
                int deltaCRLResult = 0;
                if (deltaCRLEntry != null) {
                    byte[] value2;
                    if (debug != null) {
                        System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  The deltaCRL entry is:");
                        System.out.println(deltaCRLEntry.toString());
                    }
                    if ((value2 = deltaCRLEntry.getExtensionValue("2.5.29.21")) != null) {
                        try {
                            DerValue derValue2 = new DerValue(value2);
                            value2 = derValue2.getOctetString();
                            CRLReasonCodeExtension ext2 = new CRLReasonCodeExtension(Boolean.FALSE, (Object)value2);
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The CRLReasonCodeExtension is:");
                                System.out.println(ext2.toString());
                                System.out.println();
                            }
                            int reason2 = (Integer)ext2.get("reason");
                            deltaCRLResult = 1000 + reason2;
                        }
                        catch (IOException e) {
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  An Exception was thrown while trying to obtain the CRLReasonCodeExtension from the deltaCRL entry.");
                                System.out.println("                                               Setting the deltaCRLResult = CERTIFICATE_REVOCATION_STATUS_REVOKED_NOREASONS");
                                e.printStackTrace();
                            }
                            deltaCRLResult = 2002;
                        }
                    } else {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The deltaCRL Entry's 'Reason Code extension' is null.");
                            System.out.println("                                               Setting the deltaCRLResult = CERTIFICATE_REVOCATION_STATUS_REVOKED_NOREASONS");
                        }
                        deltaCRLResult = 2002;
                    }
                }
                if (debug != null) {
                    System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  The completeCRLResult is = " + completeCRLResult);
                    System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The deltaCRLResult is    = " + deltaCRLResult);
                }
                block3 : switch (completeCRLResult) {
                    case 0: {
                        switch (deltaCRLResult) {
                            case 0: {
                                break block3;
                            }
                            case 1008: {
                                break block3;
                            }
                        }
                        if (debug == null) return deltaCRLResult;
                        System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  Returning the revocation reason from the deltaCRL = " + deltaCRLResult);
                        return deltaCRLResult;
                    }
                    case 1008: {
                        switch (deltaCRLResult) {
                            case 0: {
                                break block3;
                            }
                            case 1008: {
                                break block3;
                            }
                        }
                        if (debug == null) return deltaCRLResult;
                        System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  Returning the revocation reason from the deltaCRL = " + deltaCRLResult);
                        return deltaCRLResult;
                    }
                    default: {
                        switch (deltaCRLResult) {
                            case 0: {
                                if (debug == null) return completeCRLResult;
                                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  Returning the revocation reason from the completeCRL = " + completeCRLResult);
                                return completeCRLResult;
                            }
                            case 1008: {
                                break block3;
                            }
                        }
                        if (debug == null) return deltaCRLResult;
                        System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  Returning the revocation reason from the deltaCRL = " + deltaCRLResult);
                        return deltaCRLResult;
                    }
                }
                if (Arrays.equals(reasonsMask, ALL_REASONS)) {
                    if (debug == null) return 2000;
                    System.out.println("\nCERTPATH:  CRSChecker.java:  checkCRLCache():  The reasonsMask now contains ALL_REASONS. ");
                    System.out.println("                                               Abort the CRL search.                     ");
                    System.out.println("                                               Returning a revocation status of UNREVOKED.");
                    this.printReasonsMask(reasonsMask);
                    return 2000;
                }
                if (debug == null) continue;
                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  The reasonsMask DOESN'T contain ALL_REASONS. ");
                System.out.println("                                               Continue with the CRL search.                ");
                this.printReasonsMask(reasonsMask);
            }
        }
        if (debug == null) return result;
        System.out.println("CERTPATH:  CRSChecker.java:  checkCRLCache():  METHOD EXIT\n");
        return result;
    }

    ArrayList getCRLCache(X500Principal issuer) {
        ArrayList list = null;
        list = (ArrayList)this.CRLCache.get(issuer);
        if (list == null) {
            Enumeration keys = this.CRLCache.keys();
            while (keys.hasMoreElements()) {
                X500Principal name = (X500Principal)keys.nextElement();
                if (!name.equals(issuer)) continue;
                list = (ArrayList)this.CRLCache.get(name);
                break;
            }
        }
        if (debug != null) {
            if (list == null) {
                System.out.println("CERTPATH: Inside memory cache, cannot find crl with issuer " + issuer.getName());
            } else {
                System.out.println("CERTPATH: Found at least one CRL with issuer " + issuer.getName() + " in memory cache");
            }
        }
        return list;
    }

    int processDistributionPoints(DistributionPoint[] distributionPoints, X509Certificate cert, Collection willBeTrustedCollection, Collection certStores, boolean useDeltas, Collection trustBaseSet, boolean caCertificate, Date validationDate, boolean[] userReasons, String sigProvider, boolean[] reasonsMask) throws CertPathValidatorException {
        CompositeCRL compCRL = null;
        Object interimReasonMask = null;
        boolean[] dpReasons = null;
        int certificateRevocationStatus = 2000;
        boolean allreasons = false;
        if (debug != null) {
            System.out.println("\n");
            System.out.println("\nCERTPATH:  CRSChecker.java:  processDistributionPoints():  METHOD ENTRY");
            System.out.println("The number of distributionPoints is " + distributionPoints.length);
            System.out.println("\ndistributionPoints[0] is:");
            System.out.println("\n" + distributionPoints[0].toString());
            System.out.println("\nThe input cert is:");
            System.out.println("\n" + cert.toString());
            System.out.println("\nIS THE CERT A CA CERT?  ANSWER= " + caCertificate);
            System.out.println("The reasonsMask on input is:");
            this.printReasonsMask(reasonsMask);
        }
        for (int i = 0; i < distributionPoints.length; ++i) {
            try {
                ReasonFlags rf = distributionPoints[i].getReasons();
                if (rf == null) {
                    dpReasons = null;
                } else {
                    BitArray baRF = rf.getReasonFlags();
                    dpReasons = baRF.toBooleanArray();
                }
            }
            catch (IOException e) {
                if (debug != null) {
                    System.out.println("CERTPATH: Exception in processing distribution points" + e.toString());
                }
                throw new CertPathValidatorException("An internal error has occurred in processing the certificate.", e);
            }
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  Calling getCompositeCRLFromDP().");
            }
            compCRL = this.getCompositeCRLFromDP(distributionPoints[i], cert, willBeTrustedCollection, certStores, useDeltas, trustBaseSet, caCertificate, validationDate, dpReasons, sigProvider);
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  Returned from getCompositeCRLFromDP().");
            }
            if (compCRL == null) {
                if (debug == null) continue;
                System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  NO compositeCRL was found. ");
                continue;
            }
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  The following compositeCRL was found: ");
                System.out.println(compCRL.toString());
            }
            try {
                X509CRL completeCRL = compCRL.getBaseCRL();
                X509CRL deltaCRL = compCRL.getDeltaCRL();
                boolean verifyStatus = false;
                PublicKey signersKey = compCRL.getIssuerCertificate().getPublicKey();
                if (deltaCRL != null) {
                    if (completeCRL != null) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  The compositeCRL contains both a completeCRL and a deltaCRL.");
                            System.out.println("                                                           Calling verifyCRL().");
                        }
                        verifyStatus = this.verifyCRL(cert, distributionPoints[i], completeCRL, deltaCRL, signersKey, reasonsMask);
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  verifyCRL() returned " + verifyStatus);
                        }
                    } else {
                        verifyStatus = false;
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  The compositeCRL contains a null completeCRL and a non-null deltaCRL.  Is this an error?");
                            System.out.println("                                                           A verifyCRL() call is unnecessary.");
                            System.out.println("                                                           verifyStatus = false");
                        }
                    }
                } else if (completeCRL != null) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  The compositeCRL contains a completeCRL and a null deltaCRL.");
                        System.out.println("                                                           Calling verifyCRL().");
                    }
                    verifyStatus = this.verifyCRL(cert, distributionPoints[i], completeCRL, null, signersKey, reasonsMask);
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  verifyCRL() returned " + verifyStatus);
                    }
                } else {
                    verifyStatus = false;
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  Found a compositeCRL with a null completeCRL and a null deltaCRL.  Is this an error?");
                        System.out.println("                                                           A verifyCRL() call is unnecessary.");
                        System.out.println("                                                           verifyStatus = false");
                    }
                }
                if (!verifyStatus) {
                    if (debug == null) continue;
                    System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  The compositeCRL associated with this distribution point failed to verify.  Skip it and go to the next.");
                    System.out.println("                                                           Skip it and go get the compositeCRL associated with the next distribution point.");
                    continue;
                }
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  Retrieve the certificate revocation status from the compositeCRL");
                }
                if ((certificateRevocationStatus = compCRL.getStatus(cert.getSerialNumber(), validationDate)) != 2000 && certificateRevocationStatus != 2001) break;
                continue;
            }
            catch (IOException e) {
                if (debug == null) continue;
                System.out.println("CERTPATH: Error occurs when processing distribution points " + e.toString());
            }
        }
        if (debug != null) {
            System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  There are no more distribution points to process.");
        }
        if (certificateRevocationStatus == 2000 && !Arrays.equals(reasonsMask, ALL_REASONS)) {
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  Not all reasons are present in the reasonsMask.");
                System.out.println("                                                           Setting   REVOCATION_STATUS_UNDETERMINED.      ");
            }
            certificateRevocationStatus = 2001;
        }
        if (debug != null) {
            if (certificateRevocationStatus == 2000) {
                System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  THE CERTIFICATE REVOCATION STATUS IS 'UNREVOKED'.");
            } else if (certificateRevocationStatus == 2001) {
                System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  THE CERTIFICATE REVOCATION STATUS IS STILL 'UNDETERMINED'.");
            } else {
                System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  THE CERTIFICATE IS REVOKED WITH THE FOLLOWING REVOCATION STATUS = " + certificateRevocationStatus);
                System.out.println("\n");
            }
            System.out.println("The reasonsMask before return is:");
            this.printReasonsMask(reasonsMask);
            System.out.println("CERTPATH:  CRSChecker.java:  processDistributionPoints():  METHOD EXIT\n");
        }
        return certificateRevocationStatus;
    }

    CompositeCRL getCompositeCRLFromDP(DistributionPoint distributionPoint, X509Certificate cert, Collection willBeTrustedCollection, Collection certStores, boolean useDeltas, Collection trustBaseSet, boolean caCertificate, Date validationDate, boolean[] reasons, String sigProvider) throws CertPathValidatorException {
        CompositeCRL compCRL = null;
        GeneralNames issGNs = null;
        if (debug != null) {
            System.out.println("CERTPATH:  CRSChecker.java:  getCompositeCRLfromDP():  The distribution point received is: ");
            System.out.println(distributionPoint.toString());
        }
        try {
            issGNs = distributionPoint.getIssuer();
        }
        catch (IOException e) {
        }
        catch (GeneralNamesException e) {
            // empty catch block
        }
        Principal crlIssuer = CertPathUtil.findDNCRLIssuer(issGNs);
        if (crlIssuer == null) {
            crlIssuer = cert.getIssuerDN();
        }
        GeneralName name = null;
        try {
            GeneralNames dpName = (GeneralNames)distributionPoint.getName();
            name = CertPathUtil.getSupportedNameObjectFromGeneralNames(dpName);
        }
        catch (IOException e) {
        }
        catch (GeneralNamesException e) {
            // empty catch block
        }
        if (name != null) {
            if (name.getType() == 6) {
                boolean trusted;
                String uriNameString = CertPathUtil.stripJunk(name.toString());
                if (debug != null) {
                    System.out.println("CERTPATH: Get a URI from distribution point: " + uriNameString);
                }
                if ((compCRL = this.getCompositeCRLByDPName(uriNameString, crlIssuer, certStores, useDeltas, willBeTrustedCollection, trustBaseSet, caCertificate, validationDate, sigProvider)) != null && !(trusted = this.isIssuerTrusted(compCRL.getIssuerCertificate(), willBeTrustedCollection, trustBaseSet, sigProvider))) {
                    compCRL = null;
                }
            } else if (name.getType() == 4) {
                String dnName = name.toString();
                compCRL = this.getCompositeCRLByIssuerName(dnName, validationDate, certStores, reasons, false, caCertificate, willBeTrustedCollection, trustBaseSet, useDeltas, sigProvider);
            }
        }
        return compCRL;
    }

    CompositeCRL getCompositeCRLByDPName(String dpName, Principal crlIssuer, Collection certStores, boolean useDeltas, Collection willBeTrustedCollection, Collection trustBaseSet, boolean caCertificate, Date validationDate, String sigProvider) throws CertPathValidatorException {
        Hashtable hashtableCompositeCRLs = null;
        hashtableCompositeCRLs = caCertificate ? CompositeCRL.CAcompositeCRLHashtable : CompositeCRL.EEcompositeCRLHashtable;
        String hashKey = dpName;
        CompositeCRL compCRL = (CompositeCRL)hashtableCompositeCRLs.get(hashKey);
        CompositeCRL[] newComposites = null;
        URLConnection conn = null;
        long lastModified = -1L;
        boolean connected = false;
        if (CertPathUtil.isHTTPURI(dpName) || CertPathUtil.isFTPURI(dpName)) {
            block50: {
                try {
                    URL url = new URL(dpName);
                    conn = url.openConnection();
                    lastModified = conn.getLastModified();
                    conn.setConnectTimeout(CertPathSystemProperties.getCRLSConnectTimeout());
                    connected = true;
                }
                catch (MalformedURLException ex) {
                    if (debug != null) {
                        System.out.println("CERTPATH: exception thrown when trying to connect to " + dpName + ":" + ex.toString());
                    }
                }
                catch (IOException ex) {
                    if (debug == null) break block50;
                    System.out.println("CERTPATH: exception thrown when trying to connect to " + dpName + ":" + ex.toString());
                }
            }
            if (compCRL != null) {
                if (debug != null) {
                    System.out.println("CERTPATH: found a comp crl in the cache");
                }
                if (connected && System.currentTimeMillis() - compCRL.getModifiedTime() > 600000L) {
                    X509CRL crl;
                    if (debug != null) {
                        System.out.println("CERTPATH: reuse the crl in cache within interval time");
                    }
                    int result = 0;
                    if (debug != null) {
                        System.out.println("CERTPATH: current lastModified=" + lastModified + ", last lastModified=" + compCRL.getModifiedTime());
                        System.out.println("CERTPATH: refresh it");
                    }
                    if ((crl = this.getCRLWithUrl(conn)) != null) {
                        result = compCRL.update(crl, validationDate, sigProvider, lastModified);
                    }
                    if (result != 1003) {
                        compCRL = null;
                    }
                    if (compCRL != null && caCertificate) {
                        compCRL.setModifiedTime(System.currentTimeMillis());
                        if (CompositeCRL.CAcompositeCRLHashtable.containsKey(hashKey)) {
                            CompositeCRL.CAcompositeCRLHashtable.remove(hashKey);
                        }
                        CompositeCRL.CAcompositeCRLHashtable.put(hashKey, compCRL);
                    }
                    if (compCRL != null && !caCertificate) {
                        compCRL.setModifiedTime(System.currentTimeMillis());
                        if (CompositeCRL.EEcompositeCRLHashtable.containsKey(hashKey)) {
                            CompositeCRL.EEcompositeCRLHashtable.remove(hashKey);
                        }
                        CompositeCRL.EEcompositeCRLHashtable.put(hashKey, compCRL);
                    }
                } else if (compCRL.getNextUpdate().getTime() < validationDate.getTime()) {
                    compCRL = null;
                }
            } else if (connected) {
                newComposites = new CompositeCRL[2];
                X509CRL crl = this.getCRLWithUrl(conn);
                if (crl != null) {
                    compCRL = new CompositeCRL(null);
                    compCRL.update(crl);
                    if (debug != null) {
                        System.out.println("CERTPATH: Set lastmodified=" + lastModified);
                    }
                    compCRL.setModifiedTime(lastModified);
                    X509Certificate issuerCert = null;
                    try {
                        issuerCert = CertPathUtil.findIssuerOfCRL(crl, willBeTrustedCollection, trustBaseSet, certStores, sigProvider);
                    }
                    catch (CertificateNotYetValidException e) {
                        issuerCert = null;
                    }
                    if (issuerCert == null) {
                        compCRL = null;
                    } else {
                        compCRL.setIssuerCertificate(issuerCert);
                        boolean isTrusted = this.isIssuerTrusted(issuerCert, willBeTrustedCollection, trustBaseSet, sigProvider);
                        if (isTrusted) {
                            newComposites[0] = compCRL;
                            newComposites[1] = compCRL;
                        }
                    }
                }
                if (newComposites[0] != null && caCertificate) {
                    newComposites[0].setModifiedTime(System.currentTimeMillis());
                    CompositeCRL.CAcompositeCRLHashtable.put(hashKey, newComposites[0]);
                }
                if (newComposites[1] != null && !caCertificate) {
                    newComposites[1].setModifiedTime(System.currentTimeMillis());
                    CompositeCRL.EEcompositeCRLHashtable.put(hashKey, newComposites[1]);
                }
                if (caCertificate) {
                    compCRL = newComposites[0];
                } else if (!caCertificate) {
                    compCRL = newComposites[1];
                }
            }
        } else if (CertPathUtil.isLDAPURI(dpName)) {
            long currenttime = System.currentTimeMillis();
            if (compCRL != null) {
                if (currenttime - compCRL.getModifiedTime() < 600000L) {
                    if (debug != null) {
                        System.out.println("CERTPATH: reuse the crl in cache within interval time");
                    }
                } else {
                    compCRL = null;
                }
            }
            if (compCRL == null) {
                if (debug != null) {
                    System.out.println("CERTPATH: fetch a crl from LDAP");
                }
                if ((newComposites = this.createCompositeCRLWithDPName(dpName, willBeTrustedCollection, certStores, sigProvider))[0] != null) {
                    if (caCertificate) {
                        if (CompositeCRL.CAcompositeCRLHashtable.containsKey(hashKey)) {
                            CompositeCRL.CAcompositeCRLHashtable.remove(hashKey);
                        }
                        CompositeCRL.CAcompositeCRLHashtable.put(hashKey, newComposites[0]);
                    } else {
                        if (CompositeCRL.EEcompositeCRLHashtable.containsKey(hashKey)) {
                            CompositeCRL.EEcompositeCRLHashtable.remove(hashKey);
                        }
                        CompositeCRL.EEcompositeCRLHashtable.put(hashKey, newComposites[0]);
                    }
                    compCRL = newComposites[0];
                    compCRL.setModifiedTime(currenttime);
                }
                if (newComposites[1] != null) {
                    if (caCertificate) {
                        if (CompositeCRL.CAcompositeCRLHashtable.containsKey(hashKey)) {
                            CompositeCRL.CAcompositeCRLHashtable.remove(hashKey);
                        }
                        CompositeCRL.CAcompositeCRLHashtable.put(hashKey, newComposites[1]);
                    } else {
                        if (CompositeCRL.EEcompositeCRLHashtable.containsKey(hashKey)) {
                            CompositeCRL.EEcompositeCRLHashtable.remove(hashKey);
                        }
                        CompositeCRL.EEcompositeCRLHashtable.put(hashKey, newComposites[1]);
                    }
                    compCRL = newComposites[1];
                    compCRL.setModifiedTime(currenttime);
                }
            }
        }
        return compCRL;
    }

    CompositeCRL[] createCompositeCRLWithDPName(String dpName, Collection willBeTrustedCollection, Collection certStores, String sigProvider) throws CertPathValidatorException {
        DirContext ctx;
        CompositeCRL[] compCRLs = new CompositeCRL[2];
        String[] stringAndName = this.getLDAPURLAndDN(dpName);
        if (stringAndName[0] != null & stringAndName[1] != null && (ctx = CertPathUtil.getDirContext(stringAndName[0])) != null) {
            X509CRLImpl[] getResults = CertPathUtil.retrieveCRLs(ctx, stringAndName[1], allCRLAttrIDArray);
            X509CRLImpl arl = getResults[0];
            X509Certificate caCert = null;
            CompositeCRL compARL = this.createOneCompositeCRL(stringAndName[1], willBeTrustedCollection, certStores, arl, caCert, sigProvider);
            X509CRLImpl crl = getResults[1];
            CompositeCRL compCRL = this.createOneCompositeCRL(stringAndName[1], willBeTrustedCollection, certStores, crl, caCert, sigProvider);
            compCRLs[0] = compARL;
            compCRLs[1] = compCRL;
            if (getResults[2] != null && compCRLs[1] != null) {
                compCRLs[1].refresh((X509CRL)getResults[2]);
            }
        }
        return compCRLs;
    }

    X509CRL getCRLWithUrl(URLConnection conn) {
        X509CRL crl;
        block6: {
            crl = null;
            try {
                CertificateFactoryImpl cf = new CertificateFactoryImpl();
                InputStream is = conn.getInputStream();
                crl = (X509CRL)cf.engineGenerateCRL(is);
            }
            catch (MalformedURLException e) {
                if (debug != null) {
                    System.out.println("CERTPATH: Failed to retrieve CRL from " + conn.getURL());
                    e.printStackTrace();
                }
            }
            catch (CRLException e) {
                if (debug != null) {
                    System.out.println("CERTPATH: Failed to retrieve CRL from " + conn.getURL());
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (debug == null) break block6;
                System.out.println("CERTPATH: Failed to retrieve CRL from " + conn.getURL());
                e.printStackTrace();
            }
        }
        return crl;
    }

    CompositeCRL createOneCompositeCRL(String name, Collection willBeTrustedCollection, Collection certStores, X509CRLImpl crl, X509Certificate issuer, String sigProvider) throws CertPathValidatorException {
        X509Certificate crlIssuer = null;
        CompositeCRL newCompCRL = null;
        if (crl != null) {
            if (debug != null) {
                System.out.println("CERTPATH: CRSChecker.createOneCompositeCRL crl found");
            }
            if (issuer != null) {
                int result;
                if (!(issuer instanceof X509CertImpl)) {
                    try {
                        issuer = new X509CertImpl(issuer.getEncoded());
                    }
                    catch (CertificateException ex) {
                        throw new CertPathValidatorException(ex.getMessage());
                    }
                }
                try {
                    result = CertPathUtil.verifyCRLIssuer((X509CRL)crl, issuer.getPublicKey(), issuer.getIssuerX500Principal(), sigProvider);
                }
                catch (CertificateNotYetValidException e) {
                    result = Integer.MAX_VALUE;
                }
                if (result == 0) {
                    crlIssuer = issuer;
                }
            }
            if (crlIssuer == null) {
                if (debug != null) {
                    System.out.println("CERTPATH: crl issuer null");
                }
                try {
                    crlIssuer = CertPathUtil.findIssuerOfCRL((X509CRL)crl, willBeTrustedCollection, this.trustBaseSet, certStores, sigProvider);
                }
                catch (CertificateNotYetValidException e) {
                    if (debug != null) {
                        System.out.println("CERTPATH: CRSChecker.createOneCompositeCRL" + e.getMessage());
                    }
                    crlIssuer = null;
                }
            }
            if (crlIssuer != null) {
                if (debug != null) {
                    System.out.println("CERTPATH: componsiteCRL is created");
                }
                newCompCRL = new CompositeCRL(name);
                newCompCRL.update((X509CRL)crl);
                newCompCRL.setIssuerCertificate(crlIssuer);
            }
        }
        return newCompCRL;
    }

    int updateCompositeCRL(String dpName, CompositeCRL compCRL, boolean useDeltas, boolean caCertificate, Date validationDate, String sigProvider) throws CertPathValidatorException {
        int result = 0;
        String[] stringAndName = this.getLDAPURLAndDN(dpName);
        if (stringAndName[0] != null & stringAndName[1] != null) {
            DirContext ctx = CertPathUtil.getDirContext(stringAndName[0]);
            if (caCertificate) {
                result = this.retrieveBaseCRL(compCRL, ctx, stringAndName[1], baseARLAttrIDArray, validationDate, sigProvider);
            } else if (!caCertificate) {
                if (useDeltas) {
                    result = this.retrieveDeltaCRL(compCRL, ctx, stringAndName[1], deltaCRLAttrIDArray, validationDate, sigProvider);
                    if (result != 1001 && result != 1001) {
                        result = this.retrieveBaseCRL(compCRL, ctx, stringAndName[1], baseCRLAttrIDArray, validationDate, sigProvider);
                    }
                } else {
                    result = this.retrieveBaseCRL(compCRL, ctx, stringAndName[1], baseCRLAttrIDArray, validationDate, sigProvider);
                }
            }
        }
        return result;
    }

    CompositeCRL getCompositeCRLByIssuerName(String issuerDN, Date validationDate, Collection certStores, boolean[] reasons, boolean allReasons, boolean caCertificate, Collection willBeTrustedCollection, Collection trustBaseSet, boolean useDeltas, String sigProvider) throws CertPathValidatorException {
        CompositeCRL compCRL = this.getFirstFindFromCache(issuerDN, reasons, caCertificate);
        if (compCRL != null) {
            Object[] result = this.getStatusFromCertStores(issuerDN, caCertificate, validationDate, certStores, reasons, true, willBeTrustedCollection, trustBaseSet, useDeltas, sigProvider);
            compCRL = this.getFirstFindFromCache(issuerDN, reasons, caCertificate);
        }
        return compCRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompositeCRL getFirstFindFromCache(String issuerName, boolean[] reasons, boolean caCertificate) {
        Hashtable placeToLook = null;
        CompositeCRL compCRL = null;
        placeToLook = caCertificate ? (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(issuerName) : (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(issuerName);
        if (placeToLook != null) {
            Hashtable hashtable = placeToLook;
            synchronized (hashtable) {
                Enumeration enumeration = placeToLook.elements();
                while (enumeration.hasMoreElements() && !CertPathUtil.minimalUserReasonsSatisfied(reasons, (compCRL = (CompositeCRL)enumeration.nextElement()).getReasons())) {
                    compCRL = null;
                }
            }
        }
        return compCRL;
    }

    int processIssuerName(X509Certificate currentCert, Collection willBeTrustedCollection, Collection certStores, boolean useDeltas, Collection trustBaseSet, boolean caCertificate, Date validationDate, boolean[] userReasons, String sigProvider) throws CertPathValidatorException {
        Hashtable hashtableCompositeCRLs = null;
        String issuerDN = currentCert.getIssuerX500Principal().toString();
        int status = 2001;
        hashtableCompositeCRLs = caCertificate ? (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(issuerDN) : (Hashtable)CompositeCRL.EEcompositeCRLHashtable.get(issuerDN);
        if (hashtableCompositeCRLs != null) {
            status = this.getCRSFromCache(hashtableCompositeCRLs, validationDate, currentCert.getSerialNumber(), userReasons);
        }
        if (status == 2001) {
            Object[] result = this.getStatusFromCertStores(issuerDN, caCertificate, validationDate, certStores, userReasons, true, willBeTrustedCollection, trustBaseSet, useDeltas, sigProvider);
            hashtableCompositeCRLs = caCertificate ? (Hashtable)result[0] : (Hashtable)result[1];
            status = this.getCRSFromCache(hashtableCompositeCRLs, validationDate, currentCert.getSerialNumber(), userReasons);
        }
        return status;
    }

    int getCRSFromCache(Hashtable hashtableCompositeCRLs, Date validationDate, BigInteger serialNumber, boolean[] userReasons) throws CertPathValidatorException {
        boolean[] allCRLReasons = new boolean[]{false, false, false, false, false, false, false, false, false};
        int status = 2001;
        Enumeration enumeration = hashtableCompositeCRLs.elements();
        while (enumeration.hasMoreElements()) {
            CompositeCRL compCRL = (CompositeCRL)enumeration.nextElement();
            status = compCRL.getStatus(serialNumber, validationDate);
            if (status != 2001 && status != 2000) continue;
            CertPathUtil.unionReasons(allCRLReasons, compCRL.getReasons());
            if (!CertPathUtil.allUserReasonsSatisfied(userReasons, allCRLReasons)) continue;
            break;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getStatusFromCertStores(String issuerDN, boolean caCertificate, Date validationDate, Collection certStores, boolean[] userReasons, boolean allReasons, Collection willBeTrustedCollection, Collection trustBaseSet, boolean useDeltas, String sigProvider) throws CertPathValidatorException {
        Hashtable hashtableCACompositeCRLs = null;
        Hashtable hashtableEECompositeCRLs = null;
        Hashtable hashtable = CompositeCRL.CAcompositeCRLHashtable;
        synchronized (hashtable) {
            hashtableCACompositeCRLs = (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(issuerDN);
            if (hashtableCACompositeCRLs == null) {
                hashtableCACompositeCRLs = new Hashtable();
                CompositeCRL.CAcompositeCRLHashtable.put(issuerDN, hashtableCACompositeCRLs);
            }
        }
        hashtable = CompositeCRL.EEcompositeCRLHashtable;
        synchronized (hashtable) {
            hashtableEECompositeCRLs = (Hashtable)CompositeCRL.EEcompositeCRLHashtable.get(issuerDN);
            if (hashtableEECompositeCRLs == null) {
                hashtableEECompositeCRLs = new Hashtable();
                CompositeCRL.EEcompositeCRLHashtable.put(issuerDN, hashtableEECompositeCRLs);
            }
        }
        this.updateCachesFromCertStores(issuerDN, caCertificate, validationDate, certStores, hashtableCACompositeCRLs, hashtableEECompositeCRLs, userReasons, allReasons, willBeTrustedCollection, trustBaseSet, useDeltas, sigProvider);
        Object[] result = new Object[]{hashtableCACompositeCRLs, hashtableEECompositeCRLs};
        return result;
    }

    void updateCachesFromCertStores(String issuerDN, boolean caCertificate, Date validationDate, Collection certStores, Hashtable hashtableCACompositeCRLs, Hashtable hashtableEECompositeCRLs, boolean[] userReasons, boolean allReasons, Collection willBeTrustedCollection, Collection trustBaseSet, boolean useDeltas, String sigProvider) throws CertPathValidatorException {
        boolean[] allCRLReasons = new boolean[]{false, false, false, false, false, false, false, false, false};
        X509CRLSelector crlSelector = new X509CRLSelector();
        try {
            crlSelector.addIssuerName(issuerDN);
        }
        catch (IOException e) {
            return;
        }
        Vector<X509CRL> deltaCRLs = new Vector<X509CRL>();
        block4: for (CertStore currentCertStore : certStores) {
            Collection<? extends CRL> crls = null;
            try {
                crls = currentCertStore.getCRLs(crlSelector);
            }
            catch (CertStoreException e) {
                // empty catch block
            }
            if (crls == null) continue;
            for (X509CRL x509CRL : crls) {
                if (CompositeCRL.isDeltaCRL(x509CRL)) {
                    deltaCRLs.add(x509CRL);
                    continue;
                }
                CompositeCRL compCRL = this.createCompositeCRL(hashtableEECompositeCRLs, hashtableCACompositeCRLs, x509CRL, certStores, willBeTrustedCollection, trustBaseSet, sigProvider);
                if (compCRL == null || (!caCertificate || !compCRL.isTypeCA()) && (caCertificate || !compCRL.isTypeEE())) continue;
                CertPathUtil.unionReasons(allCRLReasons, compCRL.getReasons());
                if (allReasons) {
                    if (!CertPathUtil.allUserReasonsSatisfied(userReasons, allCRLReasons)) continue;
                    Date compNextUpdate = compCRL.getNextUpdate();
                    int compare = compNextUpdate.compareTo(validationDate);
                    if (compare > 0) break block4;
                    if (compare > 0) continue;
                }
                if (!CertPathUtil.minimalUserReasonsSatisfied(userReasons, allCRLReasons)) continue;
                break block4;
            }
        }
        Hashtable ht = caCertificate ? hashtableCACompositeCRLs : hashtableEECompositeCRLs;
        for (X509CRL deltaCRL : deltaCRLs) {
            CompositeCRL compositeCRL = (CompositeCRL)ht.get(CompositeCRL.getCRLNumber(deltaCRL));
            if (compositeCRL == null) continue;
            compositeCRL.refresh(deltaCRL);
        }
    }

    CompositeCRL createCompositeCRL(Hashtable hashtableEECompositeCRLs, Hashtable hashtableCACompositeCRLs, X509CRL crl, Collection certStores, Collection willBeTrustedCollection, Collection trustedCerts, String sigProvider) throws CertPathValidatorException {
        Object obj;
        CompositeCRL returnCompCRL = null;
        CompositeCRL compCRL = new CompositeCRL(null);
        compCRL.update(crl);
        BigInteger crlNumber = compCRL.getNumber();
        boolean updateEEList = false;
        boolean updateCAList = false;
        if (compCRL.isTypeEE() && (obj = hashtableEECompositeCRLs.get(crlNumber)) == null) {
            updateEEList = true;
        }
        if (compCRL.isTypeCA() && (obj = hashtableCACompositeCRLs.get(crlNumber)) == null) {
            updateCAList = true;
        }
        if (updateEEList || updateCAList) {
            X509Certificate issuerCert = null;
            try {
                issuerCert = CertPathUtil.findIssuerOfCRL(crl, willBeTrustedCollection, trustedCerts, certStores, sigProvider);
            }
            catch (CertificateNotYetValidException e) {
                issuerCert = null;
            }
            if (issuerCert != null) {
                compCRL.setIssuerCertificate(issuerCert);
                boolean isTrusted = this.isIssuerTrusted(issuerCert, willBeTrustedCollection, trustedCerts, sigProvider);
                returnCompCRL = compCRL;
                if (isTrusted) {
                    if (updateEEList) {
                        hashtableEECompositeCRLs.put(crlNumber, compCRL);
                    }
                    if (updateCAList) {
                        hashtableCACompositeCRLs.put(crlNumber, compCRL);
                    }
                }
            }
        }
        return returnCompCRL;
    }

    boolean isIssuerTrusted(X509Certificate cert, Collection willBeTrustedCollection, Collection trustedCerts, String sigProvider) {
        TrustAnchor issuer = null;
        boolean isTrusted = CertPathUtil.findIssuerForCRSCheck(cert, willBeTrustedCollection, sigProvider);
        if (!isTrusted) {
            try {
                issuer = CertPathUtil.findIssuer(cert, trustedCerts, sigProvider);
            }
            catch (CertPathValidatorException ex) {
                issuer = null;
            }
            if (issuer != null) {
                isTrusted = true;
            }
        }
        return isTrusted;
    }

    int retrieveBaseCRL(CompositeCRL compCRL, DirContext ctx, String name, String[] attribute, Date validationDate, String sigProvider) throws CertPathValidatorException {
        int status = 0;
        X509CRLImpl[] crl = CertPathUtil.retrieveCRLs(ctx, name, attribute);
        status = compCRL.updateBase((X509CRL)crl[0], validationDate, sigProvider);
        return status;
    }

    int retrieveDeltaCRL(CompositeCRL compCRL, DirContext ctx, String name, String[] attribute, Date validationDate, String sigProvider) throws CertPathValidatorException {
        int status = 0;
        X509CRLImpl[] crl = CertPathUtil.retrieveCRLs(ctx, name, attribute);
        status = compCRL.updateDelta((X509CRL)crl[0], validationDate, sigProvider);
        return status;
    }

    String[] getLDAPURLAndDN(String uri) {
        String[] ret;
        block12: {
            ret = new String[2];
            try {
                CompositeName cn = new CompositeName(uri);
                ret[0] = cn.get(0) + "//" + cn.get(2);
                String dnquery = cn.getSuffix(3).toString();
                int idx = dnquery.indexOf("?");
                if (idx >= 0) {
                    dnquery = dnquery.substring(0, idx);
                }
                StringBuffer result = new StringBuffer();
                if (dnquery.indexOf("%") >= 0) {
                    for (int i = 0; i < dnquery.length(); ++i) {
                        if (dnquery.charAt(i) != '%') {
                            result.append(dnquery.charAt(i));
                            continue;
                        }
                        if (i < dnquery.length() - 2) {
                            StringBuffer hex = new StringBuffer();
                            hex.append(dnquery.charAt(i + 1));
                            hex.append(dnquery.charAt(i + 2));
                            try {
                                Integer intg = Integer.valueOf(hex.toString(), 16);
                                i += 2;
                                result.append((char)intg.intValue());
                            }
                            catch (NumberFormatException ex) {
                                result.append(dnquery.charAt(i));
                            }
                            continue;
                        }
                        result.append(dnquery.charAt(i));
                    }
                    ret[1] = result.toString();
                } else {
                    ret[1] = dnquery;
                }
            }
            catch (InvalidNameException e) {
                if (debug != null) {
                    System.out.println("CERTPATH: Failed to retrieve CRL from " + uri);
                    e.printStackTrace();
                }
            }
            catch (NamingException e) {
                if (debug == null) break block12;
                System.out.println("CERTPATH: Failed to retrieve CRL from " + uri);
                e.printStackTrace();
            }
        }
        return ret;
    }

    private Collection getIBMCollectionCertStores(Collection certStores) {
        Vector<CertStore> ibmCollectionCertStores = new Vector<CertStore>();
        for (CertStore currentCertStore : certStores) {
            if (!currentCertStore.getType().equals("Collection")) continue;
            ibmCollectionCertStores.add(currentCertStore);
        }
        if (ibmCollectionCertStores.size() <= 0) {
            ibmCollectionCertStores = null;
        }
        return ibmCollectionCertStores;
    }

    /*
     * WARNING - void declaration
     */
    private Hashtable setCRLCache(Collection certStores) {
        if (!certStores.isEmpty()) {
            CertStore store = null;
            Iterator it = certStores.iterator();
            while (it.hasNext()) {
                List<? extends Certificate> certs;
                Collection<? extends CRL> result = null;
                store = (CertStore)it.next();
                if (store.getType().equals("Collection")) {
                    try {
                        result = store.getCRLs(null);
                    }
                    catch (CertStoreException e) {
                        result = null;
                    }
                } else if (store.getType().equals("LDAP") && !(certs = this.certPath.getCertificates()).isEmpty()) {
                    X509CRLSelector x509CRLSelector = new X509CRLSelector();
                    Object var7_16 = null;
                    X500Principal issuerName = null;
                    for (X509Certificate x509Certificate : certs) {
                        issuerName = x509Certificate.getIssuerX500Principal();
                        x509CRLSelector.addIssuer(issuerName);
                        if (!this.checkCRLDPEnabled()) continue;
                        try {
                            DistributionPoint[] distributionPoints = CertPathUtil.getCRLDistributionPoints(x509Certificate);
                            if (distributionPoints == null) continue;
                            for (int i = 0; i < distributionPoints.length; ++i) {
                                GeneralName name = null;
                                try {
                                    GeneralNames dpName = (GeneralNames)distributionPoints[i].getName();
                                    name = CertPathUtil.getSupportedNameObjectFromGeneralNames(dpName);
                                }
                                catch (IOException e) {
                                }
                                catch (GeneralNamesException e) {
                                    // empty catch block
                                }
                                if (name == null || name.getType() != 4) continue;
                                String dnName = name.toString();
                                X500Principal dnName2 = new X500Principal(dnName);
                                x509CRLSelector.addIssuer(dnName2);
                            }
                        }
                        catch (Exception ex) {
                        }
                    }
                    try {
                        result = store.getCRLs(x509CRLSelector);
                    }
                    catch (CertStoreException e) {
                        result = null;
                    }
                }
                if (result == null) continue;
                ArrayList<void> list = null;
                Object var6_9 = null;
                Object var7_19 = null;
                for (X509CRL x509CRL : result) {
                    void var6_13;
                    if (!(x509CRL instanceof X509CRLImpl)) {
                        try {
                            X509CRLImpl x509CRLImpl = new X509CRLImpl(x509CRL.getEncoded());
                        }
                        catch (CRLException ex) {
                            continue;
                        }
                    }
                    X500Principal x500Principal = var6_13.getIssuerX500Principal();
                    list = (ArrayList<void>)this.CRLCache.get(x500Principal);
                    if (list != null) {
                        list.add(var6_13);
                        this.CRLCache.put(x500Principal, list);
                        continue;
                    }
                    list = new ArrayList<void>();
                    list.add(var6_13);
                    this.CRLCache.put(x500Principal, list);
                }
            }
            if (debug != null) {
                System.out.println("CERTPATH: =========The list of CRLs in memory cache:=========");
                Enumeration enumeration = this.CRLCache.keys();
                while (enumeration.hasMoreElements()) {
                    Object crlkey = enumeration.nextElement();
                    ArrayList crllist = (ArrayList)this.CRLCache.get(crlkey);
                    for (int i = 0; i < crllist.size(); ++i) {
                        X509CRL x509CRL = (X509CRL)crllist.get(i);
                        System.out.println("\n" + x509CRL.getIssuerDN().getName() + ", " + x509CRL.getThisUpdate().toString());
                    }
                }
                System.out.println("=========End of list=========");
            }
        }
        return this.CRLCache;
    }

    private boolean intersectReasons(boolean[] reasons1, boolean[] reasons2) {
        int length = Math.min(reasons1.length, reasons2.length);
        for (int i = 0; i < length; ++i) {
            if (reasons1[i] != reasons2[i]) continue;
            return true;
        }
        return false;
    }

    private boolean checkCRLDPEnabled() {
        String enabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.security.enableCRLDP");
            }
        });
        boolean enabledBoolean = new Boolean(enabled);
        if (debug != null) {
            if (enabledBoolean) {
                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLDPEnabled():  com.ibm.security.enableCRLDP property is set to 'TRUE'.");
            } else {
                System.out.println("CERTPATH:  CRSChecker.java:  checkCRLDPEnabled():  com.ibm.security.enableCRLDP property is either unset or set to 'FALSE'.");
            }
        }
        return enabledBoolean;
    }

    private boolean checkNULLCRLDPEnabled() {
        String enabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.security.enableNULLCRLDP");
            }
        });
        boolean enabledBoolean = new Boolean(enabled);
        if (debug != null) {
            if (enabledBoolean) {
                System.out.println("CERTPATH:  CRSChecker.java:  checkNULLCRLDPEnabled():  com.ibm.security.enableNULLCRLDP property is set to 'TRUE'.");
            } else {
                System.out.println("CERTPATH:  CRSChecker.java:  checkNULLCRLDPEnabled():  com.ibm.security.enableNULLCRLDP property is either unset or set to 'FALSE'.");
            }
        }
        return enabledBoolean;
    }

    private boolean checkDELTACRLEnabled() {
        String enabled = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.security.enableDELTACRL");
            }
        });
        boolean enabledBoolean = new Boolean(enabled);
        if (debug != null) {
            if (enabledBoolean) {
                System.out.println("CERTPATH:  CRSChecker.java:  checkDELTACRLEnabled():  com.ibm.security.enableDELTACRL property is set to 'TRUE'.");
            } else {
                System.out.println("CERTPATH:  CRSChecker.java:  checkDELTACRLEnabled():  com.ibm.security.enableDELTACRL property is either unset or set to 'FALSE'.");
            }
        }
        return enabledBoolean;
    }

    void check() {
        --this.currentCertIndex;
    }

    private boolean verifyCRL(X509Certificate cert, DistributionPoint point, X509CRL completeCRL, X509CRL deltaCRL, PublicKey prevKey, boolean[] reasonsMask) throws IOException {
        if (debug != null) {
            System.out.println("\nCERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD ENTRY");
            System.out.println("\n");
            System.out.println("DUMPING THE INPUT PARMS:");
            if (cert != null) {
                System.out.println("\nThe cert argument = ");
                System.out.println(cert.toString());
            } else {
                System.out.println("\nThe cert argument = null ");
            }
            if (point != null) {
                System.out.println("\nThe distributionPoint from the cert = ");
                System.out.println(point.toString());
            } else {
                System.out.println("\nThe distributionPoint from the cert = null ");
            }
            if (completeCRL != null) {
                System.out.println("\nThe completeCRL argument = ");
                System.out.println(completeCRL.toString());
            } else {
                System.out.println("\nThe completeCRL argument= null ");
            }
            if (deltaCRL != null) {
                System.out.println("\nThe deltaCRL argument = ");
                System.out.println(deltaCRL.toString());
            } else {
                System.out.println("\nThe deltaCRL argument = null ");
            }
            if (prevKey != null) {
                System.out.println("\nThe prevKey argument != null\n");
            } else {
                System.out.println("\nThe prevKey argument = null\n");
            }
            this.printReasonsMask(reasonsMask);
        }
        try {
            Iterator<String> i;
            Set<String> unresCritExts;
            Date today;
            if (completeCRL == null && deltaCRL != null) {
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Verification failed since call made with delta CRL alone.");
                    System.out.println("                                            Information within the completeCRL is required to verify a deltaCRL.");
                    System.out.println("                                            Returning 'false'");
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                    System.out.println("\n");
                }
                return false;
            }
            Date nextUpdate = completeCRL.getNextUpdate();
            if (nextUpdate != null) {
                today = new Date();
                if (nextUpdate.before(today)) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL has expired. ");
                        System.out.println("                                            Returning false.");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                        System.out.println("\n");
                    }
                    return false;
                }
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL has NOT expired. ");
                }
            }
            if (this.useDeltas && deltaCRL != null && (nextUpdate = deltaCRL.getNextUpdate()) != null) {
                today = new Date();
                if (nextUpdate.before(today)) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The deltaCRL has expired. ");
                        System.out.println("                                            Returning false.");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                        System.out.println("\n");
                    }
                    return false;
                }
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The deltaCRL has NOT expired. ");
                }
            }
            X509CertImpl certImpl = X509CertImpl.toImpl((X509Certificate)cert);
            X500Name certIssuer = (X500Name)certImpl.getIssuerDN();
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  certIssuer = " + certIssuer.toString());
            }
            X500Name crlIssuer = (X500Name)completeCRL.getIssuerDN();
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  crlIssuer  = " + crlIssuer.toString());
            }
            IssuingDistributionPointExtension completeCRLIDPExt = null;
            byte[] extValue = completeCRL.getExtensionValue("2.5.29.28");
            if (extValue != null) {
                DerValue derValue = new DerValue(extValue);
                extValue = derValue.getOctetString();
                completeCRLIDPExt = new IssuingDistributionPointExtension(extValue);
                if (debug != null) {
                    System.out.println("\nCERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL's IDP extension is: ");
                    System.out.println(completeCRLIDPExt.toString());
                }
            } else if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL does not contain an IDP extension.");
            }
            GeneralNames pointCrlIssuer = point.getIssuer();
            if (pointCrlIssuer != null) {
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The cert's distributionPoint contains a crlIssuer.");
                    System.out.println("                                            That crlIssuer is:                                ");
                    System.out.println(pointCrlIssuer.toString());
                    System.out.println("                                            This is a GeneralNames name. \n");
                }
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Verify that the crlIssuer from the cert's distributionPoint");
                    System.out.println("                                            matches the issuer of the CRL.                             ");
                }
                boolean match = false;
                Iterator t = pointCrlIssuer.iterator();
                while (!match && t.hasNext()) {
                    GeneralNameInterface name = ((GeneralName)t.next()).getName();
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  crlIssuer from distributionPoint is: " + name);
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  crlIssuer from the CRL is:           " + crlIssuer);
                    }
                    if (crlIssuer.equals((Object)name)) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The crlIssuer from the cert's distributionPoint");
                            System.out.println("                                            matches the issuer of the CRL.                 ");
                        }
                        match = true;
                        continue;
                    }
                    if (debug == null) continue;
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The crlIssuer from the cert's distributionPoint");
                    System.out.println("                                            DOES NOT match the issuer of the CRL.          ");
                }
                if (!match) {
                    if (debug != null) {
                        System.out.println("                                              Returning 'false'");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                        System.out.println("\n");
                    }
                    return false;
                }
                if (completeCRLIDPExt != null && ((Boolean)completeCRLIDPExt.get("indirect_crl")).equals(Boolean.FALSE)) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The INDIRECT_CRL boolean is not asserted within the");
                        System.out.println("                                            completeCRL issuing distribution point extension.");
                        System.out.println("                                            Returning 'false'");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                        System.out.println("\n");
                    }
                    return false;
                }
            } else {
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  A CRL Issuer is not present within the cert's distribution point, so instead,");
                    System.out.println("                                            verify that the completeCRL issuer matches the cert issuer.");
                }
                if (!crlIssuer.equals(certIssuer)) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL issuer does not match the cert issuer");
                        System.out.println("                                            Returning 'false'");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                        System.out.println("\n");
                    }
                    return false;
                }
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL issuer matches the cert issuer.");
                }
            }
            if (completeCRLIDPExt != null) {
                Boolean b;
                DistributionPointName idpPoint;
                if (debug != null) {
                    System.out.println("\nCERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL's IDP Extension is NOT null.  It is:");
                    System.out.println(completeCRLIDPExt.toString());
                }
                if ((idpPoint = completeCRLIDPExt.getDistributionPoint()) != null) {
                    DistributionPointName pointDistributionPointName;
                    GeneralNames idpNames;
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The DP name from the completeCRL's IDP Extension is:");
                        System.out.println(idpPoint.toString());
                    }
                    if (idpPoint instanceof GeneralNames) {
                        idpNames = (GeneralNames)idpPoint;
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL's IDP name is a GeneralNames: \n" + idpNames.toString() + "\n");
                        }
                    } else {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL's IDP name is a RDN: " + (RDN)idpPoint);
                            System.out.println("                                            Build a GeneralNames object from the RDN and the crl's issuer name/DN.");
                        }
                        RDN relativeName = (RDN)idpPoint;
                        idpNames = this.getFullNames(crlIssuer, relativeName);
                    }
                    if ((pointDistributionPointName = point.getName()) != null) {
                        GeneralNames pointNames;
                        if (debug != null) {
                            System.out.println("\nCERTPATH:  CRSChecker.java:  verifyCRL2():  A DP name is present within this cert's distributionPoint.  It is:");
                            System.out.println(pointDistributionPointName.toString());
                        }
                        if (pointDistributionPointName instanceof GeneralNames) {
                            pointNames = (GeneralNames)pointDistributionPointName;
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The cert's IDP name is a GeneralNames: " + pointNames + "\n");
                            }
                        } else {
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The cert's IDP name is an RDN: " + (RDN)pointDistributionPointName);
                                System.out.println("                                            Build a GeneralNames object from the RDN and the cert's issuer name/DN.");
                            }
                            RDN relativeName2 = (RDN)pointDistributionPointName;
                            pointNames = this.getFullNames(certIssuer, relativeName2);
                        }
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Verify that one of the names within the");
                            System.out.println("                                            cert's distributionPoint name equals one of the");
                            System.out.println("                                            names within the completeCRL's issuing distribution");
                            System.out.println("                                            point extension.                                   ");
                        }
                        boolean match = false;
                        Iterator i2 = idpNames.iterator();
                        while (!match && i2.hasNext()) {
                            GeneralNameInterface idpName = ((GeneralName)i2.next()).getName();
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  idpName: " + idpName);
                            }
                            Iterator p = pointNames.iterator();
                            while (!match && p.hasNext()) {
                                GeneralNameInterface pointName = ((GeneralName)p.next()).getName();
                                if (debug != null) {
                                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  pointName: " + pointName);
                                }
                                if (!(match = idpName.equals(pointName)) || debug == null) continue;
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  These names match!\n");
                            }
                        }
                        if (!match) {
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  None of the names within the cert's distribution point matches");
                                System.out.println("                                            one of the names within the completeCRL's IDP extension.");
                                System.out.println("                                            Returing 'false'");
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                                System.out.println("\n");
                            }
                            return false;
                        }
                    } else {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Verify that one of the names within the                        ");
                            System.out.println("                                            crlIssuer field of the cert's distributionPoint matches        ");
                            System.out.println("                                            one of the names within the completeCRL's issuing distribution ");
                            System.out.println("                                            point extension.                                               ");
                        }
                        boolean match = false;
                        Iterator t = pointCrlIssuer.iterator();
                        while (!match && t.hasNext()) {
                            GeneralNameInterface crlIssuerName = ((GeneralName)t.next()).getName();
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  crlIssuerName: " + crlIssuerName);
                            }
                            Iterator i3 = idpNames.iterator();
                            while (!match && i3.hasNext()) {
                                GeneralNameInterface idpName = ((GeneralName)i3.next()).getName();
                                if (debug != null) {
                                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  idpName: " + idpName);
                                }
                                if (!(match = crlIssuerName.equals(idpName)) || debug == null) continue;
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  These names match!");
                            }
                        }
                        if (!match) {
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  One of the names within the CRL's issuing distribution point does not match");
                                System.out.println("                                            one of the names within the crlIssuer field of the cert's distribution point.");
                                System.out.println("                                            Returning 'false'");
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                                System.out.println("\n");
                            }
                            return false;
                        }
                    }
                }
                if ((b = (Boolean)completeCRLIDPExt.get("user_certs_only")).equals(Boolean.TRUE) && certImpl.getBasicConstraints() != -1) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The CRL contains the 'onlyContainsUserCerts' boolean,");
                        System.out.println("                                            however, the cert to be verified is NOT an EE cert.");
                        System.out.println("                                            Returning 'false'");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                        System.out.println("\n");
                    }
                    return false;
                }
                b = (Boolean)completeCRLIDPExt.get("ca_certs_only");
                if (b.equals(Boolean.TRUE) && certImpl.getBasicConstraints() == -1) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The CRL contains the 'onlyContainsCACerts' boolean,");
                        System.out.println("                                            however, the cert to be verified is NOT a CA cert.");
                        System.out.println("                                            Returning 'false'");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                        System.out.println("\n");
                    }
                    return false;
                }
                b = (Boolean)completeCRLIDPExt.get("only_attribute_certs");
                if (b.equals(Boolean.TRUE)) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The CRL contains the 'onlyContainsAttributeCerts' boolean.");
                        System.out.println("                                            Returning 'false.'");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                    }
                    return false;
                }
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The CRL DOES NOT contain the 'onlyContainsAttributeCerts' boolean.");
                }
            } else if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL does not contain an Issuing Disribution Point extension.");
            }
            if (this.useDeltas) {
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  useDeltas is set to TRUE");
                }
                if (deltaCRL != null) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  A deltaCRL available to be verified.");
                    }
                    X500Name deltaCRLIssuer = (X500Name)deltaCRL.getIssuerDN();
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  deltaCRL    issuer is: " + deltaCRLIssuer.toString());
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  completeCRL issuer is: " + crlIssuer.toString());
                    }
                    if (!deltaCRLIssuer.equals(crlIssuer)) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The deltaCRL issuer does not match the completeCRL issuer.");
                            System.out.println("                                            Returning 'false'");
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                            System.out.println("\n");
                        }
                        return false;
                    }
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The deltaCRL issuer matches the completeCRL issuer.");
                    }
                    IssuingDistributionPointExtension deltaCRLIDPExt = null;
                    byte[] extValue2 = deltaCRL.getExtensionValue("2.5.29.28");
                    if (extValue2 != null) {
                        DerValue derValue = new DerValue(extValue2);
                        extValue2 = derValue.getOctetString();
                        deltaCRLIDPExt = new IssuingDistributionPointExtension(extValue2);
                        if (debug != null) {
                            System.out.println("\nCERTPATH:  CRSChecker.java:  verifyCRL2():  The deltaCRL's IDP extension is: ");
                            System.out.println(deltaCRLIDPExt.toString());
                        }
                    } else if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The deltaCRL does not contain an IDP extension.");
                    }
                    if (completeCRLIDPExt != null) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL's IDP extension is: ");
                            System.out.println(completeCRLIDPExt.toString() + "\n");
                        }
                    } else if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL does not contain an IDP extension. ");
                    }
                    if (deltaCRLIDPExt != null && completeCRLIDPExt != null) {
                        if (!deltaCRLIDPExt.equals((Object)completeCRLIDPExt)) {
                            if (debug != null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Both the deltaCRLIDPExt and the completeCRLIDPExt");
                                System.out.println("                                            are present, but they do not match.");
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Returning 'false'");
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                                System.out.println("\n");
                            }
                            return false;
                        }
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Both the deltaCRLIDPExt and the completeCRLIDPExt");
                            System.out.println("                                            are present, AND THEY MATCH ! \n");
                        }
                    } else if (deltaCRLIDPExt != null || completeCRLIDPExt != null) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  If either the deltaCRLIDPExt or the completeCRLIDPExt");
                            System.out.println("                                            is missing, then both should be missing.");
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Returning 'false'");
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                            System.out.println("\n");
                        }
                        return false;
                    }
                    AuthorityKeyIdentifierExtension completeCRLAKIExt = null;
                    byte[] extensionValue = completeCRL.getExtensionValue("2.5.29.35");
                    if (extensionValue != null) {
                        DerValue derValue = new DerValue(extensionValue);
                        extensionValue = derValue.getOctetString();
                        completeCRLAKIExt = new AuthorityKeyIdentifierExtension(Boolean.valueOf(false), (Object)extensionValue);
                    } else if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL does not contain an Authority Key Identifier extension.");
                    }
                    AuthorityKeyIdentifierExtension deltaCRLAKIExt = null;
                    extensionValue = deltaCRL.getExtensionValue("2.5.29.35");
                    if (extensionValue != null) {
                        DerValue derValue = new DerValue(extensionValue);
                        extensionValue = derValue.getOctetString();
                        deltaCRLAKIExt = new AuthorityKeyIdentifierExtension(Boolean.valueOf(false), (Object)extensionValue);
                    } else if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The deltaCRL does not contain an Authority Key Identifier extension.");
                    }
                    if (deltaCRLAKIExt == null || completeCRLAKIExt == null) {
                        if (debug != null) {
                            if (deltaCRLAKIExt == null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The 'authority key identifier' extension is missing from");
                                System.out.println("                                            the deltaCRL.");
                            }
                            if (completeCRLAKIExt == null) {
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The 'authority key identifier' extension is missing from");
                                System.out.println("                                            the completeCRL.");
                            }
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Returning 'false'");
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                            System.out.println("\n");
                        }
                        return false;
                    }
                    if (!deltaCRLAKIExt.equals((Object)completeCRLAKIExt)) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The deltaCRL 'Authority Key Identifier' extension does not match");
                            System.out.println("                                            the completeCRL 'Authority Key Identifier' extension.");
                            System.out.println("deltaCRLAKIExt = ");
                            System.out.println(deltaCRLAKIExt.toString() + "\n");
                            System.out.println("completeCRLAKIExt = ");
                            System.out.println(completeCRLAKIExt.toString() + "\n");
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Returning 'false'");
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                            System.out.println("\n");
                        }
                        return false;
                    }
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The deltaCRL 'Authority Key Identifier' extension matches");
                        System.out.println("                                            the completeCRL 'Authority Key Identifier' extension.");
                    }
                } else if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  There is no deltaCRL to be verified.");
                }
            } else if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  useDeltas is set to FALSE.");
                System.out.println("                                            Skipping all of the deltaCRL validation logic.");
            }
            ReasonFlags reasons = null;
            boolean[] idpReasonFlags = null;
            if (completeCRLIDPExt != null && (reasons = (ReasonFlags)completeCRLIDPExt.get("limited_reasons")) != null) {
                idpReasonFlags = reasons.getFlags();
            }
            if (debug != null) {
                if (idpReasonFlags != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL's IDP reasonFlags are:");
                    for (int k = 0; k < idpReasonFlags.length; ++k) {
                        if (idpReasonFlags[k]) {
                            System.out.print("true ");
                            continue;
                        }
                        System.out.print("false ");
                    }
                    System.out.println("\n");
                } else {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The completeCRL's IDP reasonFlags are null.");
                }
            }
            ReasonFlags tempReasonFlags = point.getReasons();
            boolean[] pointReasonFlags = null;
            if (tempReasonFlags != null) {
                pointReasonFlags = tempReasonFlags.getFlags();
            }
            if (debug != null) {
                if (pointReasonFlags != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The ReasonFlags from the certificate's CRL distribution point are:");
                    for (int k = 0; k < pointReasonFlags.length; ++k) {
                        if (pointReasonFlags[k]) {
                            System.out.print("true ");
                            continue;
                        }
                        System.out.print("false ");
                    }
                    System.out.println("\n");
                } else {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The ReasonFlags from the certificate's CRL distribution point are null.");
                }
            }
            boolean[] interimReasonsMask = new boolean[9];
            if (idpReasonFlags != null) {
                if (pointReasonFlags != null) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Reason flags exist within both the CRL's IDP and the cert's distribution point.");
                        System.out.println("                                            Therefore, we are setting the interimReasonsMask to the intersection of the CRL's IDP and the cert's distribution point.");
                    }
                    for (int i4 = 0; i4 < interimReasonsMask.length; ++i4) {
                        interimReasonsMask[i4] = i4 < idpReasonFlags.length && idpReasonFlags[i4] && i4 < pointReasonFlags.length && pointReasonFlags[i4];
                    }
                } else {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The reasonFlags from the cert's distributionPoint are null.");
                        System.out.println("                                            Therefore, we are setting the interimReasonsMask to the value of the reasonsFlags from the complete CRL's IDP.");
                    }
                    interimReasonsMask = (boolean[])reasons.getFlags().clone();
                }
            } else if (completeCRLIDPExt == null || reasons == null) {
                if (pointReasonFlags != null) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The reasons within the completeCRL's IDP are null.");
                        System.out.println("                                            Therefore, we are setting the interimReasonsMask to the value of the pointReasonFlags.");
                    }
                    interimReasonsMask = (boolean[])pointReasonFlags.clone();
                } else {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The reasons within both completeCRL's IDP and the cert's distributionPoint are null.");
                        System.out.println("                                            Therefore, we are setting the interimReasonsMask to 'ALL-REASONS'.");
                    }
                    Arrays.fill(interimReasonsMask, true);
                }
            }
            if (debug != null) {
                System.out.println("\nCERTPATH:  CRSChecker.java:  verifyCRL2():  The interimReasonsMask computed from the CRL is:");
                this.printInterimReasonsMask(interimReasonsMask);
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The input reasonsMask is:");
                this.printReasonsMask(reasonsMask);
            }
            boolean oneOrMore = false;
            for (int i5 = 0; i5 < interimReasonsMask.length && !oneOrMore; ++i5) {
                if (!interimReasonsMask[i5] || i5 < reasonsMask.length && reasonsMask[i5]) continue;
                oneOrMore = true;
            }
            if (!oneOrMore) {
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The computed interimReasonsMask does not include any new reasons.");
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Returning 'false' for this CRL");
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                    System.out.println("\n");
                }
                return false;
            }
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The computed interimReasonsMask includes at least one new reason.");
                System.out.println("                                            however, the reasonsMask will not be updated until we are sure   ");
                System.out.println("                                            that this CRL is appropriate for verifying the revocation status ");
                System.out.println("                                            of the cert.                                                     ");
            }
            try {
                AlgorithmChecker.check(prevKey, completeCRL);
                completeCRL.verify(prevKey);
            }
            catch (Exception e) {
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The following exception was thrown:");
                    e.printStackTrace();
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Either the completeCRL signature failed to verify,");
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  or the AlgorithmChecker threw an exception.");
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Returning 'false'");
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                    System.out.println("\n");
                }
                return false;
            }
            if (debug != null) {
                System.out.println("\nCERTPATH:  CRSChecker.java:  verifyCRL2():  completeCRL signature verified successfully!\n");
            }
            if (this.useDeltas && deltaCRL != null) {
                try {
                    AlgorithmChecker.check(prevKey, deltaCRL);
                    deltaCRL.verify(prevKey);
                }
                catch (Exception e) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  The following exception was thrown:");
                        e.printStackTrace();
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Either the deltaCRL signature failed to verify,");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  or the AlgorithmChecker threw an exception.");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Returning 'false'");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                        System.out.println("\n");
                    }
                    return false;
                }
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  deltaCRL signature verified successfully!\n");
                }
            }
            if ((unresCritExts = completeCRL.getCriticalExtensionOIDs()) != null) {
                unresCritExts.remove(PKIXExtensions.IssuingDistributionPoint_Id.toString());
                unresCritExts.remove(PKIXExtensions.AuthorityKey_Id.toString());
                if (!unresCritExts.isEmpty()) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  One or more unrecognized critical extension(s) in the completeCRL: ");
                        i = unresCritExts.iterator();
                        while (i.hasNext()) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  " + i.next());
                        }
                    }
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Returning 'false'");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                        System.out.println("\n");
                    }
                    return false;
                }
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  There are no unrecognized critical extensions within the completeCRL.\n");
                }
            } else if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  There are no unrecognized critical extensions within the completeCRL.\n");
            }
            if (this.useDeltas && deltaCRL != null) {
                unresCritExts = deltaCRL.getCriticalExtensionOIDs();
                if (unresCritExts != null) {
                    unresCritExts.remove(PKIXExtensions.IssuingDistributionPoint_Id.toString());
                    unresCritExts.remove(PKIXExtensions.DeltaCRLIndicator_Id.toString());
                    unresCritExts.remove(PKIXExtensions.AuthorityKey_Id.toString());
                    if (!unresCritExts.isEmpty()) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  One or more unrecognized critical extension(s) in the deltaCRL: ");
                            i = unresCritExts.iterator();
                            while (i.hasNext()) {
                                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  " + i.next());
                            }
                        }
                        if (debug != null) {
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2(): Returning 'false'");
                            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                            System.out.println("\n");
                        }
                        return false;
                    }
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  There are no unrecognized critical extensions within the deltaCRL.\n");
                    }
                } else if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  There are no unrecognized critical extensions within the deltaCRL.\n");
                }
            }
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Update the reasonsMask now that we are sure");
                System.out.println("                                            this CRL is appropriate for verifying the");
                System.out.println("                                            revocation status of the cert.");
                System.out.println("\nPrior to the update the reasonsMask is: ");
                this.printReasonsMask(reasonsMask);
                System.out.println("Prior to the update the interimReasonsMask is: ");
                this.printInterimReasonsMask(interimReasonsMask);
            }
            for (int i6 = 0; i6 < reasonsMask.length; ++i6) {
                reasonsMask[i6] = reasonsMask[i6] || i6 < interimReasonsMask.length && interimReasonsMask[i6];
            }
            if (debug != null) {
                System.out.println("The updated reasonsMask to be returned is:");
                this.printReasonsMask(reasonsMask);
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  Returning 'true'");
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                System.out.println("\n");
            }
            return true;
        }
        catch (Exception e) {
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2(): Exception while verifying CRL:");
                e.printStackTrace();
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2(): Returning 'false'");
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL2():  METHOD EXIT \n");
                System.out.println("\n");
            }
            return false;
        }
    }

    private GeneralNames getFullNames(X500Name issuer, RDN rdn) throws IOException {
        ArrayList<RDN> rdns = new ArrayList<RDN>();
        for (int i = 0; i < issuer.size(); ++i) {
            rdns.add(issuer.getRDN(i));
        }
        rdns.add(rdn);
        X500Name fullName = new X500Name(rdns.toArray(new RDN[0]));
        GeneralNames fullNames = new GeneralNames();
        fullNames.add((Object)new GeneralName((GeneralNameInterface)fullName));
        return fullNames;
    }

    private boolean verifyCRL(X509Certificate cert, X509CRL completeCRL, X509CRL deltaCRL, PublicKey prevKey, boolean[] reasonsMask) throws CertPathValidatorException {
        if (debug != null) {
            System.out.println("\nCERTPATH:  CRSChecker.java:  verifyCRL1():  METHOD ENTRY");
            System.out.println("\n");
            System.out.println("DUMPING THE INPUT PARMS:");
            if (cert != null) {
                System.out.println("\nThe cert argument = ");
                System.out.println(cert.toString());
            } else {
                System.out.println("\nThe cert argument = null ");
            }
            if (completeCRL != null) {
                System.out.println("\nThe completeCRL argument = ");
                System.out.println(completeCRL.toString());
            } else {
                System.out.println("\nThe completeCRL argument = null ");
            }
            if (deltaCRL != null) {
                System.out.println("\nThe deltaCRL argument = ");
                System.out.println(deltaCRL.toString());
            } else {
                System.out.println("\nThe deltaCRL argument = null ");
            }
            if (prevKey != null) {
                System.out.println("\nThe prevKey argument != null\n");
            } else {
                System.out.println("\nThe prevKey argument = null\n");
            }
            this.printReasonsMask(reasonsMask);
            System.out.println("\n");
        }
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl((X509Certificate)cert);
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  Get the CRLDistributionPoints extension from the cert.");
            }
            CRLDistributionPointsExtension ext = null;
            ext = (CRLDistributionPointsExtension)certImpl.getExtension(PKIXExtensions.CRLDistributionPoints_Id);
            if (debug != null && ext != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  The cert's CRLDistributionPoint Extension is:");
                System.out.println(ext.toString());
            }
            List<Object> points = null;
            if (ext == null) {
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  A CRL distribution point extension IS NOT present within this cert.");
                }
                X500Name certIssuer = (X500Name)certImpl.getIssuerDN();
                GeneralNames tempGeneralNames = new GeneralNames();
                GeneralName generalName = new GeneralName((GeneralNameInterface)certIssuer);
                tempGeneralNames.add((Object)generalName);
                DistributionPoint point = new DistributionPoint((DistributionPointName)tempGeneralNames, null, null);
                points = Collections.singletonList(point);
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  A distribution point extension will be assumed, containing the following distribution point:");
                    for (DistributionPoint distributionPoint : points) {
                        System.out.println(distributionPoint.toString());
                    }
                }
            } else {
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  A distribution point extension IS present within this cert.");
                }
                points = new ArrayList<DistributionPoint>();
                DistributionPoint[] tempDistributionPoints = ext.getDistributionPoints();
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  There are " + tempDistributionPoints.length + " distribution points within this cert's distribution point extension.");
                    System.out.println("                                            They are:");
                }
                for (int i = 0; i < tempDistributionPoints.length; ++i) {
                    points.add(tempDistributionPoints[i]);
                }
                if (debug != null) {
                    for (DistributionPoint distributionPoint : points) {
                        System.out.println(distributionPoint.toString());
                    }
                }
            }
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  If the reasonsMask is already equal to ALL_REASONS then");
                System.out.println("                                            there is no need to process this CRL.                  ");
                this.printReasonsMask(reasonsMask);
            }
            Iterator t = points.iterator();
            while (t.hasNext() && !Arrays.equals(reasonsMask, ALL_REASONS)) {
                DistributionPoint point = (DistributionPoint)t.next();
                if (debug != null) {
                    System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  verifyCRL1() now calling verifyCRL2()");
                    System.out.println("                                            with the following distribution point:");
                    System.out.println(point.toString());
                }
                if (this.verifyCRL((X509Certificate)certImpl, point, completeCRL, deltaCRL, prevKey, reasonsMask)) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  verifyCRL2() returned true.");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  verifyCRL1() returning 'true'");
                        System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  METHOD EXIT\n");
                        System.out.println("\n");
                    }
                    return true;
                }
                if (debug == null) continue;
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  verifyCRL2() returned false.");
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  verifyCRL1() continuing to the next distribution point in the cert. ");
            }
        }
        catch (Exception e) {
            if (debug != null) {
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  Exception while verifying CRL: ");
                e.printStackTrace();
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  Returning 'false'");
                System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  METHOD EXIT\n");
                System.out.println("\n");
            }
            return false;
        }
        if (debug != null) {
            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  Returning false.");
            System.out.println("CERTPATH:  CRSChecker.java:  verifyCRL1():  METHOD EXIT\n");
            System.out.println("\n");
        }
        return false;
    }

    private void printReasonsMask(boolean[] reasonsMask) {
        if (debug != null) {
            if (reasonsMask != null) {
                System.out.println("The reasonsMask[] is =");
                for (int j = 0; j < reasonsMask.length; ++j) {
                    if (reasonsMask[j]) {
                        System.out.print("true ");
                        continue;
                    }
                    System.out.print("false ");
                }
                System.out.println("\n");
            } else {
                System.out.println("\nThe reasonsMask[] = null\n ");
            }
        }
    }

    private void printInterimReasonsMask(boolean[] interimReasonsMask) {
        if (debug != null) {
            if (interimReasonsMask != null) {
                System.out.println("The interimReasonsMask[] is =");
                for (int j = 0; j < interimReasonsMask.length; ++j) {
                    if (interimReasonsMask[j]) {
                        System.out.print("true ");
                        continue;
                    }
                    System.out.print("false ");
                }
                System.out.println("\n");
            } else {
                System.out.println("\nThe interimReasonsMask[] = null\n ");
            }
        }
    }

    private void addCRLToSortedList(ArrayList list, X509CRL crl) {
        if (debug != null) {
            // empty if block
        }
        Date crlDate = crl.getThisUpdate();
        int listSize = list.size();
        if (listSize == 0) {
            list.add(0, crl);
        } else {
            int position = 0;
            X509CRL crlFromList = null;
            Date crlFromListDate = null;
            for (position = 0; position < listSize && crlDate.before(crlFromListDate = (crlFromList = (X509CRL)list.get(position)).getThisUpdate()); ++position) {
            }
            list.add(position, crl);
        }
        if (debug != null) {
            // empty if block
        }
    }
}

