/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

abstract class DBCS_IBM_ASCII_Encoder
extends CharsetEncoder {
    protected static final char REPLACE_CHAR = '\ufffd';
    private byte b1;
    private byte b2;
    private byte outchar;
    protected short[] index1;
    protected String index2;
    protected String index2a;
    protected int mask1;
    protected int mask2;
    protected int shift;
    protected int convertType;
    private boolean islegal = true;
    protected boolean mapascii;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected DBCS_IBM_ASCII_Encoder(Charset charset) {
        super(charset, 2.0f, 2.0f);
    }

    protected DBCS_IBM_ASCII_Encoder(Charset charset, byte[] byArray) {
        super(charset, 2.0f, 2.0f);
        if (byArray != null) {
            this.replaceWith(byArray);
        }
    }

    @Override
    public boolean isLegalReplacement(byte[] byArray) {
        if (this.islegal) {
            return true;
        }
        if (byArray.length == 1 && byArray[0] >= 0) {
            return true;
        }
        return super.isLegalReplacement(byArray);
    }

    @Override
    public boolean canEncode(char c) {
        int n = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
        char c2 = n < 15000 ? this.index2.charAt(n) : this.index2a.charAt(n - 15000);
        if (c2 != '\u0000') {
            return true;
        }
        return c == '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        boolean bl = false;
        try {
            for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                char c = cArray[n];
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, cArray, n, n2) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n5 = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                char c2 = n5 < 15000 ? this.index2.charAt(n5) : this.index2a.charAt(n5 - 15000);
                this.b1 = (byte)((c2 & 0xFF00) >> 8);
                this.b2 = (byte)(c2 & 0xFF);
                if (this.mapascii && c <= '\u007f') {
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = (byte)c;
                    continue;
                }
                if (c2 < '\u0100') {
                    if (c2 == '\u0000' && c != '\u0000' || this.convertType == 2) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = this.b2;
                    continue;
                }
                if (this.convertType == 1) {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (n4 - n3 < 2) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                byArray[n3++] = this.b1;
                byArray[n3++] = this.b2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
            byteBuffer.position(n3 - byteBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        boolean bl = false;
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                int n2 = this.index1[(c & this.mask1) >> this.shift] + (c & this.mask2);
                char c2 = n2 < 15000 ? this.index2.charAt(n2) : this.index2a.charAt(n2 - 15000);
                this.b1 = (byte)((c2 & 0xFF00) >> 8);
                this.b2 = (byte)(c2 & 0xFF);
                if (this.mapascii && c <= '\u007f') {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put((byte)c);
                } else if (c2 < '\u0100') {
                    if (c2 == '\u0000' && c != '\u0000' || this.convertType == 2) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put(this.b2);
                } else {
                    if (this.convertType == 1) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (byteBuffer.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put(this.b1);
                    byteBuffer.put(this.b2);
                }
                ++n;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

