/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.OIDMap;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;

public final class OtherName
implements GeneralNameInterface {
    private String name;
    private ObjectIdentifier oid;
    private byte[] nameValue = null;
    private GeneralNameInterface gni = null;
    private int myhash = -1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.OtherName";

    public OtherName(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "OtherName", derValue);
        }
        DerInputStream in = derValue.toDerInputStream();
        this.oid = in.getOID();
        DerValue val = in.getDerValue();
        this.nameValue = val.toByteArray();
        this.gni = this.getGNI(this.oid, this.nameValue);
        this.name = this.gni != null ? this.gni.toString() : "Unrecognized ObjectIdentifier: " + this.oid.toString();
        if (debug != null) {
            debug.exit(16384L, className, "OtherName");
        }
    }

    public OtherName(ObjectIdentifier oid, byte[] value) throws IOException {
        if (oid == null || value == null) {
            throw new NullPointerException("parameters may not be null");
        }
        this.oid = oid;
        this.nameValue = value;
        this.gni = this.getGNI(oid, value);
        this.name = this.gni != null ? this.gni.toString() : "Unrecognized ObjectIdentifier: " + oid.toString();
    }

    @Override
    public int getType() {
        if (debug != null) {
            debug.entry(16384L, className, "getType");
            debug.exit(16384L, (Object)className, "getType", 0);
        }
        return 0;
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.gni == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Unknown Other-Name: " + this.name);
            }
            DerOutputStream tmp = new DerOutputStream();
            tmp.putOID(this.oid);
            tmp.write(DerValue.createTag((byte)-128, true, (byte)0), this.nameValue);
            out.write((byte)48, tmp);
        } else {
            this.gni.encode(out);
        }
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public ObjectIdentifier getOID() {
        return this.oid;
    }

    public byte[] getNameValue() {
        return (byte[])this.nameValue.clone();
    }

    public boolean equals(Object other) {
        boolean result;
        if (this == other) {
            return true;
        }
        if (!(other instanceof OtherName)) {
            return false;
        }
        OtherName otherOther = (OtherName)other;
        if (!otherOther.oid.equals(this.oid)) {
            return false;
        }
        GeneralNameInterface otherGNI = null;
        try {
            otherGNI = this.getGNI(otherOther.oid, otherOther.nameValue);
        }
        catch (IOException ioe) {
            return false;
        }
        if (otherGNI != null) {
            try {
                result = otherGNI.constrains(this) == 0;
            }
            catch (UnsupportedOperationException ioe) {
                result = false;
            }
        } else {
            result = Arrays.equals(this.nameValue, otherOther.nameValue);
        }
        return result;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = 37 + this.oid.hashCode();
            for (int i = 0; i < this.nameValue.length; ++i) {
                this.myhash = 37 * this.myhash + this.nameValue[i];
            }
        }
        return this.myhash;
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.entry(16384L, (Object)className, "toString", "Other-Name: " + this.name);
        }
        return "Other-Name: " + this.name;
    }

    private GeneralNameInterface getGNI(ObjectIdentifier oid, byte[] nameValue) throws IOException {
        try {
            Class extClass = OIDMap.getClass(oid);
            if (extClass == null) {
                if (debug != null) {
                    debug.exit(16384L, className, "OtherName_1");
                }
                return null;
            }
            Class[] params = new Class[]{Object.class};
            Constructor cons = extClass.getConstructor(params);
            Object[] passed = new Object[]{nameValue};
            return (GeneralNameInterface)cons.newInstance(passed);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "OtherName", e);
            }
            throw (IOException)new IOException("Instantiation error: " + e).initCause(e);
        }
    }

    @Override
    public int constrains(GeneralNameInterface inputName) {
        int constraintType;
        if (inputName == null) {
            constraintType = -1;
        } else if (inputName.getType() != 0) {
            constraintType = -1;
        } else {
            throw new UnsupportedOperationException("Narrowing, widening, and matching are not supported for OtherName.");
        }
        return constraintType;
    }

    @Override
    public int subtreeDepth() {
        throw new UnsupportedOperationException("subtreeDepth() not supported for generic OtherName");
    }
}

