/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.TransformUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.crypto.NodeSetData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TreeNodeSetData
implements NodeSetData {
    public static final String NS_XML = "http://www.w3.org/XML/1998/namespace";
    public static final String NS_XMLNS = "http://www.w3.org/2000/xmlns/";
    Node top;
    boolean comments;
    Node omitted;
    List list;
    private Iterator iter = TransformUtil.EMPTY_ITERATOR;
    private boolean valid = true;

    TreeNodeSetData(Node t, boolean wc, Node o) {
        this.top = t;
        this.comments = wc;
        this.omitted = o;
        this.list = null;
    }

    public Node getTopNode() {
        return this.top;
    }

    public boolean isWithComments() {
        return this.comments;
    }

    public Node getOmittedNode() {
        return this.omitted;
    }

    public Iterator iterator() {
        if (this.list == null) {
            this.list = TreeNodeSetData.toList(this.top, this.comments, this.omitted);
        }
        return new ReadOnlyListIterator(this.list);
    }

    static List toList(Node top, boolean comments, Node omitted) {
        LinkedList result = new LinkedList();
        Map context = TransformUtil.initializeDecls(top);
        if (context.get("xmlns:xml") == null) {
            context.put("xmlns:xml", NS_XML);
        }
        TreeNodeSetData.nodeToList(context, top, comments, omitted, result);
        return result;
    }

    private static void nodeToList(Map context, Node node, boolean comments, Node omitted, List result) {
        if (node == omitted) {
            return;
        }
        switch (node.getNodeType()) {
            case 1: {
                Node attr;
                result.add(node);
                Map newContext = TransformUtil.putDecls(context, node);
                for (String declName : newContext.keySet()) {
                    attr = ((Element)node).getAttributeNode(declName);
                    if (attr == null) {
                        attr = new TransformUtil.AttrProxy(node, node.getOwnerDocument(), NS_XMLNS, declName, (String)newContext.get(declName));
                    }
                    result.add(attr);
                }
                NamedNodeMap map = node.getAttributes();
                for (int i = 0; i < map.getLength(); ++i) {
                    attr = map.item(i);
                    if (attr.getNodeName().equals("xmlns") || attr.getNodeName().startsWith("xmlns:")) continue;
                    result.add(attr);
                }
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    TreeNodeSetData.nodeToList(newContext, child, comments, omitted, result);
                }
                break;
            }
            case 5: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    TreeNodeSetData.nodeToList(context, child, comments, omitted, result);
                }
                break;
            }
            case 8: {
                if (!comments) break;
                result.add(node);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                result.add(node);
                break;
            }
            case 9: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    TreeNodeSetData.nodeToList(context, child, comments, omitted, result);
                }
                break;
            }
            case 10: {
                break;
            }
            case 6: 
            case 11: 
            case 12: {
                throw new RuntimeException("Internal Error: Invalid node type: " + node.getNodeType());
            }
        }
    }

    static class ReadOnlyListIterator
    implements Iterator {
        private int current;
        private int size;
        private List list;

        ReadOnlyListIterator(List l) {
            this.list = l;
            this.size = this.list.size();
            this.current = 0;
        }

        public boolean hasNext() {
            return this.current < this.size;
        }

        public Object next() throws NoSuchElementException {
            if (this.current >= this.size) {
                throw new NoSuchElementException("Current index=" + this.current);
            }
            return this.list.get(this.current++);
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove() is not supported.");
        }
    }
}

