/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.BytecodeGenerator;
import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureHeader;
import com.ibm.j9ddr.exceptions.CorruptStructuresException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureReader {
    public static final int VERSION = 2;
    private HashMap<String, StructureDescriptor> structures = null;
    private String[] packages;
    private static final Logger logger = Logger.getLogger("j9ddr.structure_reader");
    private StructureHeader header;
    private byte sizeofBool;
    private byte sizeofUDATA;
    private byte bitfieldFormat;
    private byte unused;
    public static final Class<?>[] STRUCTURE_CONSTRUCTOR_SIGNATURE = new Class[]{Long.TYPE};
    public static final byte BIT_FIELD_FORMAT_LITTLE_ENDIAN = 1;
    public static final byte BIT_FIELD_FORMAT_BIG_ENDIAN = 2;
    public static final int BIT_FIELD_CELL_SIZE = 32;
    public static final String ALIAS_MAP_RESOURCE = "com/ibm/j9ddr/StructureAliases%d.dat";
    private static final Pattern MULTI_LINE_COMMENT_PATTERN = Pattern.compile(Pattern.quote("/*") + ".*?" + Pattern.quote("*/"), 32);
    private static final Pattern SINGLE_LINE_COMMENT_PATTERN = Pattern.compile(Pattern.quote("//") + ".*$", 8);
    private static final Pattern MAP_PATTERN = Pattern.compile("(.*?)=(.*?)$", 8);
    private static final String DEFAULT_DOT_PACKAGE_PREFIX = "com.ibm.j9ddr.";
    private static final String DEFAULT_ALIAS_PREFIX = "com/ibm/j9ddr/StructureAliases";
    private Map<String, String> aliasMap;
    private long packageVersion;
    private String basePackage;
    private static final Pattern CONTENTS_OF_ARRAY_PATTERN = Pattern.compile("(?<=\\[).*?(?=\\])");
    private static final Pattern SPACES_AFTER_SQUARE_BRACKETS_PATTERN = Pattern.compile("(?<=\\])\\s+");
    private static final Pattern SPACES_BEFORE_SQUARE_BRACKETS_PATTERN = Pattern.compile("\\s+(?=\\[)");
    private static final Pattern SPACES_AFTER_ASTERISKS_PATTERN = Pattern.compile("(?<=\\*)\\s+");
    private static final Pattern SPACES_BEFORE_ASTERISKS_PATTERN = Pattern.compile("\\s+(?=\\*)");
    private static final String VM_MAJOR_VERSION = "VM_MAJOR_VERSION";
    private static final String VM_MINOR_VERSION = "VM_MINOR_VERSION";
    private static final String DDRALGORITHM_STRUCTURE_NAME = "DDRAlgorithmVersions";
    public static final String DDR_VERSIONED_PACKAGE_PREFIX = "com.ibm.j9ddr.vm";

    public StructureReader(ImageInputStream in) throws IOException {
        this.parse(in);
        this.setStream();
        this.applyAliases();
    }

    public StructureReader(InputStream in) throws IOException {
        this.parse(in);
        this.setStream();
    }

    public StructureHeader getHeader() {
        return this.header;
    }

    private void setStream() {
        this.setPackageVersion();
        this.packages = new String[4];
        this.basePackage = DEFAULT_DOT_PACKAGE_PREFIX + this.header.getPackageID();
        String packageID = String.format(this.basePackage + "%2d", this.packageVersion);
        this.packages[PackageNameType.STRUCTURE_PACKAGE_SLASH_NAME.ordinal()] = packageID.replace('.', '/') + "/structure/";
        this.packages[PackageNameType.STRUCTURE_PACKAGE_DOT_NAME.ordinal()] = packageID + ".structure";
        this.packages[PackageNameType.PACKAGE_DOT_BASE_NAME.ordinal()] = packageID;
        this.packages[PackageNameType.POINTER_PACKAGE_DOT_NAME.ordinal()] = packageID + ".pointer.generated";
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    private void setPackageVersion() {
        if (this.header.getCoreVersion() >= 2) {
            this.packageVersion = this.header.getBlobVersion();
            return;
        }
        StructureDescriptor version = this.structures.get(DDRALGORITHM_STRUCTURE_NAME);
        long vmMajorVersion = 2L;
        long vmMinorVersion = 30L;
        if (version != null) {
            for (ConstantDescriptor constant : version.getConstants()) {
                if (constant.getName().equals(VM_MAJOR_VERSION)) {
                    vmMajorVersion = constant.getValue();
                }
                if (!constant.getName().equals(VM_MINOR_VERSION)) continue;
                vmMinorVersion = constant.getValue();
            }
        }
        this.packageVersion = vmMajorVersion * 10L + vmMinorVersion / 10L;
        this.packages = new String[4];
        this.packages[PackageNameType.STRUCTURE_PACKAGE_SLASH_NAME.ordinal()] = String.format("com/ibm/j9ddr/vm%2d/structure/", this.packageVersion);
        this.packages[PackageNameType.STRUCTURE_PACKAGE_DOT_NAME.ordinal()] = String.format("com.ibm.j9ddr.vm%2d.structure", this.packageVersion);
        this.packages[PackageNameType.PACKAGE_DOT_BASE_NAME.ordinal()] = String.format("com.ibm.j9ddr.vm%2d", this.packageVersion);
        this.packages[PackageNameType.POINTER_PACKAGE_DOT_NAME.ordinal()] = String.format("com.ibm.j9ddr.vm%2d.pointer.generated", this.packageVersion);
    }

    public String getPackageName(PackageNameType type) {
        if (this.packages == null) {
            throw new IllegalStateException("The DDR version information is not yet available");
        }
        return this.packages[type.ordinal()];
    }

    private void applyAliases() throws IOException {
        String aliasID = null;
        switch (this.header.getCoreVersion()) {
            case 1: {
                aliasID = String.format("%d", this.packageVersion);
                break;
            }
            default: {
                String name = Character.toUpperCase(this.header.getPackageID().charAt(0)) + this.header.getPackageID().substring(1);
                aliasID = String.format(name + "%d", this.header.getBlobVersion());
            }
        }
        this.aliasMap = StructureReader.loadAliasMap(aliasID);
        this.applyAliases(this.aliasMap);
    }

    public void applyAliases(Map<String, String> map) {
        for (StructureDescriptor thisStruct : this.structures.values()) {
            for (FieldDescriptor thisField : thisStruct.fields) {
                thisField.applyAliases(map);
            }
        }
    }

    public static Map<String, String> loadAliasMap(String aliasID) throws IOException {
        String mapData = StructureReader.loadAliasMapData(DEFAULT_ALIAS_PREFIX + aliasID + ".dat");
        mapData = StructureReader.stripComments(mapData);
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        Matcher mapMatcher = MAP_PATTERN.matcher(mapData);
        while (mapMatcher.find()) {
            String from = mapMatcher.group(1);
            String to = mapMatcher.group(2);
            aliasMap.put(from.trim(), to.trim());
        }
        return Collections.unmodifiableMap(aliasMap);
    }

    public static Map<String, String> loadAliasMap(long version) throws IOException {
        String aliasID = String.format("%d", version);
        return StructureReader.loadAliasMap(aliasID);
    }

    private static String stripComments(String mapData) {
        mapData = MULTI_LINE_COMMENT_PATTERN.matcher(mapData).replaceAll("");
        mapData = SINGLE_LINE_COMMENT_PATTERN.matcher(mapData).replaceAll("");
        return mapData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadAliasMapData(String streamAliasMapResource) throws IOException {
        InputStream is = StructureReader.class.getClassLoader().getResourceAsStream(streamAliasMapResource);
        if (null == is) {
            throw new RuntimeException("Failed to load alias map from resource: " + streamAliasMapResource + " - cannot continue");
        }
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        try {
            int read;
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[4096];
            while ((read = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, read);
            }
            String string = builder.toString();
            return string;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public Set<String> getStructureNames() {
        return this.structures.keySet();
    }

    public boolean hasStructure(String name) {
        return this.structures.containsKey(name);
    }

    public int getStructureSizeOf(String structureName) {
        if (!this.hasStructure(structureName)) {
            return 0;
        }
        return this.structures.get(structureName).getSizeOf();
    }

    public Collection<StructureDescriptor> getStructures() {
        return this.structures.values();
    }

    public ArrayList<FieldDescriptor> getFields(String structureName) {
        StructureDescriptor structure = this.structures.get(structureName);
        if (structure == null) {
            throw new IllegalArgumentException("The structure [" + structureName + "] was not found");
        }
        return structure.fields;
    }

    public ArrayList<ConstantDescriptor> getConstants(String structureName) {
        StructureDescriptor structure = this.structures.get(structureName);
        if (structure == null) {
            throw new IllegalArgumentException("The structure [" + structureName + "] was not found");
        }
        return structure.constants;
    }

    private void parse(InputStream inputStream) throws IOException {
        this.header = new StructureHeader(inputStream);
        this.structures = new LinkedHashMap<String, StructureDescriptor>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = reader.readLine();
        StructureDescriptor structure = null;
        while (line != null) {
            char type = line.charAt(0);
            switch (type) {
                case 'S': {
                    structure = new StructureDescriptor(line);
                    this.structures.put(structure.getName(), structure);
                    break;
                }
                case 'F': {
                    Collection<FieldDescriptor> fields = FieldDescriptor.inflate(line);
                    structure.fields.addAll(fields);
                    break;
                }
                case 'C': {
                    ConstantDescriptor constant = new ConstantDescriptor(line);
                    structure.constants.add(constant);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Superset stream contained unknown line: %s", line));
                }
            }
            line = reader.readLine();
        }
    }

    public void addStructures(ImageInputStream ddrStream) throws IOException {
        StructureHeader fragmentHeader = new StructureHeader(ddrStream);
        this.checkBlobVersion();
        if (this.header.getSizeofBool() != fragmentHeader.getSizeofBool()) {
            throw new IOException("Invalid fragment definition : size of boolean is not the same");
        }
        if (this.header.getSizeofUDATA() != this.header.getSizeofUDATA()) {
            throw new IOException("Invalid fragment definition : size of UDATA is not the same");
        }
        this.parseStructures(ddrStream, fragmentHeader);
    }

    private void parse(ImageInputStream ddrStream) throws IOException {
        logger.logp(Level.FINE, null, null, "Parsing structures. Start address = {0}", Long.toHexString(ddrStream.getStreamPosition()));
        this.header = new StructureHeader(ddrStream);
        this.checkBlobVersion();
        this.parseStructures(ddrStream, this.header);
    }

    private void checkBlobVersion() throws IOException {
        logger.logp(Level.FINE, null, null, "Stream core structure version = {0}", this.header.getCoreVersion());
        if (this.header.getCoreVersion() > 2) {
            throw new CorruptStructuresException("Core structure version " + this.header.getCoreVersion() + " != StructureReader version " + 2);
        }
    }

    private void parseStructures(ImageInputStream ddrStream, StructureHeader header) throws IOException {
        logger.logp(Level.FINER, (String)null, (String)null, "structDataSize={0}, stringTableDataSize={1}, structureCount={2}", new Object[]{header.getStructDataSize(), header.getStringTableDataSize(), header.getStructureCount()});
        long ddrStringTableStart = ddrStream.getStreamPosition() + (long)header.getStructDataSize();
        logger.logp(Level.FINER, null, null, "ddrStringTableStart=0x{0}", Long.toHexString(ddrStringTableStart));
        if (this.structures == null) {
            this.structures = new HashMap(header.getStructureCount());
        }
        for (int i = 0; i < header.getStructureCount(); ++i) {
            int j;
            logger.logp(Level.FINER, null, null, "Reading structure on iteration {0}", i);
            StructureDescriptor structure = new StructureDescriptor();
            structure.name = this.readString(ddrStream, ddrStringTableStart);
            if (structure.name == "") {
                logger.logp(Level.FINE, null, null, "Structure name was blank for structure {0}", i);
                throw new IllegalArgumentException(String.format("No structure name found for structure %d", i));
            }
            if (structure.name == null) {
                logger.logp(Level.FINE, null, null, "Structure name was null for structure {0}", i);
                throw new IllegalArgumentException(String.format("Structure name was null for structure %d", i));
            }
            logger.logp(Level.FINE, null, null, "Reading structure {0}", structure.name);
            structure.pointerName = structure.name + "Pointer";
            structure.superName = this.readString(ddrStream, ddrStringTableStart);
            structure.sizeOf = ddrStream.readInt();
            int numberOfFields = ddrStream.readInt();
            structure.fields = new ArrayList(numberOfFields);
            int numberOfConstants = ddrStream.readInt();
            structure.constants = new ArrayList(numberOfConstants);
            logger.logp(Level.FINER, (String)null, (String)null, "{0} super {1} sizeOf {2}", new Object[]{structure.name, structure.superName, structure.sizeOf});
            for (j = 0; j < numberOfFields; ++j) {
                String declaredName = this.readString(ddrStream, ddrStringTableStart);
                String name = declaredName.replace(".", "$");
                String declaredType = this.readString(ddrStream, ddrStringTableStart);
                if (name.equals("hashCode")) {
                    name = "_hashCode";
                }
                int offset = ddrStream.readInt();
                FieldDescriptor field = new FieldDescriptor(offset, declaredType, declaredType, name, declaredName);
                structure.fields.add(field);
                logger.logp(Level.FINEST, (String)null, (String)null, "Field: {0}.{1} offset {2}, declaredType {3}", new Object[]{structure.name, name, offset, declaredType, declaredType});
            }
            for (j = 0; j < numberOfConstants; ++j) {
                String name = this.readString(ddrStream, ddrStringTableStart);
                long value = ddrStream.readLong();
                ConstantDescriptor constant = new ConstantDescriptor(name, value);
                structure.constants.add(constant);
                logger.logp(Level.FINEST, (String)null, (String)null, "Constant: {0}.{1}={2}", new Object[]{structure.name, name, value});
            }
            this.structures.put(structure.name, structure);
        }
        logger.logp(Level.FINE, null, null, "Finished parsing structures");
    }

    private String readString(ImageInputStream ddrStream, long ddrStringTableStart) {
        try {
            int stringOffset = ddrStream.readInt();
            if (stringOffset == -1) {
                return "";
            }
            long pos = ddrStream.getStreamPosition();
            long seekPos = ddrStringTableStart + (long)stringOffset;
            ddrStream.seek(seekPos);
            int length = ddrStream.readUnsignedShort();
            byte[] buffer = new byte[length];
            int read = ddrStream.read(buffer);
            if (read != length) {
                throw new IOException("StructureReader readString() Failed to read " + length + " at " + Long.toHexString(seekPos) + ". Result: " + read);
            }
            String result = new String(buffer, "UTF-8");
            ddrStream.seek(pos);
            return result;
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            logger.logp(Level.FINE, null, null, sw.toString());
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getClassBytes(String clazzName) throws ClassNotFoundException {
        int baseLen = this.getPackageName(PackageNameType.STRUCTURE_PACKAGE_SLASH_NAME).length();
        if (baseLen >= clazzName.length()) {
            throw new ClassNotFoundException(String.format("%s is not in core file.", clazzName));
        }
        String structureName = clazzName.substring(baseLen);
        structureName = structureName.replace(".", "__A");
        switch (this.header.getCoreVersion()) {
            case 1: {
                structureName = structureName.replace("$", "__");
                break;
            }
            case 2: {
                structureName = structureName.replace("$", "__A");
                break;
            }
        }
        StructureDescriptor structure = this.structures.get(structureName);
        if (structure == null) {
            throw new ClassNotFoundException(String.format("%s is not in core file.", clazzName));
        }
        return BytecodeGenerator.getClassBytes(structure, clazzName.replace('.', '/'));
    }

    public long getConstantValue(String structureName, String constantName, long defaultValue) {
        if (constantName.equals("SIZEOF")) {
            return this.getStructureSizeOf(structureName);
        }
        for (ConstantDescriptor constant : this.getConstants(structureName)) {
            if (!constant.getName().equals(constantName)) continue;
            return constant.getValue();
        }
        return defaultValue;
    }

    public boolean getBuildFlagValue(String structureName, String constantName, boolean defaultValue) {
        long value;
        long defaultLongValue = 0L;
        if (defaultValue) {
            defaultLongValue = 1L;
        }
        return (value = this.getConstantValue(structureName, constantName, defaultLongValue)) != 0L;
    }

    public byte getSizeOfBool() {
        return this.header.getSizeofBool();
    }

    public byte getSizeOfUDATA() {
        return this.header.getSizeofUDATA();
    }

    public byte getBitFieldFormat() {
        return this.header.getBitfieldFormat();
    }

    public static String simplifyType(String type) {
        String working = type;
        working = StructureReader.filterOutPattern(working, CONTENTS_OF_ARRAY_PATTERN);
        working = StructureReader.filterOutPattern(working, SPACES_BEFORE_SQUARE_BRACKETS_PATTERN);
        working = StructureReader.filterOutPattern(working, SPACES_AFTER_SQUARE_BRACKETS_PATTERN);
        working = StructureReader.filterOutPattern(working, SPACES_BEFORE_ASTERISKS_PATTERN);
        working = StructureReader.filterOutPattern(working, SPACES_AFTER_ASTERISKS_PATTERN);
        return working;
    }

    private static String filterOutPattern(String input, Pattern p) {
        Matcher m = p.matcher(input);
        if (m.find()) {
            return m.replaceAll("");
        }
        return input;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstantDescriptor
    implements Comparable<ConstantDescriptor> {
        String name;
        long value;

        public ConstantDescriptor(String name, long value) {
            this.name = name;
            this.value = value;
        }

        public ConstantDescriptor(String line) {
            this.inflate(line);
        }

        public String toString() {
            return this.name + " = " + this.value;
        }

        public String getName() {
            return this.name;
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public int compareTo(ConstantDescriptor o) {
            return this.getName().compareTo(o.getName());
        }

        private void inflate(String line) {
            String[] parts = line.split("\\|");
            if (parts.length != 2) {
                throw new IllegalArgumentException(String.format("Superset file line is invalid: %s", line));
            }
            this.name = parts[1];
        }

        public String deflate() {
            return "C|" + this.getName();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ConstantDescriptor)) {
                return false;
            }
            ConstantDescriptor compareTo = (ConstantDescriptor)obj;
            return this.name.equals(compareTo.name) && this.value == compareTo.value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldDescriptor
    implements Comparable<FieldDescriptor> {
        String type;
        String declaredType;
        String name;
        String declaredName;
        int offset;

        public FieldDescriptor(int offset, String type, String declaredType, String name, String declaredName) {
            this.type = type;
            this.declaredType = declaredType;
            this.name = name;
            this.offset = offset;
            this.declaredName = declaredName;
        }

        public void applyAliases(Map<String, String> aliasMap) {
            this.type = this.unalias(this.declaredType, aliasMap);
            this.cleanUpTypes();
        }

        public void cleanUpTypes() {
            this.type = this.stripUnderscore(this.type);
            this.type = this.stripTypeQualifiers(this.type);
            this.declaredType = this.stripUnderscore(this.declaredType);
        }

        private String stripTypeQualifiers(String type) {
            String working = type.replaceAll("const", "");
            working = working.replaceAll("volatile", "");
            return working.trim();
        }

        private String stripUnderscore(String type) {
            return type.replaceAll("U_(?=\\d+|DATA)", "U").replaceAll("I_(?=\\d+|DATA)", "I");
        }

        private String unalias(String type, Map<String, String> aliasMap) {
            CTypeParser parser = CTypeParser.fromNative(type);
            String result = parser.getCoreType();
            if (aliasMap.containsKey(result)) {
                result = aliasMap.get(result);
            }
            return parser.getPrefix() + result + parser.getSuffix();
        }

        public String getName() {
            return this.name;
        }

        public String getDeclaredName() {
            return this.declaredName;
        }

        public String getType() {
            return this.type;
        }

        public String getDeclaredType() {
            return this.declaredType;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.type + " " + this.name + " Offset: " + this.offset;
        }

        @Override
        public int compareTo(FieldDescriptor o) {
            return this.getName().compareTo(o.getName());
        }

        public static Collection<FieldDescriptor> inflate(String line) {
            String[] parts = line.split("\\|");
            if (parts.length < 5 || (parts.length - 3) % 2 != 0) {
                throw new IllegalArgumentException(String.format("Superset file line is invalid: %s", line));
            }
            int count = (parts.length - 3) / 2;
            ArrayList<FieldDescriptor> result = new ArrayList<FieldDescriptor>(count);
            String declaredName = parts[2];
            for (int i = 0; i < count; ++i) {
                String fieldName = parts[1];
                if (i > 0) {
                    fieldName = fieldName + "_v" + i;
                }
                FieldDescriptor fd = new FieldDescriptor(0, parts[3 + i * 2], parts[4 + i * 2], fieldName, declaredName);
                result.add(fd);
            }
            return result;
        }

        public String deflate() {
            StringBuffer result = new StringBuffer();
            result.append("F|");
            result.append(this.getName());
            result.append("|");
            result.append(this.getDeclaredName());
            result.append("|");
            result.append(StructureReader.simplifyType(this.getType()));
            result.append("|");
            result.append(StructureReader.simplifyType(this.getDeclaredType()));
            return result.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof FieldDescriptor)) {
                return false;
            }
            FieldDescriptor compareTo = (FieldDescriptor)obj;
            return compareTo.deflate().equals(this.deflate());
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PackageNameType {
        STRUCTURE_PACKAGE_SLASH_NAME,
        STRUCTURE_PACKAGE_DOT_NAME,
        PACKAGE_DOT_BASE_NAME,
        POINTER_PACKAGE_DOT_NAME;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StructureDescriptor {
        String name;
        String superName;
        String pointerName;
        int sizeOf;
        ArrayList<FieldDescriptor> fields;
        ArrayList<ConstantDescriptor> constants;

        public StructureDescriptor() {
        }

        public StructureDescriptor(String line) {
            this.inflate(line);
        }

        public String toString() {
            return this.name + " extends " + this.superName;
        }

        public String getPointerName() {
            return this.name + "Pointer";
        }

        public String getName() {
            return this.name;
        }

        public String getSuperName() {
            return this.superName;
        }

        public ArrayList<FieldDescriptor> getFields() {
            return this.fields;
        }

        public ArrayList<ConstantDescriptor> getConstants() {
            return this.constants;
        }

        public int getSizeOf() {
            return this.sizeOf;
        }

        private void inflate(String line) {
            String[] parts = line.split("\\|");
            if (parts.length < 3 || parts.length > 4) {
                throw new IllegalArgumentException(String.format("Superset file line is invalid: %s", line));
            }
            this.constants = new ArrayList();
            this.fields = new ArrayList();
            this.name = parts[1];
            this.pointerName = parts[2];
            this.superName = parts.length == 4 ? parts[3] : "";
        }

        public String deflate() {
            StringBuffer result = new StringBuffer();
            result.append("S|");
            result.append(this.getName());
            result.append("|");
            result.append(this.getPointerName());
            result.append("|");
            result.append(this.getSuperName());
            return result.toString();
        }

        public boolean equals(Object o) {
            if (this.name == null) {
                return false;
            }
            if (o == null || !(o instanceof StructureDescriptor)) {
                return false;
            }
            return this.deflate().equals(((StructureDescriptor)o).deflate());
        }

        public int hashCode() {
            return this.name == null ? super.hashCode() : this.name.hashCode();
        }
    }
}

