/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.debugger;

import com.ibm.j9ddr.corereaders.debugger.JniMemory;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.io.IOException;
import javax.imageio.stream.ImageInputStreamImpl;

public class JniImageInputStream
extends ImageInputStreamImpl {
    private final JniMemory memory;

    public JniImageInputStream(JniMemory memory) {
        this.memory = memory;
    }

    public int read() throws IOException {
        try {
            byte readAddress = this.memory.getByteAt(this.streamPos);
            ++this.streamPos;
            return readAddress;
        }
        catch (MemoryFault e) {
            throw new IOException(e.getMessage() + ":" + e.getAddress());
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.memory.getBytesAt(this.streamPos, b, off, len);
        }
        catch (MemoryFault e) {
            throw new IOException(e.getMessage() + ":" + e.getAddress());
        }
    }
}

