/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELFIA32DumpReader
extends ELFDumpReader {
    ELFIA32DumpReader(ELFFileReader reader) throws IOException, InvalidDumpFormatException {
        super(reader);
    }

    @Override
    protected long readUID() throws IOException {
        return (long)this._reader.readShort() & 0xFFFFL;
    }

    @Override
    protected String getProcessorType() {
        return "x86";
    }

    @Override
    protected long getBasePointerFrom(Map<String, Number> registers) {
        return registers.get("ebp").longValue();
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> registers) {
        return registers.get("eip").longValue();
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> registers) {
        return 0L;
    }

    @Override
    protected String getStackPointerRegisterName() {
        return "esp";
    }

    @Override
    protected SortedMap<String, Number> readRegisters() throws IOException {
        int i;
        String[] names1 = new String[]{"ebx", "ecx", "edx", "esi", "edi", "ebp", "eax", "ds", "es", "fs", "gs"};
        String[] names2 = new String[]{"eip", "cs", "efl", "esp", "ss"};
        TreeMap<String, Number> registers = new TreeMap<String, Number>(new ELFDumpReader.RegisterComparator());
        for (i = 0; i < names1.length; ++i) {
            registers.put(names1[i], (long)this._reader.readInt() & 0xFFFFFFFFL);
        }
        this._reader.readInt();
        for (i = 0; i < names2.length; ++i) {
            registers.put(names2[i], (long)this._reader.readInt() & 0xFFFFFFFFL);
        }
        return registers;
    }

    @Override
    protected String[] getDwarfRegisterKeys() {
        String[] registersVals = new String[]{"eax", "ecx", "edx", "ebx", "esp", "ebp", "esi", "edi", "eip", "eflags", "cs", "ss", "ds", "es", "fs", "gs"};
        return registersVals;
    }

    @Override
    protected void readHighwordRegisters(DataEntry entry, Map<String, Number> registers) throws IOException, InvalidDumpFormatException {
        throw new InvalidDumpFormatException("Unexpected data entry in IA32 ELF dump");
    }
}

