/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseModule
implements IModule {
    protected final String name;
    protected final Collection<? extends IMemoryRange> memoryRanges;
    protected final IProcess process;
    protected final long loadAddress;

    public BaseModule(IProcess process, String name, Collection<? extends IMemoryRange> memoryRanges, long loadAddress) {
        this.name = name;
        this.memoryRanges = Collections.unmodifiableCollection(memoryRanges);
        this.process = process;
        this.loadAddress = loadAddress;
    }

    @Override
    public Collection<? extends IMemoryRange> getMemoryRanges() {
        return this.memoryRanges;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.memoryRanges == null ? 0 : ((Object)this.memoryRanges).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.process == null ? 0 : this.process.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseModule)) {
            return false;
        }
        BaseModule other = (BaseModule)obj;
        if (this.memoryRanges == null ? other.memoryRanges != null : !((Object)this.memoryRanges).equals(other.memoryRanges)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.process == null ? other.process != null : !this.process.equals(other.process));
    }

    @Override
    public long getLoadAddress() {
        return this.loadAddress;
    }
}

