/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IMemory;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SearchableMemory
implements IMemory {
    static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    static final int BUFFER_MAX = 4096;
    static final int MINIMUM_PAGE_SIZE = 4096;
    protected long[][] rangeTable = null;
    private int mergedRanges = -1;

    private static int match(byte[] whatBytes, int matchedSoFar, byte[] buffer, int index) {
        int matched = matchedSoFar;
        for (int i = index; i < buffer.length && matched < whatBytes.length; ++i, ++matched) {
            if (buffer[i] == whatBytes[matched]) continue;
            return 0;
        }
        return matched;
    }

    public long findPattern(byte[] whatBytes, int alignment, long startFrom) {
        int align = 0 == alignment ? 1 : alignment;
        logger.logp(Level.FINE, "AbstractMemory", "findPattern", "called with {0}, alignment {1}, startFrom, {2}", new Object[]{whatBytes, alignment, Long.toHexString(startFrom)});
        int bufferMax = 4096;
        if (bufferMax < align) {
            bufferMax = align;
        } else if (0 != bufferMax % align) {
            bufferMax -= bufferMax % align;
        }
        long location = -1L;
        if (this.rangeTable == null) {
            this.rangeTable = this.buildRangeTable();
            logger.logp(Level.FINER, "AbstractMemory", "findPattern", "rangeTable contains {0} elements", this.rangeTable.length);
            this.mergedRanges = this.mergeRangeTable(this.rangeTable);
            logger.logp(Level.FINER, "AbstractMemory", "findPattern", "mergedRanges contains {0} elements", this.mergedRanges);
        }
        for (int i = 0; i < this.mergedRanges; ++i) {
            long base = this.rangeTable[i][0];
            long size = this.rangeTable[i][1];
            long top = base + size - 1L;
            if (top <= startFrom || -1L == (location = this.findPatternInRange(whatBytes, align, startFrom, base, size, bufferMax))) continue;
            logger.logp(Level.FINE, null, null, "Pattern matched at {0}", Long.toHexString(location));
            break;
        }
        if (-1L == location) {
            logger.logp(Level.FINE, null, null, "Pattern didn't match");
        }
        return location;
    }

    protected int mergeRangeTable(long[][] rangeTable) {
        int writePointer = 0;
        for (int readPointer = 1; readPointer < rangeTable.length; ++readPointer) {
            if (rangeTable[readPointer][0] == rangeTable[writePointer][0] + rangeTable[writePointer][1]) {
                long[] lArray = rangeTable[writePointer];
                lArray[1] = lArray[1] + rangeTable[readPointer][1];
                continue;
            }
            rangeTable[++writePointer][0] = rangeTable[readPointer][0];
            rangeTable[writePointer][1] = rangeTable[readPointer][1];
        }
        return writePointer + 1;
    }

    protected long[][] buildRangeTable() {
        ArrayList<? extends IMemoryRange> ranges = new ArrayList<IMemoryRange>(this.getMemoryRanges());
        Collections.sort(ranges);
        long[][] toReturn = new long[ranges.size()][2];
        int index = 0;
        for (IMemoryRange iMemoryRange : ranges) {
            if (!iMemoryRange.isBacked()) continue;
            toReturn[index][0] = iMemoryRange.getBaseAddress();
            toReturn[index][1] = iMemoryRange.getSize();
            ++index;
        }
        return toReturn;
    }

    private long findPatternInRange(byte[] whatBytes, int alignment, long start, long searchRangeBase, long searchRangeSize, int bufferMax) {
        long addr = start;
        if (addr < searchRangeBase) {
            addr = searchRangeBase;
        }
        if (0L != addr % (long)alignment) {
            addr += (long)alignment - addr % (long)alignment;
        }
        long edge = searchRangeBase + searchRangeSize;
        int matched = 0;
        long matchAddr = -1L;
        while (addr < edge) {
            long bytesLeftInRange = edge - addr;
            long count = (long)bufferMax < bytesLeftInRange ? (long)bufferMax : bytesLeftInRange;
            byte[] buffer = new byte[(int)count];
            try {
                this.getBytesAt(addr, buffer);
            }
            catch (MemoryFault ex) {
                if (Addresses.greaterThan(ex.getAddress(), addr)) {
                    count = ex.getAddress() - addr;
                    buffer = new byte[(int)count];
                    try {
                        this.getBytesAt(addr, buffer);
                    }
                    catch (MemoryFault e) {
                        logger.log(Level.WARNING, "J9DDR findPattern algorithm broken. Double memory fault in findPatternInRange. addr={0}, count={1}", new Object[]{addr, count});
                        addr += count;
                        continue;
                    }
                }
                addr = this.findNextGoodAddress(addr, edge);
                continue;
            }
            if (null != buffer) {
                if (0 != matched) {
                    matched = SearchableMemory.match(whatBytes, matched, buffer, 0);
                }
                for (int i = 0; i < buffer.length && 0 == matched; i += alignment) {
                    matchAddr = addr + (long)i;
                    matched = SearchableMemory.match(whatBytes, 0, buffer, i);
                }
                if (whatBytes.length == matched) {
                    return matchAddr;
                }
            }
            addr += count;
        }
        return -1L;
    }

    private long findNextGoodAddress(long addr, long edge) {
        long pageBoundary = addr - addr % 4096L;
        for (long pointer = pageBoundary + 4096L; pointer < edge; pointer += 4096L) {
            try {
                this.getByteAt(pointer);
                return pointer;
            }
            catch (MemoryFault ex) {
                continue;
            }
        }
        return edge;
    }
}

