/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.IDetailedMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.ProtectedMemoryRange;
import java.util.Properties;

public class UnbackedMemorySource
extends ProtectedMemoryRange
implements IMemorySource,
IDetailedMemoryRange {
    private final int addressSpaceId;
    private final String explanation;
    private final String name;
    private Properties props;

    public UnbackedMemorySource(long base, long size, String explanation, int asid, String name) {
        super(base, size);
        this.explanation = explanation;
        this.addressSpaceId = asid;
        this.name = name;
    }

    public UnbackedMemorySource(long base, long size, String explanation) {
        this(base, size, explanation, 0, null);
    }

    public int getAddressSpaceId() {
        return this.addressSpaceId;
    }

    public int getBytes(long address, byte[] buffer, int offset, int length) throws MemoryFault {
        throw new MemoryFault(address, this.explanation + "; range: " + Long.toHexString(address) + " size: " + Long.toHexString(this.getSize()));
    }

    public String getName() {
        return this.name;
    }

    public boolean isBacked() {
        return false;
    }

    public Properties getProperties() {
        if (this.props == null) {
            this.props = new Properties();
        }
        return this.props;
    }

    public boolean isExecutable() {
        if (this.props == null) {
            return false;
        }
        return Boolean.TRUE.toString().equals(this.props.get("executable"));
    }

    public boolean isReadOnly() {
        if (this.props == null) {
            return false;
        }
        return Boolean.TRUE.toString().equals(this.props.get("readable")) && !Boolean.TRUE.toString().equals(this.props.get("writable"));
    }
}

