/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.DumpMemorySource;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.minidump.BaseWindowsOSThread;
import com.ibm.j9ddr.corereaders.minidump.LateInitializedStream;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.Register;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

class ThreadStream
extends LateInitializedStream {
    public ThreadStream(int dataSize, int location) {
        super(dataSize, location);
    }

    public void readFrom(MiniDumpReader dump, IAddressSpace addressSpace, boolean is64Bit) throws CorruptDataException, IOException {
        dump.seek(this.getLocation());
        int numberOfThreads = dump.readInt();
        if (numberOfThreads > 100000) {
            throw new CorruptDataException("Unlikely number of threads found in dump: " + numberOfThreads + ". Suspect data corruption");
        }
        for (int i = 0; i < numberOfThreads; ++i) {
            dump.seek(this.getLocation() + 4L + (long)(i * 48));
            int threadId = dump.readInt();
            dump.readInt();
            int priorityClass = dump.readInt();
            int priority = dump.readInt();
            dump.readLong();
            long stackStart = dump.readLong();
            long stackSize = 0xFFFFFFFFL & (long)dump.readInt();
            long stackRva = 0xFFFFFFFFL & (long)dump.readInt();
            dump.readInt();
            long contextRva = 0xFFFFFFFFL & (long)dump.readInt();
            Properties properties = new Properties();
            properties.setProperty("priorityClass", String.valueOf(priorityClass));
            properties.setProperty("priority", String.valueOf(priority));
            dump.addThread(new WindowsOSThread(threadId, stackStart, stackSize, stackRva, contextRva, properties, dump, (IProcess)((Object)addressSpace)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WindowsOSThread
    extends BaseWindowsOSThread {
        private final long threadId;
        private final long stackStart;
        private final long stackSize;
        private final long stackRva;
        private final long contextRva;
        private final Properties properties;
        private final MiniDumpReader reader;
        private List<IRegister> registers;

        public WindowsOSThread(int threadId, long stackStart, long stackSize, long stackRva, long contextRva, Properties properties, MiniDumpReader reader, IProcess process) {
            super(process);
            this.threadId = threadId;
            this.stackStart = stackStart;
            this.stackSize = stackSize;
            this.stackRva = stackRva;
            this.contextRva = contextRva;
            this.properties = properties;
            this.reader = reader;
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            return Collections.singletonList(new DumpMemorySource(this.stackStart, this.stackSize, this.stackRva, 0, this.reader, "Stack"));
        }

        public List<IRegister> getRegisters() {
            if (null == this.registers) {
                this.registers = new ArrayList<IRegister>();
                try {
                    switch (this.reader.getProcessorArchitecture()) {
                        case 9: {
                            this.readAmd64Registers();
                            break;
                        }
                        case 0: {
                            this.readIntelRegisters();
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown processor architecture: " + this.reader.getProcessorArchitecture());
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return Collections.unmodifiableList(this.registers);
        }

        private void readIntelRegisters() throws IOException {
            this.reader.seek(this.contextRva + 140L);
            this.registers.add(new Register("gs", this.reader.readInt()));
            this.registers.add(new Register("fs", this.reader.readInt()));
            this.registers.add(new Register("es", this.reader.readInt()));
            this.registers.add(new Register("ds", this.reader.readInt()));
            this.registers.add(new Register("edi", this.reader.readInt()));
            this.registers.add(new Register("esi", this.reader.readInt()));
            this.registers.add(new Register("ebx", this.reader.readInt()));
            this.registers.add(new Register("edx", this.reader.readInt()));
            this.registers.add(new Register("ecx", this.reader.readInt()));
            this.registers.add(new Register("eax", this.reader.readInt()));
            this.registers.add(new Register("ebp", this.reader.readInt()));
            this.registers.add(new Register("eip", this.reader.readInt()));
            this.registers.add(new Register("cs", this.reader.readInt()));
            this.registers.add(new Register("flags", this.reader.readInt()));
            this.registers.add(new Register("esp", this.reader.readInt()));
            this.registers.add(new Register("ss", this.reader.readInt()));
        }

        private void readAmd64Registers() throws IOException {
            this.reader.seek(this.contextRva + 56L);
            this.registers.add(new Register("cs", this.reader.readShort()));
            this.registers.add(new Register("ds", this.reader.readShort()));
            this.registers.add(new Register("es", this.reader.readShort()));
            this.registers.add(new Register("fs", this.reader.readShort()));
            this.registers.add(new Register("gs", this.reader.readShort()));
            this.registers.add(new Register("ss", this.reader.readShort()));
            this.registers.add(new Register("flags", this.reader.readInt()));
            this.reader.seek(this.contextRva + 120L);
            this.registers.add(new Register("rax", this.reader.readLong()));
            this.registers.add(new Register("rcx", this.reader.readLong()));
            this.registers.add(new Register("rdx", this.reader.readLong()));
            this.registers.add(new Register("rbx", this.reader.readLong()));
            this.registers.add(new Register("rsp", this.reader.readLong()));
            this.registers.add(new Register("rbp", this.reader.readLong()));
            this.registers.add(new Register("rsi", this.reader.readLong()));
            this.registers.add(new Register("rdi", this.reader.readLong()));
            this.registers.add(new Register("r8", this.reader.readLong()));
            this.registers.add(new Register("r9", this.reader.readLong()));
            this.registers.add(new Register("r10", this.reader.readLong()));
            this.registers.add(new Register("r11", this.reader.readLong()));
            this.registers.add(new Register("r12", this.reader.readLong()));
            this.registers.add(new Register("r13", this.reader.readLong()));
            this.registers.add(new Register("r14", this.reader.readLong()));
            this.registers.add(new Register("r15", this.reader.readLong()));
            this.registers.add(new Register("rip", this.reader.readLong()));
        }

        @Override
        public long getThreadId() {
            return this.threadId;
        }

        @Override
        protected long getStackEnd() {
            return this.stackStart + this.stackSize;
        }

        @Override
        protected long getStackStart() {
            return this.stackStart;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public long getInstructionPointer() {
            switch (this.reader.getProcessorArchitecture()) {
                case 9: {
                    return this.getValueOfNamedRegister(this.getRegisters(), "rip");
                }
                case 0: {
                    return this.getValueOfNamedRegister(this.getRegisters(), "eip");
                }
            }
            String msg = "Unknow processor architecture: " + this.reader.getProcessorArchitecture();
            throw new RuntimeException(msg);
        }

        @Override
        public long getBasePointer() {
            switch (this.reader.getProcessorArchitecture()) {
                case 9: {
                    return this.getValueOfNamedRegister(this.getRegisters(), "rbp");
                }
                case 0: {
                    return this.getValueOfNamedRegister(this.getRegisters(), "ebp");
                }
            }
            String msg = "Unknow processor architecture: " + this.reader.getProcessorArchitecture();
            throw new RuntimeException(msg);
        }

        @Override
        public long getStackPointer() {
            switch (this.reader.getProcessorArchitecture()) {
                case 9: {
                    return this.getValueOfNamedRegister(this.getRegisters(), "rsp");
                }
                case 0: {
                    return this.getValueOfNamedRegister(this.getRegisters(), "esp");
                }
            }
            String msg = "Unknow processor architecture: " + this.reader.getProcessorArchitecture();
            throw new RuntimeException(msg);
        }
    }
}

