/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public final class LogFormatter
extends Formatter {
    private static String nl = System.getProperty("line.separator");
    private static SimpleDateFormat format = new SimpleDateFormat("dd/MM/yy H:m:s");
    private static boolean doTimestamp = LogManager.getLogManager().getProperty("com.ibm.zebedee.timestamps") != null;

    public String format(LogRecord record) {
        StringBuffer buf = new StringBuffer();
        if (doTimestamp) {
            buf.append(format.format(new Date(record.getMillis())) + " ");
        }
        if (record.getSourceClassName() != null) {
            int index;
            String className = record.getSourceClassName();
            if (className != null && (index = className.lastIndexOf(46)) != -1) {
                className = className.substring(index + 1);
            }
            buf.append(className);
            if (record.getSourceMethodName() != null) {
                buf.append(".");
                buf.append(record.getSourceMethodName());
            }
            buf.append(": ");
        }
        buf.append(this.formatMessage(record) + nl);
        return buf.toString();
    }
}

