/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.PrimitiveArray;

public final class LongArray
extends PrimitiveArray {
    long[][] chunks;

    public LongArray() {
        this.chunks = new long[1][this.CHUNK_SIZE];
    }

    public LongArray(int length, long value) {
        this.chunks = new long[1][this.CHUNK_SIZE];
        for (int i = 0; i < length; ++i) {
            this.add(value);
        }
    }

    public Object clone() {
        LongArray clone = new LongArray();
        clone.chunks = new long[this.chunks.length][this.CHUNK_SIZE];
        for (int i = 0; i < this.chunks.length; ++i) {
            System.arraycopy(this.chunks[i], 0, clone.chunks[i], 0, this.CHUNK_SIZE);
        }
        clone.chunkOffset = this.chunkOffset;
        clone.size = this.size;
        return clone;
    }

    public long[] toArray() {
        long[] a = new long[this.size()];
        for (int i = 0; i < this.chunks.length; ++i) {
            System.arraycopy(this.chunks[i], 0, a, i << this.shift, i == this.chunks.length - 1 ? this.chunkOffset : this.CHUNK_SIZE);
        }
        return a;
    }

    public void add(long value) {
        if (this.chunkOffset >= this.CHUNK_SIZE) {
            long[][] newchunks = new long[this.chunks.length + 1][];
            for (int i = 0; i < this.chunks.length; ++i) {
                newchunks[i] = this.chunks[i];
            }
            newchunks[this.chunks.length] = new long[this.CHUNK_SIZE];
            this.chunks = newchunks;
            this.chunkOffset = 0;
        }
        this.chunks[this.chunks.length - 1][this.chunkOffset++] = value;
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    long lget(int index) {
        if (index >= this.size) {
            throw new Error("Attempt to get " + index + " greater than size " + this.size);
        }
        return this.chunks[index >> this.shift][index & this.mask];
    }

    public long get(int index) {
        return this.lget(index);
    }

    void lput(int index, long value) {
        if (index >= this.size) {
            throw new Error("Attempt to put " + index + " greater than size " + this.size);
        }
        this.chunks[index >> this.shift][index & this.mask] = value;
    }

    public void put(int index, long value) {
        this.lput(index, value);
    }

    public void add(int index, long value) {
        for (int i = 0; i < index + 1 - this.size; ++i) {
            this.add(0L);
        }
        this.put(index, value);
    }

    public void putAll(long value) {
        for (int i = 0; i < this.size; ++i) {
            this.put(i, value);
        }
    }

    public int memoryUsage() {
        return this.chunks.length * this.CHUNK_SIZE * 8;
    }
}

