/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.InvalidTemplateFile;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.TemplateField;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Template {
    private String templateName;
    private HashMap fieldNameTable = new HashMap();
    private ArrayList fields = new ArrayList();
    private int length;
    private static HashMap templateMap = new HashMap();
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public static Template getTemplate(String templateFileName) throws FileNotFoundException, InvalidTemplateFile {
        Template template = (Template)templateMap.get(templateFileName);
        if (template == null) {
            template = new Template(templateFileName);
            templateMap.put(templateFileName, template);
        }
        return template;
    }

    private Template(String templateFileName) throws FileNotFoundException, InvalidTemplateFile {
        InputStream is;
        log.fine("creating new template from file: " + templateFileName);
        if (templateFileName.charAt(0) == '/') {
            is = Template.class.getResourceAsStream(templateFileName);
            if (is == null) {
                throw new FileNotFoundException("getResourceAsStream failed for " + templateFileName);
            }
        } else {
            is = new FileInputStream(templateFileName);
        }
        this.create(is);
    }

    private void create(InputStream is) throws InvalidTemplateFile {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new Error("unexpected error: " + e);
        }
        ErrorHandler handler = new ErrorHandler(){

            public void error(SAXParseException e) throws SAXException {
                throw e;
            }

            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }

            public void warning(SAXParseException e) throws SAXException {
                throw e;
            }
        };
        builder.setErrorHandler(handler);
        EntityResolver resolver = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                if (systemId.equals("file://template.dtd")) {
                    InputStream is = this.getClass().getResourceAsStream("template.dtd");
                    if (is == null) {
                        throw new Error("could not load template.dtd");
                    }
                    return new InputSource(is);
                }
                return null;
            }
        };
        builder.setEntityResolver(resolver);
        Document document = null;
        try {
            document = builder.parse(is);
        }
        catch (SAXParseException e) {
            throw new InvalidTemplateFile("bad xml: " + e + " line number " + e.getLineNumber());
        }
        catch (SAXException e) {
            throw new InvalidTemplateFile("bad xml: " + e);
        }
        catch (IOException e) {
            throw new Error("unexpected error: " + e);
        }
        Element templateElement = document.getDocumentElement();
        Element rootItemElement = null;
        this.templateName = templateElement.getAttribute("name");
        log.fine("creating type " + this.templateName);
        for (Node node = templateElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            rootItemElement = (Element)node;
            break;
        }
        this.length = this.createTemplateFields(rootItemElement, "", 0) / 8;
    }

    public String templateName() {
        return this.templateName;
    }

    public TemplateField getField(String name) throws NoSuchFieldException {
        TemplateField field = (TemplateField)this.fieldNameTable.get(name);
        if (field == null) {
            throw new NoSuchFieldException("no field with name " + name + " in template " + this.templateName);
        }
        return field;
    }

    public List getFields() {
        return this.fields;
    }

    public int getOffset(String fieldName) throws NoSuchFieldException {
        return this.getField(fieldName).getOffset();
    }

    private int createTemplateFields(Element parentElement, String parentName, int bitOffset) {
        boolean isUnion = parentElement.hasAttribute("union");
        int maxLength = 0;
        for (Node node = parentElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element;
            if (node.getNodeType() != 1 || (element = (Element)node).getTagName().equals("pointer")) continue;
            String name = element.getAttribute("name");
            String fullName = parentName.length() > 0 ? parentName + "." + name : name;
            log.fine("creating field " + fullName + " at bit offset 0x" + Template.hex(bitOffset));
            TemplateField field = new TemplateField(fullName, this, element, bitOffset);
            this.fieldNameTable.put(fullName, field);
            this.fieldNameTable.put(name, field);
            this.fields.add(field);
            if (!element.getTagName().equals("array")) {
                this.createTemplateFields(element, fullName, bitOffset);
            }
            if (isUnion) {
                if (field.bitLength() <= maxLength) continue;
                maxLength = field.bitLength();
                continue;
            }
            bitOffset += field.bitLength();
        }
        return bitOffset + maxLength;
    }

    public int length() {
        return this.length;
    }

    private static String hex(long i) {
        return Long.toHexString(i);
    }

    private static String hex(int i) {
        return Integer.toHexString(i);
    }

    private static String pad(String s, int pad) {
        for (int i = s.length(); i < pad; ++i) {
            s = " " + s;
        }
        return s;
    }

    public static void main(String[] args) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(args[0]);
        }
        catch (Exception e) {
            System.err.println("Could not create output file " + args[0] + ": " + e);
            System.exit(1);
        }
        PrintStream out = new PrintStream(fos);
        for (int i = 1; i < args.length; ++i) {
            try {
                Template template = Template.getTemplate(args[i]);
                out.println("=== " + template.templateName() + " ===");
                out.println("");
                out.println("Offset  Length  Field");
                out.println("======  ======  =====");
                out.println("");
                for (TemplateField field : template.fields) {
                    String offset = Template.pad(Template.hex(field.getOffset()), 6);
                    String length = null;
                    length = field.isBitField() ? Template.pad("" + field.bitLength() + " b", 6) : Template.pad("" + field.byteLength(), 6);
                    out.println(offset + "  " + length + "  " + field.getName());
                }
                if (i >= args.length - 1) continue;
                out.println("");
                out.println("");
                continue;
            }
            catch (Exception e) {
                System.out.println("Unexpected exception: " + e);
                return;
            }
        }
    }
}

