/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureReader;
import java.io.File;
import java.util.HashMap;
import java.util.Properties;

public abstract class CodeGenerator {
    protected static final String PKG_POINTER = "pointer.generated";
    protected static final String PKG_STUB = "structure";
    protected HashMap<String, String> opts = new HashMap();
    protected StructureReader structureReader;
    protected File outputDir;
    protected Properties registry = null;

    protected JavaSourceObjectType getType(String declaration) {
        if (declaration.contains(".pointer.generated.")) {
            return JavaSourceObjectType.POINTER;
        }
        if (declaration.contains(".structure.")) {
            return JavaSourceObjectType.STUB;
        }
        return JavaSourceObjectType.OTHER;
    }

    protected class JavaSourceObject {
        private final String structureName;
        private String pkgname;
        private String name;
        private File javaFile;
        private CTypeParser.JavaType jtype;
        private JavaSourceObjectType type;

        JavaSourceObject(String structureName, JavaSourceObjectType type) {
            this.structureName = structureName;
            this.type = type;
            String basePackage = type.equals((Object)JavaSourceObjectType.STUB) ? CodeGenerator.PKG_STUB : CodeGenerator.PKG_POINTER;
            CTypeParser parser = CTypeParser.fromBlob(structureName);
            this.jtype = parser.getJavaType();
            this.javaFile = new File(CodeGenerator.this.outputDir, basePackage.replace('.', '/') + "/" + this.jtype.getPackageFragment(CTypeParser.TypeFormat.JAVA_SLASH));
            this.name = this.jtype.getName();
            if (this.jtype.hasPackageFragment()) {
                this.pkgname = this.jtype.getPackageFragment(CTypeParser.TypeFormat.JAVA_DOT);
                while (CodeGenerator.this.structureReader.getStructureNames().contains(this.jtype.getPackageFragment(CTypeParser.TypeFormat.JAVA_DOT, this.pkgname, CTypeParser.TypeFormat.BLOB))) {
                    this.name = this.javaFile.getName() + "$" + this.name;
                    this.javaFile = this.javaFile.getParentFile();
                    int pos = this.pkgname.lastIndexOf(46);
                    if (pos == -1) {
                        this.pkgname = "";
                        continue;
                    }
                    this.pkgname = this.pkgname.substring(0, pos);
                }
                this.pkgname = CodeGenerator.this.opts.get("-p") + "." + basePackage + "." + this.pkgname;
            } else {
                this.pkgname = CodeGenerator.this.opts.get("-p") + "." + basePackage;
            }
        }

        public String getPackageName() {
            return this.pkgname;
        }

        public String getClassName() {
            return this.name;
        }

        public String getFullClassName() {
            return this.getPackageName() + "." + this.getClassName();
        }

        public File getFile() {
            if (!this.javaFile.exists()) {
                this.javaFile.mkdirs();
            }
            if (CodeGenerator.this.registry != null) {
                throw new UnsupportedOperationException("Code generation from a template registry is not yet supported");
            }
            this.javaFile = new File(this.javaFile, this.getClassName() + ".java");
            return this.javaFile;
        }

        public CTypeParser.JavaType getType() {
            return this.jtype;
        }

        public String getStructureName() {
            return this.structureName;
        }

        public JavaSourceObjectType getSourceType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum JavaSourceObjectType {
        STUB,
        POINTER,
        OTHER;

    }
}

