/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.CodeGenerator;
import com.ibm.j9ddr.tools.FlagStructureList;
import com.ibm.j9ddr.tools.PointerGenerator;
import com.ibm.j9ddr.tools.store.J9DDRStructureStore;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;

public class StructureStubGenerator
extends CodeGenerator {
    private long count = 0L;

    public StructureStubGenerator() {
        this.opts.put("-p", null);
        this.opts.put("-o", null);
        this.opts.put("-f", null);
        this.opts.put("-s", null);
    }

    public static void main(String[] args) throws Exception {
        StructureStubGenerator app = new StructureStubGenerator();
        app.parseArgs(args);
        app.generateClasses();
        System.out.println("Processing complete : generated " + app.getCount());
    }

    public long getCount() {
        return this.count;
    }

    private void generateClasses() {
        String supersetDirectoryName = (String)this.opts.get("-f");
        String supersetFileName = (String)this.opts.get("-s");
        try {
            J9DDRStructureStore store = new J9DDRStructureStore(supersetDirectoryName, supersetFileName);
            System.out.println("superset directory name : " + supersetDirectoryName);
            System.out.println("superset file name : " + store.getSuperSetFileName());
            InputStream inputStream = store.getSuperset();
            this.structureReader = new StructureReader(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            System.out.println("Could not find file: " + supersetDirectoryName + "/" + supersetFileName);
            return;
        }
        this.outputDir = this.getOutputDir();
        for (StructureReader.StructureDescriptor structure : this.structureReader.getStructures()) {
            String error;
            try {
                if (FlagStructureList.isFlagsStructure(structure.getName())) continue;
                this.generateClass(structure);
            }
            catch (FileNotFoundException e) {
                error = String.format("File Not Found processing: %s: %s", structure.getName(), e.getMessage());
                System.out.println(error);
            }
            catch (IOException e) {
                error = String.format("IOException processing: %s: %s", structure.getName(), e.getMessage());
                System.out.println(error);
            }
        }
    }

    private void generateClass(StructureReader.StructureDescriptor structure) throws IOException {
        String superClassName = structure.getSuperName();
        if (superClassName == "") {
            superClassName = "StructurePointer";
        }
        CodeGenerator.JavaSourceObject srcfile = new CodeGenerator.JavaSourceObject(structure.getName(), CodeGenerator.JavaSourceObjectType.STUB);
        File javaFile = srcfile.getFile();
        byte[] original = null;
        long length = 0L;
        if (javaFile.exists()) {
            length = javaFile.length();
            original = new byte[(int)length];
            FileInputStream fis = new FileInputStream(javaFile);
            fis.read(original);
            fis.close();
        }
        ByteArrayOutputStream newContents = new ByteArrayOutputStream((int)length);
        PrintWriter writer = new PrintWriter(newContents);
        this.writeCopyright(writer);
        writer.println();
        writer.format("package %s;%n", srcfile.getPackageName());
        writer.println();
        this.writeClassComment(writer, srcfile.getClassName());
        writer.format("public final class %s {%n", srcfile.getClassName());
        writer.println();
        this.writeConstants(writer, structure);
        writer.println();
        writer.println("\t// Offsets");
        writer.println();
        this.writeOffsetStubs(writer, structure);
        writer.println();
        this.writeStaticInitializer(writer, structure);
        writer.println("}");
        writer.close();
        byte[] newContentsBytes = newContents.toByteArray();
        if (null == original || !Arrays.equals(original, newContentsBytes)) {
            ++this.count;
            FileOutputStream fos = new FileOutputStream(javaFile);
            fos.write(newContentsBytes);
            fos.close();
        }
    }

    private void writeConstants(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        writer.println("\t// VM Constants");
        writer.println();
        writer.println("\tpublic static final boolean RUNTIME = false;");
        writer.println();
        writer.format("\tpublic static final long %s;%n", "SIZEOF");
        Collections.sort(structure.getConstants());
        for (StructureReader.ConstantDescriptor constant : structure.getConstants()) {
            writer.format("\tpublic static final long %s;%n", constant.getName());
        }
    }

    private void writeConstantInitializer(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        writer.format("\t\t%s = 0x0L;%n", "SIZEOF");
        Collections.sort(structure.getConstants());
        for (StructureReader.ConstantDescriptor constant : structure.getConstants()) {
            writer.format("\t\t%s = 0x0L;%n", constant.getName());
        }
    }

    private void writeStaticInitializer(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        writer.println("\t // Static Initializer");
        writer.println("\tstatic {");
        this.writeConstantInitializer(writer, structure);
        this.writeOffsetInitializer(writer, structure);
        writer.println();
        writer.println("\t\tif (!RUNTIME) {");
        writer.println("\t\t\tthrow new IllegalArgumentException(\"This stub class should not be on your classpath\");");
        writer.println("\t\t}");
        writer.println("\t}");
        writer.println();
    }

    private void writeClassComment(PrintWriter writer, String name) {
        writer.println("/**");
        writer.format(" * Structure: %s%n", name);
        writer.println(" *");
        writer.println(" * This stub class represents a class that can return in memory offsets");
        writer.println(" * to VM C and C++ structures.");
        writer.println(" * ");
        writer.println(" * This particular implementation exists only to allow StructurePointer code to");
        writer.println(" * compile at development time.  This is never loaded at run time.");
        writer.println(" * ");
        writer.println(" * At runtime generated byte codes returning actual offset values from the core file");
        writer.println(" * will be loaded by the StructureClassLoader.");
        writer.println(" */");
        writer.println();
    }

    private void writeOffsetStubs(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        Collections.sort(structure.getFields());
        for (StructureReader.FieldDescriptor fieldDescriptor : structure.getFields()) {
            if (!PointerGenerator.getOffsetConstant(fieldDescriptor).equals(fieldDescriptor.getName())) continue;
            this.writeOffsetStub(writer, fieldDescriptor, structure.getName(), "Offset");
        }
    }

    private void writeOffsetStub(PrintWriter writer, StructureReader.FieldDescriptor fieldDescriptor, String className, String postFix) {
        String getter = fieldDescriptor.getName();
        CTypeParser parser = CTypeParser.fromNative(fieldDescriptor.getType());
        if (parser.getSuffix().contains(":")) {
            writer.format("\tpublic static final int _%s_s_;%n", getter);
            writer.format("\tpublic static final int _%s_b_;%n", getter);
        } else {
            writer.format("\tpublic static final int _%s%s_;%n", getter, postFix);
        }
    }

    private void writeOffsetInitializer(PrintWriter writer, StructureReader.StructureDescriptor structure) {
        Collections.sort(structure.getFields());
        for (StructureReader.FieldDescriptor fieldDescriptor : structure.getFields()) {
            if (!PointerGenerator.getOffsetConstant(fieldDescriptor).equals(fieldDescriptor.getName())) continue;
            String fieldName = fieldDescriptor.getName();
            CTypeParser parser = CTypeParser.fromNative(fieldDescriptor.getType());
            if (parser.getSuffix().contains(":")) {
                String bitfieldName = fieldName;
                writer.format("\t\t_%s_s_ = 0;%n", bitfieldName);
                writer.format("\t\t_%s_b_ = 0;%n", bitfieldName);
                continue;
            }
            writer.format("\t\t_%sOffset_ = 0;%n", fieldName);
        }
    }

    private void parseArgs(String[] args) {
        if (args.length == 0 || args.length % 2 != 0) {
            StructureStubGenerator.printHelp();
            System.exit(1);
        }
        for (int i = 0; i < args.length; i += 2) {
            if (this.opts.containsKey(args[i])) {
                this.opts.put(args[i], args[i + 1]);
                continue;
            }
            System.out.println("Invalid option : " + args[i]);
            StructureStubGenerator.printHelp();
            System.exit(1);
        }
        for (String key : this.opts.keySet()) {
            String value = (String)this.opts.get(key);
            if (value != null || key.equals("-s")) continue;
            System.err.println("The option " + key + " has not been set.\n");
            StructureStubGenerator.printHelp();
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("Usage :\n\njava PointerGenerator -p <package name> -o <output path> -f <path to structure file> [-s <superset file name>]\n");
        System.out.println("<package name>           : the package name for all the generated classes e.g. com.ibm.dtfj.j9.structures");
        System.out.println("<relative output path>   : where to write out the class files.  Full path to base of package hierarchy e.g. c:\\src\\");
        System.out.println("<path to structure file> : full path to the J9 structure file");
        System.out.println("<superset file name>     : optional file name of the superset to be used for input / output");
    }

    private File getOutputDir() {
        String outputPath = (String)this.opts.get("-o");
        if (!outputPath.endsWith("/") || !outputPath.endsWith("\\")) {
            outputPath = outputPath + "/";
        }
        outputPath = outputPath + ((String)this.opts.get("-p")).replace('.', '/');
        System.out.println("Writing generated structure classes to " + outputPath + "/" + "structure".replace('.', '/'));
        File output = new File(outputPath);
        output.mkdirs();
        return output;
    }

    private void writeCopyright(PrintWriter writer) {
        int year = Calendar.getInstance().get(1);
        writer.println("/*******************************************************************************");
        writer.println(" * Licensed Materials - Property of IBM");
        writer.println(" * \"Restricted Materials of IBM\"");
        writer.println(" * ");
        writer.println(" * (c) Copyright IBM Corp. 1991, " + year + " All Rights Reserved");
        writer.println(" * ");
        writer.println(" * US Government Users Restricted Rights - Use, duplication or disclosure");
        writer.println(" * restricted by GSA ADP Schedule Contract with IBM Corp.");
        writer.println(" *******************************************************************************/");
    }
}

