/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.ExpressionEvaluator;
import com.ibm.j9ddr.tools.ddrinteractive.ExpressionEvaluatorException;
import java.io.PrintStream;

public class J9XCommand
extends Command {
    private static final int DEFAULT_LINES = 2;
    private static final int DEFAULT_BYTES_PER_LINE = 16;
    private static final String DEFAULT_SEPARATOR = ",";
    private static final char[] ASCIICodes = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};

    public J9XCommand() {
        this.addCommand("j9x", "<address>", "Hexdump <address>");
        this.addCommand("j9xx", "<address>", "Hexdump <address>");
    }

    private void printHexMemoryDump(PrintStream out, Context context, long addr, long bytesToPrint, int width, int numColumns, boolean doASCII) throws CorruptDataException {
        int column = 0;
        int asciiIndex = 0;
        StringBuffer asciiBuffer = new StringBuffer();
        if (numColumns == 0) {
            return;
        }
        if ((width & width - 1) != 0 || width == 0) {
            return;
        }
        bytesToPrint -= bytesToPrint % (long)width;
        while (bytesToPrint > 0L) {
            int i;
            if (column % numColumns == 0) {
                out.print(String.format("0x%08X : ", addr));
                asciiIndex = 0;
            }
            out.append(" ");
            switch (width) {
                case 1: {
                    out.print(String.format("%02x", context.process.getByteAt(addr)));
                    break;
                }
                case 2: {
                    out.print(String.format("%04x", context.process.getShortAt(addr)));
                    break;
                }
                case 4: {
                    out.print(String.format("%08x", context.process.getIntAt(addr)));
                    break;
                }
                case 8: {
                    out.print(String.format("%016x", context.process.getLongAt(addr)));
                    break;
                }
                default: {
                    out.print(String.format("Invalid width specified\n", new Object[0]));
                    return;
                }
            }
            bytesToPrint -= (long)width;
            if (doASCII) {
                for (i = 0; i < width; ++i) {
                    int asciiCode = context.process.getByteAt(addr + (long)i) & 0xFF;
                    asciiBuffer.insert(asciiIndex++, ASCIICodes[asciiCode]);
                }
            }
            if (column % numColumns == numColumns - 1 || bytesToPrint == 0L) {
                if (doASCII) {
                    for (i = 0; i < (numColumns - 1 - column) * (width * 2 + 1); ++i) {
                        out.append(" ");
                    }
                    out.append(" [ ");
                    out.append(asciiBuffer.substring(0, asciiIndex));
                    out.append(" ] ");
                }
                out.append("\n");
            }
            addr += (long)width;
            column = (column + 1) % numColumns;
        }
    }

    public void run(String command, String[] arguments, Context context, PrintStream out) throws DDRInteractiveCommandException {
        long startAddress;
        if (arguments.length == 0) {
            this.printUsage(out);
            out.println("Unexpected number of arguments.");
            return;
        }
        boolean isRange = false;
        String[] formattedArguments = arguments[0].split(DEFAULT_SEPARATOR);
        if (formattedArguments[0].contains("..")) {
            String[] newArguments = new String[formattedArguments.length + 1];
            String[] rangeArguments = formattedArguments[0].split("\\.\\.");
            if (rangeArguments.length != 2) {
                out.println("Incorrect range specified. Use '..' to separate two addresses in a range, e.g. !j9x address1..address2");
                return;
            }
            newArguments[0] = rangeArguments[0];
            newArguments[1] = rangeArguments[1];
            System.arraycopy(formattedArguments, 1, newArguments, 2, formattedArguments.length - 1);
            formattedArguments = newArguments;
            isRange = true;
        }
        try {
            startAddress = ExpressionEvaluator.eval(formattedArguments[0]);
        }
        catch (ExpressionEvaluatorException e) {
            out.println("Invalid start address specified.");
            this.printUsage(out);
            return;
        }
        long bytesToPrint = 32L;
        int bytesPerPointer = context.process.bytesPerPointer();
        int numColumns = 0;
        int argCount = formattedArguments.length;
        switch (argCount) {
            case 4: {
                numColumns = Integer.valueOf(formattedArguments[3]);
                if (numColumns < 1) {
                    out.println("Invalid number of columns specified.");
                    this.printUsage(out);
                    return;
                }
            }
            case 3: {
                boolean validSize;
                bytesPerPointer = Integer.valueOf(formattedArguments[2]);
                boolean bl = validSize = bytesPerPointer == 1 || bytesPerPointer == 2 || bytesPerPointer == 4 || bytesPerPointer == 8;
                if (!validSize) {
                    out.println("Invalid pointer size specified.");
                    this.printUsage(out);
                    return;
                }
            }
            case 2: {
                try {
                    if (!isRange) {
                        if (formattedArguments[1].startsWith("-")) {
                            bytesToPrint = ExpressionEvaluator.eval(formattedArguments[1].substring(1), 16);
                            startAddress -= bytesToPrint;
                            break;
                        }
                        bytesToPrint = ExpressionEvaluator.eval(formattedArguments[1], 16);
                        break;
                    }
                    long endAddress = ExpressionEvaluator.eval(formattedArguments[1]);
                    bytesToPrint = endAddress - startAddress;
                    break;
                }
                catch (ExpressionEvaluatorException e) {
                    if (!isRange) {
                        out.println("Invalid count specified.");
                    } else {
                        out.println("Invalid end address specified.");
                    }
                    this.printUsage(out);
                    return;
                }
            }
            case 1: {
                break;
            }
            default: {
                this.printUsage(out);
                return;
            }
        }
        if (numColumns == 0) {
            numColumns = 16 / bytesPerPointer;
        }
        bytesToPrint -= bytesToPrint % (long)bytesPerPointer;
        try {
            this.printHexMemoryDump(out, context, startAddress, bytesToPrint, bytesPerPointer, numColumns, true);
        }
        catch (Exception e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    public String[] splitArguments(String[] args) {
        return this.splitArguments(args, DEFAULT_SEPARATOR);
    }

    public String[] splitArguments(String[] args, String separators) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]);
        }
        String arg = sb.toString();
        return arg.split(separators);
    }

    private void printUsage(PrintStream out) {
        out.append("Usage:\n");
        out.append("  !j9x address                                              : display bytes at address\n");
        out.append("  !j9x address,count                                        : display count bytes from address\n");
        out.append("  !j9x address,-count                                       : display count bytes backwards from address\n");
        out.append("  !j9x startAddress..endAddress                             : display bytes between startAddress and endAddress\n");
        out.append("  !j9x [address,count|startAddress..endAddress],[1|2|4|8]   : set word size in output to 1,2,4 or 8 bytes\n");
        out.append("  !j9x [address,count|startAddress..endAddress],[1|2|4|8],n : format output to have n columns of words per row\n");
        out.append("The address, count, startAddress and endAddress parameters can be decimal or hexadecimal ('0x' prefix indicates hexadecimal, 'd' prefix indicates decimal).\n");
        out.append("If no prefix is specified the 'count' parameter is hexadecimal by default, all other parameters default to decimal.\n");
        out.append("For example:\n");
        out.append("  !j9x 0x7fa54800d4cf,20");
        out.append("  !j9x 0x7fa54800d4cf..0x7fa54800d4ef");
        out.append("  !j9x 0x7fa54800d4cf,d32,8,4");
        out.append("The address, count, startAddress and endAddress parameters can be expressions, for example:\n");
        out.append("  !j9x 0x7fa54800d4cf+32\n");
        out.append("  !j9x 0x7fa54800d4cf+0x20\n");
        out.append("  !j9x 0x7fa54800d4cf+(32*4)\n");
    }
}

