/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import java.io.PrintStream;
import java.util.Collection;

public class MemoryRangesCommand
extends Command {
    public MemoryRangesCommand() {
        this.addCommand("ranges", "", "Prints list of available memory ranges");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        IProcess process = context.process;
        String format = "0x%0" + process.bytesPerPointer() * 2 + "x%" + (16 - process.bytesPerPointer()) + "s";
        Collection<? extends IMemoryRange> ranges = process.getMemoryRanges();
        if (ranges != null && !ranges.isEmpty()) {
            out.println("Base                  Top                   Size");
            for (IMemoryRange iMemoryRange : ranges) {
                out.print(String.format(format, iMemoryRange.getBaseAddress(), " "));
                out.print(String.format(format, iMemoryRange.getTopAddress(), " "));
                out.print(String.format(format, iMemoryRange.getSize(), " "));
                out.print("\n");
            }
        } else {
            out.println("No memory ranges found (Note: this has not yet been implemented for execution from a native debugger such as gdb)");
        }
    }
}

