/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.J9DDRClassLoader;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.DDRInteractiveClassLoader;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.PluginConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingVMData
implements IVMData {
    private final Logger logger = Logger.getLogger("j9ddr.interactive.context");

    @Override
    public void bootstrap(String classname, Object ... userData) throws ClassNotFoundException {
    }

    @Override
    public void bootstrapRelative(String relativeClassname, Object ... userData) throws ClassNotFoundException {
        if (relativeClassname.equals("tools.ddrinteractive.FindVMTask")) {
            long[] passBackArray = (long[])userData[0];
            passBackArray[0] = 0L;
            return;
        }
        if (relativeClassname.equals("tools.ddrinteractive.GetCommandsTask")) {
            Object[] passbackArray = (Object[])userData[0];
            Object loader = passbackArray[1];
            LinkedList<ICommand> toPassBack = new LinkedList<ICommand>();
            this.loadPlugins(toPassBack, loader);
            passbackArray[0] = toPassBack;
            return;
        }
        throw new ClassNotFoundException("The bootstrap relative class " + relativeClassname + " was not recognised");
    }

    private void loadPlugins(List<ICommand> toPassBack, Object obj) {
        if (!(obj instanceof DDRInteractiveClassLoader)) {
            this.logger.fine("Plugin classloader is not an instance of DRRInteractiveClassLoader. No plugins have been loaded");
            return;
        }
        DDRInteractiveClassLoader loader = (DDRInteractiveClassLoader)obj;
        for (PluginConfig plugin : loader.getPlugins()) {
            try {
                ICommand command = plugin.newInstance();
                toPassBack.add(command);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Failed to create an instance of " + plugin.getId(), e);
            }
        }
    }

    @Override
    public Collection<StructureReader.StructureDescriptor> getStructures() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public J9DDRClassLoader getClassLoader() {
        return null;
    }

    @Override
    public String getVersion() {
        return "Missing VM";
    }
}

