/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive.plugins;

import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginConfig {
    private final String vmversion;
    private final URL url;
    private final boolean enabled;
    private final String id;
    private final Class<ICommand> command;
    private final Throwable t;

    public PluginConfig(String id, String vmversion, Class<ICommand> command, boolean enabled, URL url) {
        this.id = id;
        this.vmversion = vmversion;
        this.command = command;
        this.enabled = enabled;
        this.url = url;
        this.t = null;
    }

    public PluginConfig(String id, Throwable t, URL url) {
        this.id = id;
        this.t = t;
        this.vmversion = "Unknown";
        this.command = null;
        this.enabled = false;
        this.url = url;
    }

    public Throwable getError() {
        return this.t;
    }

    public String getVmversion() {
        return this.vmversion;
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public ICommand newInstance() throws DDRInteractiveCommandException {
        try {
            return this.command.newInstance();
        }
        catch (Exception e) {
            throw new DDRInteractiveCommandException("Failed to create a new instance of command " + this.command.getClass().getName(), e);
        }
    }

    public String toCSV() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.id);
        builder.append(',');
        builder.append(this.vmversion);
        builder.append(',');
        builder.append(this.enabled);
        builder.append(',');
        builder.append(this.url);
        builder.append(',');
        if (null != this.t) {
            builder.append(this.t.getClass().getName());
        }
        return builder.toString();
    }
}

