/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm23.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm23.j9.J9ROMFieldShapeIterator;
import com.ibm.j9ddr.vm23.pointer.CorruptPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm23.structure.J9Consts;
import com.ibm.j9ddr.vm23.structure.J9Object;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.UDATA;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class J9ObjectFieldOffsetIterator_V1
extends J9ObjectFieldOffsetIterator {
    private J9ROMClassPointer romClass;
    private J9ClassPointer superClazz;
    private Iterator fields;
    private J9ClassPointer clazz;
    private U32 doubleCount = new U32(0L);
    private U32 doubleSeen = new U32(0L);
    private U32 doubleStaticsSeen = new U32(0L);
    private U32 objectCount = new U32(0L);
    private U32 objectsSeen = new U32(0L);
    private U32 objectStaticsSeen = new U32(0L);
    private U32 singleCount = new U32(0L);
    private U32 singlesSeen = new U32(0L);
    private U32 singleStaticsSeen = new U32(0L);
    private U32 walkFlags = new U32(0L);
    private J9ROMFieldShapePointer field;
    private UDATA index = new UDATA(0L);
    private UDATA instanceSize = new UDATA(0L);
    private UDATA offset = new UDATA(0L);
    private UDATA superTotalInstanceSize = new UDATA(0L);
    private Object next;

    protected J9ObjectFieldOffsetIterator_V1(J9ClassPointer clazz, J9ClassPointer superClazz, U32 flags) {
        this.clazz = clazz;
        this.superClazz = superClazz;
        this.walkFlags = flags;
    }

    private void init() throws CorruptDataException {
        this.romClass = this.clazz.romClass();
        this.initInstanceSize(this.romClass, this.superClazz);
        this.fields = new J9ROMFieldShapeIterator(this.romClass.romFields(), this.romClass.romFieldCount());
    }

    private void nextImpl() throws CorruptDataException {
        this.field = null;
        while (this.fields.hasNext()) {
            J9ROMFieldShapePointer localField = (J9ROMFieldShapePointer)this.fields.next();
            U32 modifiers = localField.modifiers();
            this.index = this.index.add(1L);
            if (modifiers.anyBitsIn(8L)) {
                if (!this.walkFlags.anyBitsIn(1L)) continue;
                if (modifiers.anyBitsIn(131072L)) {
                    this.offset = new UDATA(this.objectStaticsSeen.mult(UDATA.SIZEOF));
                    this.objectStaticsSeen = this.objectStaticsSeen.add(1);
                    this.field = localField;
                    break;
                }
                if (this.walkFlags.anyBitsIn(8L)) continue;
                if (modifiers.anyBitsIn(262144L)) {
                    UDATA doubleSlots = J9BuildFlags.env_data64 ? new UDATA(this.romClass.objectStaticCount().add(this.romClass.singleScalarStaticCount())) : new UDATA(this.romClass.objectStaticCount().add(this.romClass.singleScalarStaticCount()).add(1)).rightShift(1);
                    this.offset = doubleSlots.mult(8).add(this.doubleStaticsSeen.mult(8));
                    this.doubleStaticsSeen = this.doubleStaticsSeen.add(1);
                } else {
                    this.offset = new UDATA(this.romClass.objectStaticCount().mult(UDATA.SIZEOF).add(this.singleStaticsSeen.mult(UDATA.SIZEOF)));
                    this.singleStaticsSeen = this.singleStaticsSeen.add(1);
                }
                this.field = localField;
                break;
            }
            if (!this.walkFlags.anyBitsIn(2L)) continue;
            this.offset = new UDATA(this.superTotalInstanceSize);
            if (modifiers.anyBitsIn(131072L)) {
                this.offset = this.offset.add(this.doubleCount.mult(8).add(this.objectsSeen.mult(UDATA.SIZEOF)));
                if (J9BuildFlags.opt_alignLongVolatileFieldOffsets && this.walkFlags.anyBitsIn(4L)) {
                    this.offset = this.offset.add(4L);
                }
                this.objectsSeen = this.objectsSeen.add(1);
                this.field = localField;
                break;
            }
            if (this.walkFlags.anyBitsIn(8L)) continue;
            if (modifiers.anyBitsIn(262144L)) {
                this.offset = this.offset.add(this.doubleSeen.mult(8));
                if (J9BuildFlags.opt_alignLongVolatileFieldOffsets && this.walkFlags.anyBitsIn(4L)) {
                    this.offset = this.offset.add(4L);
                }
                this.doubleSeen = this.doubleSeen.add(1);
            } else {
                if (J9BuildFlags.opt_alignLongVolatileFieldOffsets) {
                    if (!this.walkFlags.anyBitsIn(4L) || this.singlesSeen.gt(0)) {
                        this.offset = this.offset.add(this.doubleCount.mult(8).add(this.objectCount.mult(UDATA.SIZEOF)).add(this.singlesSeen.mult(4)));
                    }
                } else {
                    this.offset = this.offset.add(this.doubleCount.mult(8).add(this.objectCount.mult(UDATA.SIZEOF)).add(this.singlesSeen.mult(4)));
                }
                this.singlesSeen = this.singlesSeen.add(1);
            }
            this.field = localField;
            break;
        }
    }

    private void initInstanceSize(J9ROMClassPointer romClass, J9ClassPointer superClazz) throws CorruptDataException {
        boolean volatileLongFound = false;
        if (!this.walkFlags.anyBitsIn(18L)) {
            return;
        }
        if (J9BuildFlags.opt_alignLongVolatileFieldOffsets) {
            volatileLongFound = false;
        }
        UDATA uDATA = this.superTotalInstanceSize = superClazz.isNull() ? new UDATA(0L) : superClazz.totalInstanceSize();
        if (J9BuildFlags.thr_lockNursery && superClazz.notNull() && superClazz.classDepthAndFlags().anyBitsIn(J9Consts.J9_JAVA_CLASS_DEPTH_MASK)) {
            this.superTotalInstanceSize = this.superTotalInstanceSize.sub(UDATA.SIZEOF);
        }
        J9ROMFieldShapeIterator fields = new J9ROMFieldShapeIterator(romClass.romFields(), romClass.romFieldCount());
        while (fields.hasNext()) {
            J9ROMFieldShapePointer field = (J9ROMFieldShapePointer)fields.next();
            U32 modifiers = field.modifiers();
            if (modifiers.anyBitsIn(8L)) continue;
            if (modifiers.anyBitsIn(131072L)) {
                this.objectCount = this.objectCount.add(1);
                continue;
            }
            if (modifiers.anyBitsIn(262144L)) {
                this.doubleCount = this.doubleCount.add(1);
                if (!J9BuildFlags.opt_alignLongVolatileFieldOffsets || !modifiers.anyBitsIn(64L)) continue;
                volatileLongFound = true;
                continue;
            }
            this.singleCount = this.singleCount.add(1);
        }
        this.instanceSize = new UDATA(this.singleCount.mult(4).add(this.objectCount.mult(UDATA.SIZEOF)).add(this.doubleCount.mult(8)));
        if (J9BuildFlags.opt_alignLongVolatileFieldOffsets && volatileLongFound && (this.superTotalInstanceSize.longValue() + J9Object.SIZEOF & 4L) != 0L) {
            this.walkFlags = this.walkFlags.bitOr(4L);
            if (this.singleCount.longValue() == 0L) {
                this.instanceSize = this.instanceSize.add(4L);
            }
        }
        if (J9BuildFlags.thr_lockNursery && this.checkLockwordNeeded(romClass, superClazz, false, null)) {
            this.instanceSize = this.instanceSize.add(UDATA.SIZEOF);
        }
        if (J9BuildFlags.env_data64 && this.instanceSize.anyBitsIn(4L)) {
            this.instanceSize = this.instanceSize.add(4L);
        }
    }

    private boolean checkLockwordNeeded(J9ROMClassPointer romClass, J9ClassPointer superClazz, boolean b, Object object) {
        return false;
    }

    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        this.next = this.getNext();
        return this.next != null;
    }

    private Object getNext() {
        if (this.fields == null) {
            try {
                this.init();
            }
            catch (CorruptDataException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            this.field = null;
            this.nextImpl();
            if (this.field != null) {
                return new J9ObjectFieldOffset(this.field, this.offset);
            }
            return null;
        }
        catch (AddressedCorruptDataException e) {
            return CorruptPointer.cast(e.getAddress());
        }
        catch (CorruptDataException e) {
            return CorruptPointer.NULL;
        }
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object toReturn = this.next;
        this.next = null;
        return toReturn;
    }
}

