/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm23.j9.MonitorTable;
import com.ibm.j9ddr.vm23.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ThreadMonitorPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm23.structure.J9AbstractThread;
import com.ibm.j9ddr.vm23.structure.J9Consts;
import com.ibm.j9ddr.vm23.structure.J9Object;
import com.ibm.j9ddr.vm23.structure.J9ThreadAbstractMonitor;
import com.ibm.j9ddr.vm23.structure.J9VMThread;
import com.ibm.j9ddr.vm23.types.UDATA;
import java.util.HashMap;
import java.util.Iterator;

public class J9VMThreadPointerUtil {
    private static int STATE_ALIVE = 1;
    private static int STATE_TERMINATED = 2;
    private static int STATE_RUNNABLE = 4;
    private static int STATE_WAITING_INDEFINITELY = 16;
    private static int STATE_WAITING_WITH_TIMEOUT = 32;
    private static int STATE_SLEEPING = 64;
    private static int STATE_WAITING = 128;
    private static int STATE_IN_OBJECT_WAIT = 256;
    private static int STATE_PARKED = 512;
    private static int STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static int STATE_SUSPENDED = 0x100000;
    private static int STATE_INTERRUPTED = 0x200000;
    private static int STATE_IN_NATIVE = 0x400000;
    private static int STATE_VENDOR_1 = 0x10000000;
    private static int STATE_VENDOR_2 = 0x20000000;
    private static int STATE_VENDOR_3 = 0x40000000;
    private static final int J9THREAD_MONITOR_OBJECT = 393216;
    private static final HashMap<Long, Integer> threadStateMap = new HashMap(9);

    public static int getDTFJState(J9VMThreadPointer vmThread) throws CorruptDataException {
        try {
            return threadStateMap.get(J9VMThreadPointerUtil.getJ9State(vmThread).state);
        }
        catch (NullPointerException e) {
            return STATE_VENDOR_3;
        }
    }

    public static ThreadInfo getJ9State(J9VMThreadPointer vmThread) throws CorruptDataException {
        return AlgorithmVersion.getVersionOf("ALG_J9VMTHREADPOINTERUTIL_VERSION").getAlgorithmVersion() == 1 ? J9VMThreadPointerUtil.getJ9State_V1(vmThread) : J9VMThreadPointerUtil.getJ9State_V0(vmThread);
    }

    public static ThreadInfo getJ9State_V0(J9VMThreadPointer vmThread) throws CorruptDataException {
        ThreadInfo thrinfo = new ThreadInfo();
        if (vmThread.isNull()) {
            thrinfo.state = new UDATA(J9VMThread.J9VMTHREAD_STATE_UNKNOWN).longValue();
            return thrinfo;
        }
        thrinfo.thread = vmThread;
        long vmstate = J9VMThread.J9VMTHREAD_STATE_RUNNING;
        UDATA publicFlags = vmThread.publicFlags();
        J9ThreadPointer j9self = vmThread.osThread();
        ThreadState j9state = new ThreadState(j9self);
        if (publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_BLOCKED | J9Consts.J9_PUBLIC_FLAGS_THREAD_WAITING)) {
            thrinfo.lockObject = vmThread.blockingEnterObject();
            UDATA lockWord = vmThread.blockingEnterObject().monitor();
            if (lockWord.anyBitsIn(J9Object.OBJECT_HEADER_LOCK_INFLATED)) {
                J9ThreadAbstractMonitorPointer objmon = J9ThreadAbstractMonitorPointer.cast(lockWord.bitAnd(J9Object.OBJECT_HEADER_LOCK_INFLATED ^ 0xFFFFFFFFFFFFFFFFL));
                if (objmon.notNull()) {
                    J9ThreadPointer j9owner = objmon.owner();
                    if (publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_BLOCKED)) {
                        if (j9owner.notNull() && !j9owner.equals(j9self)) {
                            vmstate = J9VMThread.J9VMTHREAD_STATE_BLOCKED;
                            thrinfo.rawLock = J9ThreadMonitorPointer.cast(objmon);
                        }
                    } else if (j9self.isNull()) {
                        vmstate = publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_TIMED) ? J9VMThread.J9VMTHREAD_STATE_WAITING_TIMED : J9VMThread.J9VMTHREAD_STATE_WAITING;
                        thrinfo.rawLock = J9ThreadMonitorPointer.cast(objmon);
                    } else if (J9ThreadMonitorPointer.cast(objmon).equals(j9state.blocker)) {
                        vmstate = J9VMThreadPointerUtil.getInflatedMonitorState(j9self, j9state, thrinfo);
                    }
                }
            } else {
                J9VMThreadPointer lockOwner = J9VMThreadPointer.cast(lockWord.bitAnd(J9Object.OBJECT_HEADER_LOCK_BITS_MASK ^ 0xFFFFFFFFFFFFFFFFL));
                if (lockOwner.notNull() && !lockOwner.equals(vmThread)) {
                    vmstate = J9VMThread.J9VMTHREAD_STATE_BLOCKED;
                    MonitorTable table = MonitorTable.fromJ9JavaVM(vmThread.javaVM());
                    Iterator<J9ThreadAbstractMonitorPointer> monitors = table.iterator();
                    while (monitors.hasNext()) {
                        J9ThreadAbstractMonitorPointer ptr = monitors.next();
                        UDATA lock = UDATA.cast(thrinfo.lockObject);
                        if (!ptr.userData().eq(lock)) continue;
                        thrinfo.rawLock = J9ThreadMonitorPointer.cast(ptr);
                        break;
                    }
                }
            }
        } else if (publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_PARKED)) {
            if (j9self.isNull() || j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_PARKED)) {
                thrinfo.lockObject = vmThread.blockingEnterObject();
                vmstate = publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_TIMED) ? J9VMThread.J9VMTHREAD_STATE_PARKED_TIMED : J9VMThread.J9VMTHREAD_STATE_PARKED;
            }
        } else if (publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_SLEEPING)) {
            if (j9self.isNull() || j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_SLEEPING)) {
                vmstate = J9VMThread.J9VMTHREAD_STATE_SLEEPING;
            }
        } else if (j9self.isNull()) {
            vmstate = J9VMThread.J9VMTHREAD_STATE_UNKNOWN;
        } else if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_PARKED)) {
            vmstate = j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_TIMER_SET) ? J9VMThread.J9VMTHREAD_STATE_PARKED_TIMED : J9VMThread.J9VMTHREAD_STATE_PARKED;
        } else if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_SLEEPING)) {
            vmstate = J9VMThread.J9VMTHREAD_STATE_SLEEPING;
        } else if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_DEAD)) {
            vmstate = J9VMThread.J9VMTHREAD_STATE_DEAD;
        }
        if (J9VMThread.J9VMTHREAD_STATE_RUNNING == vmstate) {
            thrinfo.lockObject = null;
            vmstate = J9VMThreadPointerUtil.getInflatedMonitorState(j9self, j9state, thrinfo);
        }
        if (thrinfo.rawLock != null && thrinfo.rawLock.flags().allBitsIn(393216L)) {
            thrinfo.lockObject = J9ObjectPointer.cast(thrinfo.rawLock.userData());
        }
        if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_INTERRUPTED)) {
            vmstate |= J9VMThread.J9VMTHREAD_STATE_INTERRUPTED;
        }
        if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_SUSPENDED)) {
            vmstate |= J9VMThread.J9VMTHREAD_STATE_SUSPENDED;
        }
        if (publicFlags.anyBitsIn(J9Consts.J9_PUBLIC_FLAGS_HALT_THREAD_JAVA_SUSPEND)) {
            vmstate |= J9VMThread.J9VMTHREAD_STATE_SUSPENDED;
        }
        thrinfo.state = new UDATA(vmstate).longValue();
        return thrinfo;
    }

    public static ThreadInfo getJ9State_V1(J9VMThreadPointer vmThread) throws CorruptDataException {
        ThreadInfo thrinfo = new ThreadInfo();
        thrinfo.thread = vmThread;
        if (vmThread.isNull()) {
            thrinfo.state = new UDATA(J9VMThread.J9VMTHREAD_STATE_UNKNOWN).longValue();
            return thrinfo;
        }
        J9ThreadMonitorPointer activeMonitor = vmThread.activeMonitor();
        J9ThreadMonitorPointer blockingMonitor = J9ThreadMonitorPointer.NULL;
        J9VMThreadPointer owner = J9VMThreadPointer.NULL;
        long status = J9VMThread.J9VMTHREAD_STATE_RUNNING;
        if (activeMonitor.notNull()) {
            J9ThreadAbstractMonitorPointer monitorStruct = J9ThreadAbstractMonitorPointer.cast(activeMonitor);
            blockingMonitor = J9ThreadMonitorPointer.cast(monitorStruct);
            status = J9VMThread.J9VMTHREAD_STATE_BLOCKED;
            if (monitorStruct.flags().anyBitsIn(J9ThreadAbstractMonitor.J9THREAD_MONITOR_INFLATED)) {
                J9ThreadPointer j9ThreadOwner = J9ThreadPointer.cast(monitorStruct.owner());
                if (j9ThreadOwner.notNull()) {
                    owner = J9VMThreadPointer.cast(J9VMThreadPointerUtil.j9thread_tls_get(j9ThreadOwner, vmThread.javaVM().vmThreadKey()));
                    if (owner.equals(vmThread)) {
                        blockingMonitor = J9ThreadMonitorPointer.NULL;
                        owner = J9VMThreadPointer.NULL;
                        status = J9VMThread.J9VMTHREAD_STATE_RUNNING;
                    }
                } else {
                    blockingMonitor = J9ThreadMonitorPointer.NULL;
                    owner = J9VMThreadPointer.NULL;
                    status = J9VMThread.J9VMTHREAD_STATE_RUNNING;
                }
            } else {
                UDATA monitor = null;
                J9ObjectPointer object = J9ObjectPointer.cast(monitorStruct.userData());
                if (J9BuildFlags.thr_lockNursery) {
                    throw new UnsupportedOperationException("Thread Lock Nursery not implemented for Java5 SR9");
                }
                monitor = object.monitor();
                owner = J9VMThreadPointer.cast(monitor.bitAnd(-256));
                thrinfo.lockObject = object;
            }
        } else {
            blockingMonitor = vmThread.osThread().monitor();
            UDATA flags = vmThread.osThread().flags();
            if (blockingMonitor.notNull()) {
                J9ThreadPointer osOwner = J9ThreadPointer.cast(J9ThreadAbstractMonitorPointer.cast(blockingMonitor).owner());
                owner = J9VMThreadPointer.cast(osOwner.notNull() ? J9VMThreadPointerUtil.j9thread_tls_get(osOwner, vmThread.javaVM().vmThreadKey()) : UDATA.cast(J9VMThreadPointer.NULL));
            }
            if (flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_BLOCKED)) {
                if (owner.equals(vmThread)) {
                    owner = J9VMThreadPointer.NULL;
                    blockingMonitor = J9ThreadMonitorPointer.NULL;
                    status = J9VMThread.J9VMTHREAD_STATE_RUNNING;
                } else {
                    status = J9VMThread.J9VMTHREAD_STATE_BLOCKED;
                }
            } else if (flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_WAITING)) {
                if (owner.equals(vmThread)) {
                    owner = J9VMThreadPointer.NULL;
                    blockingMonitor = J9ThreadMonitorPointer.NULL;
                    status = J9VMThread.J9VMTHREAD_STATE_RUNNING;
                } else {
                    status = J9VMThread.J9VMTHREAD_STATE_WAITING;
                }
            } else if (flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_SLEEPING)) {
                status = J9VMThread.J9VMTHREAD_STATE_SLEEPING;
            } else if (flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_SUSPENDED)) {
                status = J9VMThread.J9VMTHREAD_STATE_SUSPENDED;
            } else if (flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_DEAD)) {
                status = J9VMThread.J9VMTHREAD_STATE_DEAD;
            }
        }
        thrinfo.lockOwner = owner;
        thrinfo.rawLock = blockingMonitor;
        thrinfo.state = new UDATA(status).longValue();
        return thrinfo;
    }

    private static UDATA j9thread_tls_get(J9ThreadPointer thread, UDATA key) throws CorruptDataException {
        return UDATA.cast(thread.tlsEA().add(key.sub(1L)));
    }

    private static long getInflatedMonitorState(J9ThreadPointer j9self, ThreadState j9state, ThreadInfo thrinfo) {
        if (j9self.isNull()) {
            return J9VMThread.J9VMTHREAD_STATE_UNKNOWN;
        }
        if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_BLOCKED) && j9state.owner.notNull() && !j9state.owner.equals(j9self)) {
            thrinfo.rawLock = j9state.blocker;
            return J9VMThread.J9VMTHREAD_STATE_BLOCKED;
        }
        if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_WAITING) && !j9state.owner.equals(j9self)) {
            thrinfo.rawLock = j9state.blocker;
            if (j9state.flags.anyBitsIn(J9AbstractThread.J9THREAD_FLAG_TIMER_SET)) {
                return J9VMThread.J9VMTHREAD_STATE_WAITING_TIMED;
            }
            return J9VMThread.J9VMTHREAD_STATE_WAITING;
        }
        return J9VMThread.J9VMTHREAD_STATE_RUNNING;
    }

    static {
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_DEAD, STATE_TERMINATED);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_SUSPENDED, STATE_ALIVE | STATE_SUSPENDED);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_RUNNING, STATE_ALIVE | STATE_RUNNABLE);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_BLOCKED, STATE_ALIVE | STATE_BLOCKED_ON_MONITOR_ENTER);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_WAITING, STATE_ALIVE | STATE_WAITING | STATE_WAITING_INDEFINITELY | STATE_IN_OBJECT_WAIT);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_WAITING_TIMED, STATE_ALIVE | STATE_WAITING | STATE_WAITING_WITH_TIMEOUT | STATE_IN_OBJECT_WAIT);
        threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_SLEEPING, STATE_ALIVE | STATE_WAITING | STATE_SLEEPING);
        if (AlgorithmVersion.getVersionOf("ALG_J9VMTHREADPOINTERUTIL_VERSION").getAlgorithmVersion() == 0) {
            threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_PARKED, STATE_ALIVE | STATE_WAITING | STATE_WAITING_INDEFINITELY | STATE_PARKED);
            threadStateMap.put(J9VMThread.J9VMTHREAD_STATE_PARKED_TIMED, STATE_ALIVE | STATE_WAITING | STATE_WAITING_WITH_TIMEOUT | STATE_PARKED);
        }
    }

    public static class ThreadInfo {
        private long state = 0L;
        private J9ObjectPointer lockObject;
        private J9ThreadMonitorPointer rawLock;
        private J9VMThreadPointer lockOwner;
        private J9VMThreadPointer thread;

        private ThreadInfo() {
        }

        public long getState() {
            return this.state;
        }

        public J9ObjectPointer getLockObject() {
            return this.lockObject;
        }

        public J9ThreadMonitorPointer getRawLock() {
            return this.rawLock;
        }

        public J9VMThreadPointer getLockOwner() {
            return this.lockOwner;
        }

        public J9VMThreadPointer getThread() {
            return this.thread;
        }
    }

    private static class ThreadState {
        private UDATA flags;
        private J9ThreadMonitorPointer blocker;
        private J9ThreadPointer owner;

        public ThreadState(J9ThreadPointer j9self) throws CorruptDataException {
            if (j9self.isNull()) {
                this.flags = new UDATA(0L);
                this.blocker = J9ThreadMonitorPointer.NULL;
                this.owner = J9ThreadPointer.NULL;
            } else {
                this.flags = j9self.flags();
                this.blocker = j9self.monitor();
                this.owner = this.blocker.isNull() ? J9ThreadPointer.NULL : this.blocker.owner();
            }
        }
    }
}

