/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm23.j9.gc.GCContiguousArrayObjectModel_V1;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.structure.J9IndexableObject;
import com.ibm.j9ddr.vm23.types.U32;
import com.ibm.j9ddr.vm23.types.UDATA;

public abstract class GCArrayObjectModel {
    protected J9JavaVMPointer vm;

    protected GCArrayObjectModel(J9JavaVMPointer vm) throws CorruptDataException {
        this.vm = vm;
    }

    public static GCArrayObjectModel fromJ9JavaVM(J9JavaVMPointer vm) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_CONTIGUOUS_ARRAY_OBJECT_MODEL_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCContiguousArrayObjectModel_V1(vm);
    }

    public abstract UDATA getSizeInBytesWithoutHeader(J9ClassPointer var1, J9IndexableObjectPointer var2) throws CorruptDataException;

    public abstract UDATA getSizeInBytesWithoutHeader(J9ClassPointer var1, UDATA var2) throws CorruptDataException;

    public UDATA getSizeInBytesWithoutHeader(J9IndexableObjectPointer array) throws CorruptDataException {
        return this.getSizeInBytesWithoutHeader(array.clazz(), array);
    }

    public UDATA getSizeInBytesWithHeader(J9ClassPointer clazz, J9IndexableObjectPointer array) throws CorruptDataException {
        return this.getSizeInBytesWithoutHeader(clazz, array).add(new UDATA(J9IndexableObject.SIZEOF));
    }

    public UDATA getSizeInBytesWithHeader(J9IndexableObjectPointer array) throws CorruptDataException {
        return this.getSizeInBytesWithoutHeader(array).add(new UDATA(J9IndexableObject.SIZEOF));
    }

    public UDATA getSizeInSlotsWithoutHeader(J9IndexableObjectPointer array) throws CorruptDataException {
        return UDATA.convertBytesToSlots(this.getSizeInBytesWithoutHeader(array));
    }

    public UDATA getSizeInSlotsWithHeader(J9IndexableObjectPointer array) throws CorruptDataException {
        return UDATA.convertBytesToSlots(this.getSizeInBytesWithHeader(array));
    }

    public UDATA getSizeInElements(J9IndexableObjectPointer array) throws CorruptDataException {
        U32 size = array.size();
        if (size.anyBitsIn(Integer.MIN_VALUE)) {
            throw new CorruptDataException("java array size with sign bit set");
        }
        return new UDATA(size);
    }
}

