/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm23.structure.J9Consts;
import java.util.ArrayList;
import java.util.Iterator;

public class GCClassArrayClassSlotIterator
extends GCIterator {
    protected Iterator<J9ClassPointer> slotIterator;

    protected GCClassArrayClassSlotIterator(J9ClassPointer clazz) throws CorruptDataException {
        ArrayList<J9ClassPointer> slots = new ArrayList<J9ClassPointer>();
        J9ClassPointer slot = clazz.arrayClass();
        if (slot.notNull()) {
            slots.add(slot);
        }
        if (clazz.romClass().modifiers().allBitsIn(J9Consts.J9_JAVA_CLASS_ARRAY)) {
            J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(clazz);
            slot = arrayClass.componentType();
            if (slot.notNull()) {
                slots.add(slot);
            }
            if ((slot = arrayClass.leafComponentType()).notNull()) {
                slots.add(slot);
            }
        }
        this.slotIterator = slots.iterator();
    }

    public static GCClassArrayClassSlotIterator fromJ9Class(J9ClassPointer clazz) throws CorruptDataException {
        return new GCClassArrayClassSlotIterator(clazz);
    }

    public boolean hasNext() {
        return this.slotIterator.hasNext();
    }

    public J9ClassPointer next() {
        return this.slotIterator.next();
    }
}

