/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm23.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm23.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm23.j9.gc.GCIterator;
import com.ibm.j9ddr.vm23.j9.gc.GCObjectHeapIteratorAddressOrderedList_V1;
import com.ibm.j9ddr.vm23.j9.gc.GCObjectModel;
import com.ibm.j9ddr.vm23.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm23.pointer.generated.J9ObjectPointer;

public abstract class GCObjectHeapIterator
extends GCIterator {
    protected GCObjectModel objectModel;
    protected J9MemorySegmentPointer segment;
    protected boolean includeLiveObjects;
    protected boolean includeDeadObjects;

    protected GCObjectHeapIterator(J9JavaVMPointer vm, J9MemorySegmentPointer segment, boolean includeLiveObjects, boolean includeDeadObjects) throws CorruptDataException {
        this.segment = segment;
        this.objectModel = GCObjectModel.fromJ9JavaVM(vm);
        this.includeLiveObjects = includeLiveObjects;
        this.includeDeadObjects = includeDeadObjects;
    }

    public static GCObjectHeapIterator fromJ9MemorySegment(J9JavaVMPointer vm, J9MemorySegmentPointer segment, boolean includeLiveObjects, boolean includeDeadObjects) throws CorruptDataException {
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_OBJECT_HEAP_ITERATOR_ADDRESS_ORDERED_LIST_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCObjectHeapIteratorAddressOrderedList_V1(vm, segment, includeLiveObjects, includeDeadObjects);
    }

    public abstract J9ObjectPointer next();
}

